/*
 * Decompiled with CFR 0.152.
 */
package middlegen.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.Permission;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import middlegen.Middlegen;
import middlegen.MiddlegenException;
import middlegen.MiddlegenTask;
import middlegen.swing.JDatabasePanel;
import middlegen.swing.JSettingsTabPane;
import org.apache.log4j.Category;

public class JMiddlegenFrame
extends JFrame {
    private final JDatabasePanel _databasePanel;
    private final Middlegen _middlegen;
    private Action _generateAction = new AbstractAction("Generate"){

        public void actionPerformed(ActionEvent evt) {
            try {
                JMiddlegenFrame.this._middlegen.writeSource();
            }
            catch (MiddlegenException e) {
                JMiddlegenFrame.this.error(e);
            }
        }
    };
    private static Category _log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.swing.JMiddlegenFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public JMiddlegenFrame(Middlegen middlegen, String title) {
        super(title);
        this._middlegen = middlegen;
        this.setKuststoffLF();
        JLabel header = new JLabel("", 0);
        JSettingsTabPane settingsTabs = new JSettingsTabPane(middlegen.getPlugins());
        JPanel headerTabs = new JPanel(new BorderLayout());
        headerTabs.add((Component)header, "North");
        headerTabs.add((Component)settingsTabs, "Center");
        this._databasePanel = new JDatabasePanel(settingsTabs, header);
        JScrollPane scroll = new JScrollPane(this._databasePanel);
        JSplitPane split = new JSplitPane(0, scroll, headerTabs);
        split.setDividerLocation(0.5);
        this.getContentPane().add((Component)split, "Center");
        JToolBar toolBar = new JToolBar();
        toolBar.add(this._generateAction);
        this.getContentPane().add((Component)toolBar, "North");
        ImageIcon icon = new ImageIcon(this.getClass().getResource("m.gif"));
        ((Frame)this).setIconImage(icon.getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Object object = MiddlegenTask.getLock();
                synchronized (object) {
                    JMiddlegenFrame.this._databasePanel.setPrefs();
                    MiddlegenTask.getLock().notify();
                }
            }
        });
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        this._databasePanel.reset(this._middlegen);
        this.pack();
    }

    private void setKuststoffLF() {
    }

    private void error(Throwable t) {
        t.printStackTrace();
        JOptionPane.showMessageDialog(this, t);
    }

    public static class NoExitSecurityManager
    extends SecurityManager {
        public void checkExit(int status) {
            throw new ExitException(status);
        }

        public void checkPermission(Permission p) {
        }
    }

    public static class ExitException
    extends RuntimeException {
        private int _status;

        public ExitException(int status) {
            this._status = status;
        }

        public int getStatus() {
            return this._status;
        }
    }
}

