/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin;

import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import org.logicalcobwebs.concurrent.WriterPreferenceReadWriteLock;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.admin.CompositeStatisticsListener;
import org.logicalcobwebs.proxool.admin.Statistics;

class StatsRoller {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$admin$StatsRoller == null ? (class$org$logicalcobwebs$proxool$admin$StatsRoller = StatsRoller.class$("org.logicalcobwebs.proxool.admin.StatsRoller")) : class$org$logicalcobwebs$proxool$admin$StatsRoller);
    private WriterPreferenceReadWriteLock readWriteLock = new WriterPreferenceReadWriteLock();
    private Statistics completeStatistics;
    private Statistics currentStatistics;
    private Calendar nextRollDate;
    private int period;
    private int units;
    private Timer timer = new Timer(true);
    private CompositeStatisticsListener compositeStatisticsListener;
    private String alias;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$admin$StatsRoller;

    public StatsRoller(String alias, CompositeStatisticsListener compositeStatisticsListener, String token) throws ProxoolException {
        this.alias = alias;
        this.compositeStatisticsListener = compositeStatisticsListener;
        this.nextRollDate = Calendar.getInstance();
        if (token.endsWith("s")) {
            this.units = 13;
            this.nextRollDate.clear(13);
            this.nextRollDate.clear(14);
        } else if (token.endsWith("m")) {
            this.units = 12;
            this.nextRollDate.clear(12);
            this.nextRollDate.clear(13);
            this.nextRollDate.clear(14);
        } else if (token.endsWith("h")) {
            this.nextRollDate.clear(11);
            this.nextRollDate.clear(12);
            this.nextRollDate.clear(13);
            this.nextRollDate.clear(14);
            this.units = 11;
        } else if (token.endsWith("d")) {
            this.units = 5;
            this.nextRollDate.clear(11);
            this.nextRollDate.clear(12);
            this.nextRollDate.clear(13);
            this.nextRollDate.clear(14);
        } else {
            throw new ProxoolException("Unrecognised suffix in statistics: " + token);
        }
        this.period = Integer.parseInt(token.substring(0, token.length() - 1));
        Calendar now = Calendar.getInstance();
        while (this.nextRollDate.before(now)) {
            this.nextRollDate.add(this.units, this.period);
        }
        LOG.debug("Collecting first statistics for '" + token + "' at " + this.nextRollDate.getTime());
        this.currentStatistics = new Statistics(now.getTime());
        TimerTask tt = new TimerTask(){

            public void run() {
                StatsRoller.this.roll();
            }
        };
        this.timer.schedule(tt, 1000L, 5000L);
    }

    protected void cancel() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void roll() {
        try {
            block4: {
                try {
                    this.readWriteLock.writeLock().acquire();
                    if (this.isCurrent()) break block4;
                    this.currentStatistics.setStopDate(this.nextRollDate.getTime());
                    this.completeStatistics = this.currentStatistics;
                    this.currentStatistics = new Statistics(this.nextRollDate.getTime());
                    this.nextRollDate.add(this.units, this.period);
                    this.compositeStatisticsListener.statistics(this.alias, this.completeStatistics);
                }
                catch (InterruptedException e) {
                    LOG.error("Unable to roll statistics log", e);
                    Object var3_2 = null;
                    this.readWriteLock.writeLock().release();
                }
            }
            Object var3_1 = null;
            this.readWriteLock.writeLock().release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.readWriteLock.writeLock().release();
            throw throwable;
        }
    }

    private boolean isCurrent() {
        return System.currentTimeMillis() < this.nextRollDate.getTime().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionReturned(long activeTime) {
        if (!this.isCurrent()) {
            this.roll();
        }
        try {
            try {
                this.readWriteLock.readLock().acquire();
                this.currentStatistics.connectionReturned(activeTime);
            }
            catch (InterruptedException e) {
                LOG.error("Unable to log connectionReturned", e);
                Object var5_3 = null;
                this.readWriteLock.readLock().release();
            }
            Object var5_2 = null;
            this.readWriteLock.readLock().release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.readWriteLock.readLock().release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionRefused() {
        if (!this.isCurrent()) {
            this.roll();
        }
        try {
            try {
                this.readWriteLock.readLock().acquire();
                this.currentStatistics.connectionRefused();
            }
            catch (InterruptedException e) {
                LOG.error("Unable to log connectionRefused", e);
                Object var3_2 = null;
                this.readWriteLock.readLock().release();
            }
            Object var3_1 = null;
            this.readWriteLock.readLock().release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.readWriteLock.readLock().release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics getCompleteStatistics() {
        try {
            this.readWriteLock.readLock().acquire();
            Statistics statistics = this.completeStatistics;
            Object var4_3 = null;
            this.readWriteLock.readLock().release();
            return statistics;
        }
        catch (InterruptedException e) {
            try {
                LOG.error("Couldn't read statistics", e);
                Statistics statistics = null;
                Object var4_4 = null;
                this.readWriteLock.readLock().release();
                return statistics;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.readWriteLock.readLock().release();
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

