/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import middlegen.MiddlegenException;
import middlegen.Prefs;

public class Prefs14
extends Prefs {
    private Preferences _prefs;
    private File _prefsFile;

    public void set(String pathName, String key, String value) {
        Preferences node = this._prefs.node(pathName);
        node.put(key, value);
    }

    public String get(String pathName, String key) {
        String result = null;
        Preferences node = this._prefs.node(pathName);
        result = node.get(key, null);
        return result;
    }

    public void save() {
        try {
            this._prefsFile.getParentFile().mkdirs();
            this._prefs.exportSubtree(new FileOutputStream(this._prefsFile));
            System.out.println("Updated preferences in " + this._prefsFile.getAbsolutePath());
        }
        catch (Exception e) {
            System.out.println("Couldn't save preferences to " + this._prefsFile.getAbsolutePath() + ":" + e.getMessage());
        }
    }

    public void init(File prefsDir, String prefsId) throws MiddlegenException {
        this._prefsFile = new File(prefsDir, prefsId + "-prefs.xml");
        try {
            this._prefs = Preferences.userRoot().node("middlegen/" + prefsId);
            if (this._prefsFile.exists()) {
                try {
                    FileInputStream in = new FileInputStream(this._prefsFile);
                    Preferences.importPreferences(in);
                }
                catch (IOException e) {
                    System.out.println("No preferences file found at " + this._prefsFile.getAbsolutePath());
                }
                catch (InvalidPreferencesFormatException e) {
                    System.out.println("Bad preferences format: " + this._prefsFile.getAbsolutePath());
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                    System.out.println();
                    System.out.println("WARNING: Couldn't read preferences!");
                    System.out.println("It seems you have an XML parser on your classpath that interferes with the XML parser in JDK 1.4. Please remove that XML parser from your classpath.");
                    System.out.println("Chances are you have ANT_HOME/lib/xercesImpl.jar. Try to delete that file.");
                }
            } else {
                try {
                    this._prefs.removeNode();
                    this._prefs = Preferences.userRoot().node("middlegen/" + prefsId);
                }
                catch (BackingStoreException e) {
                    System.out.println("Couldn't reset preferences: " + this._prefsFile.getAbsolutePath());
                }
                catch (IllegalStateException e) {}
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new MiddlegenException("Couldn't initialise preferences system:" + t.getMessage());
        }
    }
}

