/*
 * Decompiled with CFR 0.152.
 */
package middlegen.javax;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Category;

public class Sql2Java {
    private static Category _log;
    private static final IntStringMap _javaTypesForSqlType;
    private static final IntStringMap _preferredJavaTypeForSqlType;
    private static final Comparator _typeComparator;
    private static final HashMap _primitiveToClassMap;
    private static final String[] _allJavaTypes;
    private static final Set _numericClasses;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.javax.Sql2Java");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
        _javaTypesForSqlType = new IntStringMap();
        _preferredJavaTypeForSqlType = new IntStringMap();
        _typeComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                boolean isS2Class;
                String s1 = (String)o1;
                String s2 = (String)o2;
                boolean isS1Class = s1.indexOf(46) != -1;
                boolean bl = isS2Class = s2.indexOf(46) != -1;
                if (isS1Class && isS2Class || !isS1Class && !isS2Class) {
                    return s1.compareTo(s2);
                }
                return isS1Class ? 1 : -1;
            }

            public boolean equals(Object o1, Object o2) {
                return o1.equals(o2);
            }
        };
        _primitiveToClassMap = new HashMap();
        _allJavaTypes = new String[]{"boolean", "byte", "byte[]", "double", "float", "int", "long", "short", "java.io.InputStream", "java.io.Reader", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.lang.Object", "java.math.BigDecimal", "java.math.BigInteger", "java.sql.Array", "java.sql.Blob", "java.sql.Clob", "java.sql.Date", "java.sql.Ref", "java.sql.Time", "java.sql.Timestamp", "java.util.Date"};
        _numericClasses = new HashSet();
        _primitiveToClassMap.put("byte", "java.lang.Byte");
        _primitiveToClassMap.put("short", "java.lang.Short");
        _primitiveToClassMap.put("int", "java.lang.Integer");
        _primitiveToClassMap.put("long", "java.lang.Long");
        _primitiveToClassMap.put("float", "java.lang.Float");
        _primitiveToClassMap.put("boolean", "java.lang.Boolean");
        _primitiveToClassMap.put("double", "java.lang.Double");
        _numericClasses.add("java.lang.Byte");
        _numericClasses.add("java.lang.Short");
        _numericClasses.add("java.lang.Integer");
        _numericClasses.add("java.lang.Long");
        _numericClasses.add("java.lang.Float");
        _numericClasses.add("java.lang.Boolean");
        _numericClasses.add("java.lang.Double");
        _javaTypesForSqlType.put(-6, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.lang.Object", "java.math.BigDecimal", "java.math.BigInteger"});
        _javaTypesForSqlType.put(5, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.lang.Object", "java.math.BigDecimal", "java.math.BigInteger"});
        _javaTypesForSqlType.put(4, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.lang.Object", "java.math.BigDecimal", "java.math.BigInteger"});
        _javaTypesForSqlType.put(-5, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.lang.Object", "java.math.BigDecimal", "java.math.BigInteger"});
        _javaTypesForSqlType.put(7, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.lang.Object", "java.math.BigDecimal", "java.math.BigInteger"});
        _javaTypesForSqlType.put(6, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.lang.Object", "java.math.BigDecimal", "java.math.BigInteger"});
        _javaTypesForSqlType.put(8, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.lang.Object", "java.math.BigDecimal", "java.math.BigInteger"});
        _javaTypesForSqlType.put(3, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.lang.Object", "java.math.BigDecimal", "java.math.BigInteger"});
        _javaTypesForSqlType.put(2, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.lang.Object", "java.math.BigDecimal", "java.math.BigInteger"});
        _javaTypesForSqlType.put(-7, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.lang.Object", "java.math.BigDecimal", "java.math.BigInteger"});
        _javaTypesForSqlType.put(1, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "java.io.InputStream", "java.io.Reader", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Object", "java.lang.Short", "java.lang.String", "java.math.BigDecimal", "java.math.BigInteger", "java.sql.Date", "java.sql.Time", "java.sql.Timestamp", "java.util.Date"});
        _javaTypesForSqlType.put(12, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "java.io.InputStream", "java.io.Reader", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Object", "java.lang.Short", "java.lang.String", "java.math.BigDecimal", "java.math.BigInteger", "java.sql.Date", "java.sql.Time", "java.sql.Timestamp", "java.util.Date"});
        _javaTypesForSqlType.put(-1, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "java.io.InputStream", "java.io.Reader", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Object", "java.lang.Short", "java.lang.String", "java.math.BigDecimal", "java.math.BigInteger", "java.sql.Date", "java.sql.Time", "java.sql.Timestamp", "java.util.Date"});
        _javaTypesForSqlType.put(-2, new String[]{"byte[]", "java.lang.String", "java.lang.Object", "java.io.InputStream", "java.io.Reader"});
        _javaTypesForSqlType.put(-3, new String[]{"byte[]", "java.lang.String", "java.lang.Object", "java.io.InputStream", "java.io.Reader"});
        _javaTypesForSqlType.put(-4, new String[]{"byte[]", "java.lang.String", "java.lang.Object", "java.io.InputStream", "java.io.Reader"});
        _javaTypesForSqlType.put(91, new String[]{"java.lang.String", "java.lang.Object", "java.sql.Date", "java.sql.Timestamp", "java.util.Date"});
        _javaTypesForSqlType.put(92, new String[]{"java.lang.String", "java.lang.Object", "java.sql.Time", "java.sql.Timestamp", "java.util.Date"});
        _javaTypesForSqlType.put(93, new String[]{"java.lang.String", "java.lang.Object", "java.sql.Date", "java.sql.Time", "java.sql.Timestamp", "java.util.Date"});
        _javaTypesForSqlType.put(2005, new String[]{"java.lang.Object", "java.sql.Clob"});
        _javaTypesForSqlType.put(2004, new String[]{"java.lang.Object", "java.sql.Blob"});
        _javaTypesForSqlType.put(2003, new String[]{"java.lang.Object", "java.sql.Array"});
        _javaTypesForSqlType.put(2006, new String[]{"java.lang.Object", "java.sql.Ref"});
        _javaTypesForSqlType.put(2002, new String[]{"java.lang.Object"});
        _javaTypesForSqlType.put(2000, new String[]{"java.lang.Object"});
        _preferredJavaTypeForSqlType.put(-6, "byte");
        _preferredJavaTypeForSqlType.put(5, "short");
        _preferredJavaTypeForSqlType.put(4, "int");
        _preferredJavaTypeForSqlType.put(-5, "long");
        _preferredJavaTypeForSqlType.put(7, "float");
        _preferredJavaTypeForSqlType.put(6, "double");
        _preferredJavaTypeForSqlType.put(8, "double");
        _preferredJavaTypeForSqlType.put(3, "java.math.BigDecimal");
        _preferredJavaTypeForSqlType.put(2, "java.math.BigDecimal");
        _preferredJavaTypeForSqlType.put(-7, "boolean");
        _preferredJavaTypeForSqlType.put(1, "java.lang.String");
        _preferredJavaTypeForSqlType.put(12, "java.lang.String");
        _preferredJavaTypeForSqlType.put(-1, "java.lang.String");
        _preferredJavaTypeForSqlType.put(-2, "byte[]");
        _preferredJavaTypeForSqlType.put(-3, "byte[]");
        _preferredJavaTypeForSqlType.put(-4, "java.io.InputStream");
        _preferredJavaTypeForSqlType.put(91, "java.sql.Date");
        _preferredJavaTypeForSqlType.put(92, "java.sql.Time");
        _preferredJavaTypeForSqlType.put(93, "java.sql.Timestamp");
        _preferredJavaTypeForSqlType.put(2005, "java.sql.Clob");
        _preferredJavaTypeForSqlType.put(2004, "java.sql.Blob");
        _preferredJavaTypeForSqlType.put(2003, "java.sql.Array");
        _preferredJavaTypeForSqlType.put(2006, "java.sql.Ref");
        _preferredJavaTypeForSqlType.put(2002, "java.lang.Object");
        _preferredJavaTypeForSqlType.put(2000, "java.lang.Object");
    }

    public static Comparator getTypeComparator() {
        return _typeComparator;
    }

    public static String getPreferredJavaType(int sqlType, int size, int decimalDigits) {
        if ((sqlType == 3 || sqlType == 2) && decimalDigits == 0) {
            if (size == 1) {
                return "boolean";
            }
            if (size < 3) {
                return "byte";
            }
            if (size < 5) {
                return "short";
            }
            if (size < 10) {
                return "int";
            }
            if (size < 19) {
                return "long";
            }
            return "java.math.BigDecimal";
        }
        String result = _preferredJavaTypeForSqlType.getString(sqlType);
        if (result == null) {
            result = "java.lang.Object";
        }
        return result;
    }

    public static String getPreferredJavaTypeNoPrimitives(int sqlType, int size, int decimalDigits) {
        String pjt = Sql2Java.getPreferredJavaType(sqlType, size, decimalDigits);
        String pjtc = Sql2Java.getClassForPrimitive(pjt);
        if (pjtc != null) {
            return pjtc;
        }
        return pjt;
    }

    public static String[] getJavaTypes(int sqlType) {
        String[] result = _javaTypesForSqlType.getStrings(sqlType);
        if (result == null) {
            result = _allJavaTypes;
        }
        return result;
    }

    public static String getClassForPrimitive(String primitive) {
        return (String)_primitiveToClassMap.get(primitive);
    }

    public static boolean isPrimitive(String type) {
        return Sql2Java.getClassForPrimitive(type) != null;
    }

    public static boolean isNumericClass(String type) {
        return _numericClasses.contains(type);
    }

    public static void overridePreferredJavaTypeForSqlType(int sqlType, String javaType) {
        _preferredJavaTypeForSqlType.put(sqlType, javaType);
    }

    public static void overrideAllowedJavaTypesForSqlType(int sqlType, String[] javaTypes) {
        _javaTypesForSqlType.put(sqlType, javaTypes);
    }

    private static class IntStringMap
    extends HashMap {
        IntStringMap() {
        }

        public String getString(int i) {
            return (String)this.get(new Integer(i));
        }

        public String[] getStrings(int i) {
            return (String[])this.get(new Integer(i));
        }

        public void put(int i, String s) {
            this.put(new Integer(i), s);
        }

        public void put(int i, String[] sa) {
            this.put(new Integer(i), sa);
        }
    }
}

