/*
 * Decompiled with CFR 0.152.
 */
package middlegen.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import middlegen.RelationshipRole;
import middlegen.swing.JTablePanel;
import org.apache.log4j.Category;

public class RelationLine {
    private final Stroke _regularStroke = new BasicStroke(2.0f);
    private final Stroke _dashedStroke = new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    private boolean _isSelected;
    private final RelationshipRole _leftRole;
    private final RelationshipRole _rightRole;
    private final JTablePanel _leftTable;
    private final JTablePanel _rightTable;
    private final Line2D.Float[] _leftLines;
    private final Line2D.Float[] _rightLines;
    private final Line2D.Float _mainLine;
    private final Point2D.Float _leftArrowPoint;
    private final Point2D.Float _rightArrowPoint;
    private final Line2D.Float _leftArrowLine1;
    private final Line2D.Float _leftArrowLine2;
    private final Line2D.Float _rightArrowLine1;
    private final Line2D.Float _rightArrowLine2;
    private final Point2D.Float _leftArrowPoint1;
    private final Point2D.Float _leftArrowPoint2;
    private final Point2D.Float _rightArrowPoint1;
    private final Point2D.Float _rightArrowPoint2;
    private final Point2D.Float _temp;
    private final AffineTransform _arrowTransform;
    private final Point2D.Float _leftCardinalityPoint;
    private final Point2D.Float _rightCardinalityPoint;
    private final Point2D.Float _leftFkPoint;
    private final Point2D.Float _rightFkPoint;
    private double _mainLength;
    private boolean _leftIsWest;
    private int _leftColumnY = 0;
    private int _rightColumnY = 0;
    private int[] _leftEdgeY;
    private int[] _rightEdgeY;
    private static Image _star;
    private static Image _one;
    private static Image _star_white;
    private static Image _one_white;
    private static Image _fk;
    private static Category _log;
    private static RenderingHints _renderHints;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.swing.RelationLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _star = new ImageIcon(clazz.getResource("star.gif")).getImage();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("middlegen.swing.RelationLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _one = new ImageIcon(clazz2.getResource("one.gif")).getImage();
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("middlegen.swing.RelationLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _star_white = new ImageIcon(clazz3.getResource("star_white.gif")).getImage();
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("middlegen.swing.RelationLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _one_white = new ImageIcon(clazz4.getResource("one_white.gif")).getImage();
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("middlegen.swing.RelationLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _fk = new ImageIcon(clazz5.getResource("fk.gif")).getImage();
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("middlegen.swing.RelationLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz6.getName());
        _renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        _renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public RelationLine(RelationshipRole leftRole, RelationshipRole rightRole, JTablePanel leftTable, JTablePanel rightTable) {
        _log.debug((Object)("new RelationLine for " + leftTable.getTable().getSqlName() + "-" + rightTable.getTable().getSqlName()));
        this._leftRole = leftRole;
        this._rightRole = rightRole;
        this._leftTable = leftTable;
        this._rightTable = rightTable;
        _log.debug((Object)("A:" + this._leftRole.getColumnMaps().length));
        this._leftEdgeY = new int[this._leftRole.getColumnMaps().length];
        int i = 0;
        while (i < this._leftEdgeY.length) {
            this._leftEdgeY[i] = this._leftTable.getColumnY(this._leftRole.getColumnMaps()[i].getPrimaryKey());
            this._leftColumnY += this._leftEdgeY[i];
            ++i;
        }
        this._leftColumnY /= this._leftEdgeY.length;
        if (!this._leftRole.getRelation().isMany2Many()) {
            _log.debug((Object)("M:" + this._leftRole.getColumnMaps().length));
            this._rightEdgeY = new int[this._leftRole.getColumnMaps().length];
            i = 0;
            while (i < this._rightEdgeY.length) {
                this._rightEdgeY[i] = this._rightTable.getColumnY(this._leftRole.getColumnMaps()[i].getForeignKey());
                this._rightColumnY += this._rightEdgeY[i];
                ++i;
            }
            this._rightColumnY /= this._rightEdgeY.length;
        } else {
            _log.debug((Object)("B:" + this._rightRole.getColumnMaps().length));
            this._rightEdgeY = new int[this._rightRole.getColumnMaps().length];
            i = 0;
            while (i < this._rightEdgeY.length) {
                this._rightEdgeY[i] = this._rightTable.getColumnY(this._rightRole.getColumnMaps()[i].getPrimaryKey());
                this._rightColumnY += this._rightEdgeY[i];
                ++i;
            }
            this._rightColumnY /= this._rightRole.getColumnMaps().length;
        }
        this._leftLines = RelationLine.createLines(this._leftEdgeY.length);
        this._rightLines = RelationLine.createLines(this._rightEdgeY.length);
        this._mainLine = new Line2D.Float();
        this._leftCardinalityPoint = new Point2D.Float();
        this._rightCardinalityPoint = new Point2D.Float();
        this._leftFkPoint = new Point2D.Float();
        this._rightFkPoint = new Point2D.Float();
        this._leftArrowPoint = new Point2D.Float();
        this._rightArrowPoint = new Point2D.Float();
        this._leftArrowLine1 = new Line2D.Float();
        this._leftArrowLine2 = new Line2D.Float();
        this._rightArrowLine1 = new Line2D.Float();
        this._rightArrowLine2 = new Line2D.Float();
        this._leftArrowPoint1 = new Point2D.Float();
        this._leftArrowPoint2 = new Point2D.Float();
        this._rightArrowPoint1 = new Point2D.Float();
        this._rightArrowPoint2 = new Point2D.Float();
        this._temp = new Point2D.Float();
        this._arrowTransform = new AffineTransform();
    }

    public void setSelected(boolean isSelected) {
        this._isSelected = isSelected;
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void update() {
        int i;
        int westX;
        boolean aligned;
        int[] eastEdgeY;
        int[] westEdgeY;
        Line2D.Float[] eastLines;
        Line2D.Float[] westLines;
        int eastY;
        int westY;
        JTablePanel eastTable;
        JTablePanel westTable;
        int leftY = this._leftTable.getY() + this._leftColumnY;
        int rightY = this._rightTable.getY() + this._rightColumnY;
        boolean bl = this._leftIsWest = this._leftTable.getX() < this._rightTable.getX();
        if (this._leftIsWest) {
            westTable = this._leftTable;
            eastTable = this._rightTable;
            westY = leftY;
            eastY = rightY;
            westLines = this._leftLines;
            eastLines = this._rightLines;
            westEdgeY = this._leftEdgeY;
            eastEdgeY = this._rightEdgeY;
        } else {
            westTable = this._rightTable;
            eastTable = this._leftTable;
            westY = rightY;
            eastY = leftY;
            westLines = this._rightLines;
            eastLines = this._leftLines;
            westEdgeY = this._rightEdgeY;
            eastEdgeY = this._leftEdgeY;
        }
        boolean bl2 = aligned = eastTable.getX() - westTable.getX() < eastTable.getWidth() / 2;
        if (aligned) {
            westX = westTable.getX() - 10;
            i = 0;
            while (i < westEdgeY.length) {
                westLines[i].setLine(westX, westY, westTable.getX(), westEdgeY[i] + westTable.getY());
                ++i;
            }
        } else {
            westX = westTable.getX() + westTable.getWidth() + 10;
            i = 0;
            while (i < westEdgeY.length) {
                westLines[i].setLine(westX, westY, westTable.getX() + westTable.getWidth(), westEdgeY[i] + westTable.getY());
                ++i;
            }
        }
        int eastX = eastTable.getX() - 10;
        int i2 = 0;
        while (i2 < eastEdgeY.length) {
            eastLines[i2].setLine(eastX, eastY, eastTable.getX(), eastEdgeY[i2] + eastTable.getY());
            ++i2;
        }
        this._mainLine.setLine(westX, westY, eastX, eastY);
        this.setCardinalityPoints();
    }

    public void paint(Graphics2D g) {
        g.setRenderingHints(_renderHints);
        if (this._leftRole.getRelation().isMany2Many()) {
            g.setStroke(this._dashedStroke);
        } else {
            g.setStroke(this._regularStroke);
        }
        this.drawLineUnlessItsLengthIsZero(g, this._mainLine);
        g.setStroke(this._regularStroke);
        int i = 0;
        while (i < this._leftLines.length) {
            this.drawLineUnlessItsLengthIsZero(g, this._leftLines[i]);
            ++i;
        }
        i = 0;
        while (i < this._rightLines.length) {
            this.drawLineUnlessItsLengthIsZero(g, this._rightLines[i]);
            ++i;
        }
        this.drawImage(g, this.getDisplayImage(this._rightRole, g.getColor()), this._leftCardinalityPoint.x - 8.0f, this._leftCardinalityPoint.y - 8.0f);
        this.drawImage(g, this.getDisplayImage(this._leftRole, g.getColor()), this._rightCardinalityPoint.x - 8.0f, this._rightCardinalityPoint.y - 8.0f);
        if (this._rightRole.isEnabled()) {
            this.drawLineUnlessItsLengthIsZero(g, this._leftArrowLine1);
            this.drawLineUnlessItsLengthIsZero(g, this._leftArrowLine2);
        }
        if (this._leftRole.isEnabled()) {
            this.drawLineUnlessItsLengthIsZero(g, this._rightArrowLine1);
            this.drawLineUnlessItsLengthIsZero(g, this._rightArrowLine2);
        }
        if (!this._leftRole.isOriginPrimaryKey()) {
            this.drawImage(g, _fk, this._leftFkPoint.x - 6.0f, this._leftFkPoint.y - 6.0f);
        }
        if (!this._rightRole.isOriginPrimaryKey()) {
            this.drawImage(g, _fk, this._rightFkPoint.x - 6.0f, this._rightFkPoint.y - 6.0f);
        }
    }

    public boolean selectMaybe(MouseEvent evt) {
        boolean multiplicity = evt.isControlDown();
        boolean cardinality = evt.isShiftDown();
        Point point = evt.getPoint();
        this.setSelected(this._mainLine.intersects(point.getX() - 5.0, point.getY() - 5.0, 10.0, 10.0));
        if (this.isSelected()) {
            RelationshipRole role;
            double distFromP1 = Point2D.distance(this._mainLine.getX1(), this._mainLine.getY1(), point.getX(), point.getY());
            boolean nearP1 = distFromP1 < this._mainLength / 2.0;
            boolean leftChosen = this._leftIsWest && nearP1 || !this._leftIsWest && !nearP1;
            RelationshipRole relationshipRole = role = leftChosen ? this._rightRole : this._leftRole;
            if (multiplicity) {
                if (role.getRelation().isMany2Many()) {
                    JOptionPane.showMessageDialog(null, "Can't change the cardinality of a many-to-many relationship", "Cardinality", 1);
                    return false;
                }
                if (role.isFkPk()) {
                    JOptionPane.showMessageDialog(null, "Can't change the cardinality of a one-to-one relationship where the foreign key is also a primary key", "Cardinality", 1);
                    return false;
                }
                if (role.isTargetPrimaryKey()) {
                    JOptionPane.showMessageDialog(null, "Can't change the cardinality of a the one-side of a relationship that corresponds to a primary key", "Cardinality", 1);
                    return false;
                }
                role.setTargetMany(!role.isTargetMany());
            }
            if (cardinality) {
                role.setEnabled(!role.isEnabled());
            }
            return true;
        }
        return false;
    }

    private void setCardinalityPoints() {
        this._mainLength = Point2D.distance(this._mainLine.getX1(), this._mainLine.getY1(), this._mainLine.getX2(), this._mainLine.getY2());
        double vx = (this._mainLine.getX2() - this._mainLine.getX1()) / this._mainLength;
        double vy = (this._mainLine.getY2() - this._mainLine.getY1()) / this._mainLength;
        double cardx = 20.0 * vx;
        double cardy = 20.0 * vy;
        double arrowx = 30.0 * vx;
        double arrowy = 30.0 * vy;
        if (this._leftIsWest) {
            this._leftArrowPoint.setLocation(this._mainLine.getX1() + cardx, this._mainLine.getY1() + cardy);
            this._rightArrowPoint.setLocation(this._mainLine.getX2() - cardx, this._mainLine.getY2() - cardy);
            this._temp.setLocation(this._mainLine.getX1() + arrowx, this._mainLine.getY1() + arrowy);
            this._arrowTransform.setToRotation(0.5235987755982988, this._leftArrowPoint.getX(), this._leftArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._leftArrowPoint1);
            this._leftArrowLine1.setLine(this._leftArrowPoint.getX(), this._leftArrowPoint.getY(), this._leftArrowPoint1.getX(), this._leftArrowPoint1.getY());
            this._arrowTransform.setToRotation(-0.5235987755982988, this._leftArrowPoint.getX(), this._leftArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._leftArrowPoint2);
            this._leftArrowLine2.setLine(this._leftArrowPoint.getX(), this._leftArrowPoint.getY(), this._leftArrowPoint2.getX(), this._leftArrowPoint2.getY());
            this._arrowTransform.setToRotation(1.5707963267948966, this._leftArrowPoint.getX(), this._leftArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._leftCardinalityPoint);
            this._arrowTransform.setToRotation(-1.5707963267948966, this._leftArrowPoint.getX(), this._leftArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._leftFkPoint);
            this._temp.setLocation(this._mainLine.getX2() - arrowx, this._mainLine.getY2() - arrowy);
            this._arrowTransform.setToRotation(0.5235987755982988, this._rightArrowPoint.getX(), this._rightArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._rightArrowPoint1);
            this._rightArrowLine1.setLine(this._rightArrowPoint.getX(), this._rightArrowPoint.getY(), this._rightArrowPoint1.getX(), this._rightArrowPoint1.getY());
            this._arrowTransform.setToRotation(-0.5235987755982988, this._rightArrowPoint.getX(), this._rightArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._rightArrowPoint2);
            this._rightArrowLine2.setLine(this._rightArrowPoint.getX(), this._rightArrowPoint.getY(), this._rightArrowPoint2.getX(), this._rightArrowPoint2.getY());
            this._arrowTransform.setToRotation(-1.5707963267948966, this._rightArrowPoint.getX(), this._rightArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._rightCardinalityPoint);
            this._arrowTransform.setToRotation(1.5707963267948966, this._rightArrowPoint.getX(), this._rightArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._rightFkPoint);
        } else {
            this._leftArrowPoint.setLocation(this._mainLine.getX2() - cardx, this._mainLine.getY2() - cardy);
            this._rightArrowPoint.setLocation(this._mainLine.getX1() + cardx, this._mainLine.getY1() + cardy);
            this._temp.setLocation(this._mainLine.getX2() - arrowx, this._mainLine.getY2() - arrowy);
            this._arrowTransform.setToRotation(0.5235987755982988, this._leftArrowPoint.getX(), this._leftArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._leftArrowPoint1);
            this._leftArrowLine1.setLine(this._leftArrowPoint.getX(), this._leftArrowPoint.getY(), this._leftArrowPoint1.getX(), this._leftArrowPoint1.getY());
            this._arrowTransform.setToRotation(-0.5235987755982988, this._leftArrowPoint.getX(), this._leftArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._leftArrowPoint2);
            this._leftArrowLine2.setLine(this._leftArrowPoint.getX(), this._leftArrowPoint.getY(), this._leftArrowPoint2.getX(), this._leftArrowPoint2.getY());
            this._arrowTransform.setToRotation(1.5707963267948966, this._leftArrowPoint.getX(), this._leftArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._leftCardinalityPoint);
            this._arrowTransform.setToRotation(-1.5707963267948966, this._leftArrowPoint.getX(), this._leftArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._leftFkPoint);
            this._temp.setLocation(this._mainLine.getX1() + arrowx, this._mainLine.getY1() + arrowy);
            this._arrowTransform.setToRotation(0.5235987755982988, this._rightArrowPoint.getX(), this._rightArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._rightArrowPoint1);
            this._rightArrowLine1.setLine(this._rightArrowPoint.getX(), this._rightArrowPoint.getY(), this._rightArrowPoint1.getX(), this._rightArrowPoint1.getY());
            this._arrowTransform.setToRotation(-0.5235987755982988, this._rightArrowPoint.getX(), this._rightArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._rightArrowPoint2);
            this._rightArrowLine2.setLine(this._rightArrowPoint.getX(), this._rightArrowPoint.getY(), this._rightArrowPoint2.getX(), this._rightArrowPoint2.getY());
            this._arrowTransform.setToRotation(-1.5707963267948966, this._rightArrowPoint.getX(), this._rightArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._rightCardinalityPoint);
            this._arrowTransform.setToRotation(1.5707963267948966, this._rightArrowPoint.getX(), this._rightArrowPoint.getY());
            this._arrowTransform.transform(this._temp, this._rightFkPoint);
        }
    }

    private Image getDisplayImage(RelationshipRole role, Color c) {
        if (c == Color.white) {
            return role.isTargetMany() ? _star_white : _one_white;
        }
        return role.isTargetMany() ? _star : _one;
    }

    private final void drawImage(Graphics2D g, Image i, float x, float y) {
        if (!Float.isNaN(x)) {
            g.drawImage(i, (int)x, (int)y, null);
        }
    }

    private final void drawLineUnlessItsLengthIsZero(Graphics2D g, Line2D line) {
        if (!Double.isNaN(line.getP1().getX())) {
            g.draw(line);
        }
    }

    private static Line2D.Float[] createLines(int n) {
        Line2D.Float[] result = new Line2D.Float[n];
        int i = 0;
        while (i < n) {
            result[i] = new Line2D.Float();
            ++i;
        }
        return result;
    }
}

