/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import junit.framework.TestCase;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.JCSCache;
import net.sf.hibernate.cache.ReadWriteCache;
import net.sf.hibernate.cache.Timestamper;

public class CacheTest
extends TestCase {
    static /* synthetic */ Class class$java$lang$String;

    public CacheTest(String arg0) {
        super(arg0);
    }

    public void testCaches() throws Exception {
        this.doTestCache(new JCSCache());
    }

    public void doTestCache(Cache cache) throws Exception {
        long longBefore = Timestamper.next();
        Thread.sleep(15L);
        long before = Timestamper.next();
        Thread.sleep(15L);
        cache.setRegion((class$java$lang$String == null ? (class$java$lang$String = CacheTest.class$("java.lang.String")) : class$java$lang$String).getName());
        ReadWriteCache ccs = new ReadWriteCache(cache);
        CacheTest.assertTrue((boolean)ccs.put("foo", "foo", before));
        Thread.sleep(15L);
        long after = Timestamper.next();
        CacheTest.assertTrue((ccs.get("foo", longBefore) == null ? 1 : 0) != 0);
        CacheTest.assertTrue((boolean)ccs.get("foo", after).equals("foo"));
        CacheTest.assertTrue((!ccs.put("foo", "foo", before) ? 1 : 0) != 0);
        ccs.lock("foo");
        CacheTest.assertTrue((ccs.get("foo", after) == null ? 1 : 0) != 0);
        CacheTest.assertTrue((ccs.get("foo", longBefore) == null ? 1 : 0) != 0);
        CacheTest.assertTrue((!ccs.put("foo", "foo", before) ? 1 : 0) != 0);
        Thread.sleep(15L);
        long whileLocked = Timestamper.next();
        CacheTest.assertTrue((!ccs.put("foo", "foo", whileLocked) ? 1 : 0) != 0);
        Thread.sleep(15L);
        ccs.release("foo");
        CacheTest.assertTrue((ccs.get("foo", after) == null ? 1 : 0) != 0);
        CacheTest.assertTrue((ccs.get("foo", longBefore) == null ? 1 : 0) != 0);
        CacheTest.assertTrue((!ccs.put("foo", "bar", whileLocked) ? 1 : 0) != 0);
        CacheTest.assertTrue((!ccs.put("foo", "bar", after) ? 1 : 0) != 0);
        Thread.sleep(15L);
        long longAfter = Timestamper.next();
        CacheTest.assertTrue((boolean)ccs.put("foo", "baz", longAfter));
        CacheTest.assertTrue((ccs.get("foo", after) == null ? 1 : 0) != 0);
        CacheTest.assertTrue((ccs.get("foo", whileLocked) == null ? 1 : 0) != 0);
        Thread.sleep(15L);
        long longLongAfter = Timestamper.next();
        CacheTest.assertTrue((boolean)ccs.get("foo", longLongAfter).equals("baz"));
        ccs.lock("foo");
        ccs.lock("foo");
        CacheTest.assertTrue((ccs.get("foo", longLongAfter) == null ? 1 : 0) != 0);
        Thread.sleep(15L);
        whileLocked = Timestamper.next();
        CacheTest.assertTrue((!ccs.put("foo", "foo", whileLocked) ? 1 : 0) != 0);
        Thread.sleep(15L);
        ccs.release("foo");
        Thread.sleep(15L);
        long betweenReleases = Timestamper.next();
        CacheTest.assertTrue((!ccs.put("foo", "bar", betweenReleases) ? 1 : 0) != 0);
        CacheTest.assertTrue((ccs.get("foo", betweenReleases) == null ? 1 : 0) != 0);
        Thread.sleep(15L);
        ccs.release("foo");
        CacheTest.assertTrue((!ccs.put("foo", "bar", whileLocked) ? 1 : 0) != 0);
        Thread.sleep(15L);
        longAfter = Timestamper.next();
        CacheTest.assertTrue((boolean)ccs.put("foo", "baz", longAfter));
        CacheTest.assertTrue((ccs.get("foo", whileLocked) == null ? 1 : 0) != 0);
        Thread.sleep(15L);
        longLongAfter = Timestamper.next();
        CacheTest.assertTrue((boolean)ccs.get("foo", longLongAfter).equals("baz"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

