/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.collection.Set;
import net.sf.hibernate.engine.SessionImplementor;

public class SortedSet
extends Set
implements java.util.SortedSet {
    private Comparator comparator;

    public Serializable snapshot(CollectionPersister persister) throws HibernateException {
        TreeMap<Object, Object> clonedSet = new TreeMap<Object, Object>(this.comparator);
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            Object copy = persister.getElementType().deepCopy(iter.next());
            clonedSet.put(copy, copy);
        }
        return clonedSet;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.set = new TreeSet(this.comparator);
    }

    public SortedSet(SessionImplementor session) {
        super(session);
    }

    public SortedSet(SessionImplementor session, java.util.SortedSet set) {
        super(session, set);
        this.comparator = set.comparator();
    }

    public SortedSet() {
    }

    public Comparator comparator() {
        return ((java.util.SortedSet)this.set).comparator();
    }

    public java.util.SortedSet subSet(Object fromElement, Object toElement) {
        this.read();
        java.util.SortedSet<Object> s = ((java.util.SortedSet)this.set).subSet(fromElement, toElement);
        return new SubSetProxy(s);
    }

    public java.util.SortedSet headSet(Object toElement) {
        this.read();
        java.util.SortedSet<Object> s = ((java.util.SortedSet)this.set).headSet(toElement);
        return new SubSetProxy(s);
    }

    public java.util.SortedSet tailSet(Object fromElement) {
        this.read();
        java.util.SortedSet<Object> s = ((java.util.SortedSet)this.set).tailSet(fromElement);
        return new SubSetProxy(s);
    }

    public Object first() {
        this.read();
        return ((java.util.SortedSet)this.set).first();
    }

    public Object last() {
        this.read();
        return ((java.util.SortedSet)this.set).last();
    }

    public SortedSet(SessionImplementor session, CollectionPersister persister, Comparator comparator, Serializable disassembled, Object owner) throws HibernateException {
        this(session);
        this.comparator = comparator;
        this.beforeInitialize(persister);
        Serializable[] array = (Serializable[])disassembled;
        for (int i = 0; i < array.length; ++i) {
            this.set.add(persister.getElementType().assemble(array[i], session, owner));
        }
        this.initialized = true;
    }

    class SubSetProxy
    extends PersistentCollection.SetProxy
    implements java.util.SortedSet {
        SubSetProxy(java.util.SortedSet s) {
            super(s);
        }

        public Comparator comparator() {
            return ((java.util.SortedSet)this.set).comparator();
        }

        public Object first() {
            return ((java.util.SortedSet)this.set).first();
        }

        public java.util.SortedSet headSet(Object arg0) {
            return new SubSetProxy(((java.util.SortedSet)this.set).headSet(arg0));
        }

        public Object last() {
            return ((java.util.SortedSet)this.set).last();
        }

        public java.util.SortedSet subSet(Object arg0, Object arg1) {
            return new SubSetProxy(((java.util.SortedSet)this.set).subSet(arg0, arg1));
        }

        public java.util.SortedSet tailSet(Object arg0) {
            return new SubSetProxy(((java.util.SortedSet)this.set).tailSet(arg0));
        }
    }
}

