/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.PostgreSQLDialect;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.Expression;

public class IlikeExpression
extends Expression {
    private final String propertyName;
    private final Object value;

    IlikeExpression(String propertyName, Object value) {
        this.propertyName = propertyName;
        this.value = value;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias) throws HibernateException {
        Dialect dialect = sessionFactory.getDialect();
        String[] columns = IlikeExpression.getColumns(sessionFactory, persistentClass, this.propertyName, alias);
        if (columns.length != 1) {
            throw new HibernateException("ilike may only be used with single-column properties");
        }
        if (dialect instanceof PostgreSQLDialect) {
            return columns[0] + " ilike ?";
        }
        return dialect.getLowercaseFunction() + '(' + columns[0] + ") like ?";
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass) throws HibernateException {
        return new TypedValue[]{IlikeExpression.getTypedValue(sessionFactory, persistentClass, this.propertyName, this.value.toString().toLowerCase())};
    }

    public String toString() {
        return this.propertyName + " ilike " + this.value;
    }
}

