/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.ScheduledEntityAction;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.persister.ClassPersister;

final class ScheduledDeletion
extends ScheduledEntityAction
implements SessionImpl.Executable {
    private final Object version;

    public ScheduledDeletion(Serializable id, Object version, Object instance, ClassPersister persister, SessionImplementor session) {
        super(session, id, instance, persister);
        this.version = version;
    }

    public void execute() throws HibernateException, SQLException {
        if (this.getPersister().hasCache()) {
            this.getPersister().getCache().lock(this.getId());
        }
        this.getPersister().delete(this.getId(), this.version, this.getInstance(), this.getSession());
        this.getSession().postDelete(this.getInstance());
    }

    public void afterTransactionCompletion() throws CacheException {
        if (this.getPersister().hasCache()) {
            this.getPersister().getCache().release(this.getId());
        }
    }
}

