/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.jca;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.jca.JCASessionImpl;
import net.sf.hibernate.jca.ManagedConnectionFactoryImpl;
import net.sf.hibernate.jca.MetaDataImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedConnectionImpl
implements ManagedConnection,
XAResource {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$jca$ManagedConnectionImpl == null ? (class$net$sf$hibernate$jca$ManagedConnectionImpl = ManagedConnectionImpl.class$("net.sf.hibernate.jca.ManagedConnectionImpl")) : class$net$sf$hibernate$jca$ManagedConnectionImpl));
    private ManagedConnectionFactoryImpl mcf;
    private PrintWriter logWriter;
    private final Collection listeners = new ArrayList();
    private final LinkedList handles = new LinkedList();
    private Connection connection;
    private SessionImplementor session;
    static /* synthetic */ Class class$net$sf$hibernate$jca$ManagedConnectionImpl;

    ManagedConnectionImpl(ManagedConnectionFactoryImpl mcf) {
        log.trace((Object)"Constructor called");
        this.mcf = mcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        log.trace((Object)("getConnection called with subject[" + subject + " ] connection request info[" + connectionRequestInfo + "]"));
        this.initializeSession();
        JCASessionImpl active = new JCASessionImpl(this);
        LinkedList linkedList = this.handles;
        synchronized (linkedList) {
            this.handles.addFirst(active);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added session handle - " + active + " to handles now at size " + this.handles.size()));
        }
        return active;
    }

    private void initializeSession() throws ResourceException {
        if (this.session == null) {
            this.initializeConnection();
            this.session = (SessionImplementor)this.mcf.getSessionFactory().openSession(this.connection);
        }
    }

    private void initializeConnection() throws ResourceException {
        if (this.connection == null) {
            try {
                this.connection = this.mcf.getDatasource().getConnection();
            }
            catch (SQLException e) {
                String message = "Cannot allocate database connection!";
                throw this.newResourceException("Cannot allocate database connection!", e);
            }
        }
    }

    private ResourceException newResourceException(String message, Exception e) {
        ResourceException re = new ResourceException(message);
        re.setLinkedException(e);
        return re;
    }

    public void destroy() throws ResourceException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("destroy called on " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ResourceException {
        String message;
        if (log.isTraceEnabled()) {
            log.trace((Object)("cleanup called on " + this));
        }
        LinkedList linkedList = this.handles;
        synchronized (linkedList) {
            Iterator i = this.handles.iterator();
            while (i.hasNext()) {
                JCASessionImpl lc = (JCASessionImpl)i.next();
                lc.setManagedConnection(null);
            }
            this.handles.clear();
        }
        ResourceException re = null;
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (HibernateException e) {
            message = "Exception closing Hibernate session " + this.session;
            re = this.newResourceException(message, (Exception)((Object)e));
        }
        finally {
            this.session = null;
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            message = "Exception closing database connection " + this.connection;
            re = this.newResourceException(message, e);
        }
        finally {
            this.connection = null;
        }
        if (re != null) {
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConnection(Object object) throws ResourceException {
        if (!(object instanceof JCASessionImpl)) {
            throw new ResourceException("Wrong kind of connection handle to associate " + object);
        }
        JCASessionImpl handle = (JCASessionImpl)object;
        if (handle.getManagedConnextion() != this) {
            handle.getManagedConnextion().dissociateConnection(handle);
            handle.setManagedConnection(this);
            LinkedList linkedList = this.handles;
            synchronized (linkedList) {
                this.handles.addFirst(handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dissociateConnection(JCASessionImpl handle) {
        LinkedList linkedList = this.handles;
        synchronized (linkedList) {
            this.handles.remove(handle);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        return this;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException("LocalTransaction is not supported!");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new MetaDataImpl(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public void commit(Xid arg0, boolean arg1) throws XAException {
    }

    public void end(Xid arg0, int arg1) throws XAException {
    }

    public void forget(Xid arg0) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource arg0) throws XAException {
        return false;
    }

    public int prepare(Xid arg0) throws XAException {
        return 3;
    }

    public Xid[] recover(int arg0) throws XAException {
        return new Xid[0];
    }

    public void rollback(Xid arg0) throws XAException {
    }

    public boolean setTransactionTimeout(int arg0) throws XAException {
        return false;
    }

    public void start(Xid arg0, int arg1) throws XAException {
    }

    ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeHandle(Session handle) {
        LinkedList linkedList = this.handles;
        synchronized (linkedList) {
            this.handles.remove(handle);
        }
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 1);
        ce.setConnectionHandle((Object)handle);
        this.sendEvent(ce);
    }

    void sendEvent(ConnectionEvent event) {
        int type = event.getId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending connection event: " + type));
        }
        ConnectionEventListener[] list = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        block7: for (int i = 0; i < list.length; ++i) {
            switch (type) {
                case 1: {
                    list[i].connectionClosed(event);
                    continue block7;
                }
                case 2: {
                    list[i].localTransactionStarted(event);
                    continue block7;
                }
                case 3: {
                    list[i].localTransactionCommitted(event);
                    continue block7;
                }
                case 4: {
                    list[i].localTransactionRolledback(event);
                    continue block7;
                }
                case 5: {
                    list[i].connectionErrorOccurred(event);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Illegal eventType: " + type);
                }
            }
        }
    }

    Session getSession(JCASessionImpl handle) {
        LinkedList linkedList = this.handles;
        synchronized (linkedList) {
            if (this.handles.size() > 0 && this.handles.get(0) == handle) {
                return this.session;
            }
            String message = "Inactive logical session handle called";
            throw new IllegalStateException("Inactive logical session handle called");
        }
    }

    Connection getConnection() {
        return this.connection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

