/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.sql;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.hibernate.dialect.Dialect;

public final class Template {
    private static final Set KEYWORDS = new HashSet();
    public static final String TEMPLATE = "$PlaceHolder";

    private Template() {
    }

    public static String renderWhereStringTemplate(String sqlWhereString, Dialect dialect) {
        String nextToken;
        StringTokenizer tokens = new StringTokenizer(sqlWhereString, " =><!+-*/()',", true);
        StringBuffer result = new StringBuffer();
        boolean quoted = false;
        boolean afterFrom = false;
        boolean afterFromTable = false;
        boolean hasMore = tokens.hasMoreTokens();
        String string = nextToken = hasMore ? tokens.nextToken() : null;
        while (hasMore) {
            boolean isIdentifier;
            String token = nextToken;
            hasMore = tokens.hasMoreTokens();
            String string2 = nextToken = hasMore ? tokens.nextToken() : null;
            if ("'".equals(token)) {
                boolean bl = quoted = !quoted;
            }
            if (quoted || Character.isSpace(token.charAt(0))) {
                result.append(token);
                continue;
            }
            boolean bl = isIdentifier = token.charAt(0) == '`' || Character.isLetter(token.charAt(0)) && !KEYWORDS.contains(token.toLowerCase()) && token.indexOf(46) < 0;
            if (afterFrom) {
                result.append(token);
                afterFrom = false;
                afterFromTable = true;
                continue;
            }
            if (afterFromTable) {
                afterFromTable = false;
                result.append(token);
                continue;
            }
            if (isIdentifier && (nextToken == null || !nextToken.equals("("))) {
                result.append(TEMPLATE).append('.').append(Template.quote(token, dialect));
                continue;
            }
            if ("from".equals(token.toLowerCase())) {
                afterFrom = true;
            }
            result.append(token);
        }
        return result.toString();
    }

    public static String renderOrderByStringTemplate(String sqlOrderByString, Dialect dialect) {
        StringTokenizer tokens = new StringTokenizer(sqlOrderByString, ",");
        StringBuffer result = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String column = Template.quote(tokens.nextToken().trim(), dialect);
            result.append(TEMPLATE).append('.').append(column);
            if (!tokens.hasMoreTokens()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private static String quote(String column, Dialect dialect) {
        if (column.charAt(0) == '`') {
            return dialect.openQuote() + column.substring(1, column.length() - 1) + dialect.closeQuote();
        }
        return column;
    }

    static {
        KEYWORDS.add("and");
        KEYWORDS.add("or");
        KEYWORDS.add("not");
        KEYWORDS.add("like");
        KEYWORDS.add("is");
        KEYWORDS.add("in");
        KEYWORDS.add("between");
        KEYWORDS.add("null");
        KEYWORDS.add("select");
        KEYWORDS.add("from");
        KEYWORDS.add("where");
        KEYWORDS.add("having");
        KEYWORDS.add("group");
        KEYWORDS.add("order");
        KEYWORDS.add("by");
    }
}

