/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.SequencedHashMap;

public final class IdentityMap
implements Map {
    private final Map map;

    public static Map instantiate(int size) {
        return new IdentityMap(new HashMap(size));
    }

    public static Map instantiateSequenced(int size) {
        return new IdentityMap((Map)new SequencedHashMap(size));
    }

    private IdentityMap(Map underlyingMap) {
        this.map = underlyingMap;
    }

    public static Collection concurrentEntries(Map map) {
        return ((IdentityMap)map).entryList();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        IdentityKey k = new IdentityKey(key);
        return this.map.containsKey(k);
    }

    public boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    public Object get(Object key) {
        IdentityKey k = new IdentityKey(key);
        return this.map.get(k);
    }

    public Object put(Object key, Object value) {
        return this.map.put(new IdentityKey(key), value);
    }

    public Object remove(Object key) {
        IdentityKey k = new IdentityKey(key);
        return this.map.remove(k);
    }

    public void putAll(Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            this.put(me.getKey(), me.getValue());
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        HashSet<IdentityMapEntry> set = new HashSet<IdentityMapEntry>(this.map.size());
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            set.add(new IdentityMapEntry(((IdentityKey)me.getKey()).key, me.getValue()));
        }
        return set;
    }

    private List entryList() {
        ArrayList<IdentityMapEntry> list = new ArrayList<IdentityMapEntry>(this.map.size());
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            list.add(new IdentityMapEntry(((IdentityKey)me.getKey()).key, me.getValue()));
        }
        return list;
    }

    public static Object serialize(Map map) {
        return ((IdentityMap)map).map;
    }

    public static Map deserialize(Object o) {
        return new IdentityMap((Map)o);
    }

    public static final class IdentityKey
    implements Serializable {
        private Object key;

        IdentityKey(Object key) {
            this.key = key;
        }

        public boolean equals(Object other) {
            return this.key == ((IdentityKey)other).key;
        }

        public int hashCode() {
            return System.identityHashCode(this.key);
        }
    }

    public static final class IdentityMapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        IdentityMapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object result = this.value;
            this.value = value;
            return result;
        }
    }
}

