/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.lang.reflect.Method;
import net.sf.cglib.CodeGenerator;
import net.sf.cglib.KeyFactory;
import net.sf.cglib.MethodConstants;
import net.sf.cglib.ReflectUtils;

class KeyFactoryGenerator
extends CodeGenerator {
    private static final Method GET_ARGS = ReflectUtils.findMethod("KeyFactory.getArgs()");
    private Class keyInterface;
    private Method newInstance;
    private Class[] parameterTypes;
    private int numArgs;
    private static final int[] PRIMES = new int[]{11, 73, 179, 331, 521, 787, 1213, 1823, 2609, 3691, 5189, 7247, 10037, 13931, 19289, 26627, 36683, 50441, 69403, 95401, 131129, 180179, 247501, 340057, 467063, 641371, 880603, 1209107, 1660097, 2279161, 3129011, 4295723, 5897291, 8095873, 11114263, 15257791, 20946017, 28754629, 39474179, 54189869, 74391461, 102123817, 140194277, 192456917, 264202273, 362693231, 497900099, 683510293, 938313161, 1288102441, 1768288259};
    private final CodeGenerator.ProcessArrayCallback hashCallback = new CodeGenerator.ProcessArrayCallback(){

        public void processElement(Class type) {
            KeyFactoryGenerator.this.hash_code(type);
        }
    };
    static /* synthetic */ Class class$java$lang$Object;

    public KeyFactoryGenerator(String className, Class keyInterface, ClassLoader loader) {
        super(className, KeyFactory.TYPE, loader);
        this.keyInterface = keyInterface;
    }

    protected void generate() throws NoSuchFieldException {
        this.newInstance = ReflectUtils.findNewInstance(this.keyInterface);
        if (!this.newInstance.getReturnType().equals(class$java$lang$Object == null ? (class$java$lang$Object = KeyFactoryGenerator.class$("java.lang.Object")) : class$java$lang$Object)) {
            throw new IllegalArgumentException("newInstance method must return Object");
        }
        this.parameterTypes = this.newInstance.getParameterTypes();
        this.numArgs = this.parameterTypes.length;
        this.declare_interface(this.keyInterface);
        this.generateNullConstructor();
        this.generateConstructor();
        this.generateFactoryMethod(this.newInstance);
        this.generateEquals();
        this.generateGetArgs();
    }

    private void generateConstructor() throws NoSuchFieldException {
        this.begin_constructor(this.parameterTypes);
        this.load_this();
        this.super_invoke_constructor();
        this.load_this();
        int i = 0;
        while (i < this.numArgs) {
            this.declare_field(18, this.parameterTypes[i], this.getFieldName(i));
            this.dup();
            this.load_arg(i);
            this.putfield(this.getFieldName(i));
            ++i;
        }
        this.loadAndStoreConstant("hashMultiplier");
        this.loadAndStoreConstant("hashConstant");
        int i2 = 0;
        while (i2 < this.numArgs) {
            this.load_arg(i2);
            this.hash_code(this.parameterTypes[i2]);
            ++i2;
        }
        this.swap();
        this.pop();
        this.super_putfield("hash");
        this.return_value();
        this.end_method();
    }

    private void loadAndStoreConstant(String fieldName) throws NoSuchFieldException {
        this.push(this.pickHashConstant());
        this.load_this();
        this.swap();
        this.dup_x1();
        this.super_putfield(fieldName);
    }

    private void hash_code(Class clazz) {
        if (clazz.isArray()) {
            this.hash_array(clazz);
        } else {
            if (clazz.isPrimitive()) {
                this.hash_primitive(clazz);
            } else {
                this.hash_object();
            }
            this.iadd();
            this.swap();
            this.dup_x1();
            this.imul();
        }
    }

    private void hash_array(Class clazz) {
        Object isNull = this.make_label();
        Object end = this.make_label();
        this.dup();
        this.ifnull(isNull);
        this.process_array(clazz, this.hashCallback);
        this.goTo(end);
        this.nop(isNull);
        this.pop();
        this.nop(end);
    }

    private void hash_object() {
        Object isNull = this.make_label();
        Object end = this.make_label();
        this.dup();
        this.ifnull(isNull);
        this.invoke(MethodConstants.HASH_CODE);
        this.goTo(end);
        this.nop(isNull);
        this.pop();
        this.push(0);
        this.nop(end);
    }

    private void hash_primitive(Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            this.push(1);
            this.ixor();
        } else if (clazz.equals(Double.TYPE)) {
            this.invoke(MethodConstants.DOUBLE_TO_LONG_BITS);
            this.hash_long();
        } else if (clazz.equals(Float.TYPE)) {
            this.invoke(MethodConstants.FLOAT_TO_INT_BITS);
        } else if (clazz.equals(Long.TYPE)) {
            this.hash_long();
        }
    }

    private void hash_long() {
        this.push(32);
        this.lushr();
        this.lxor();
        this.l2i();
    }

    private int pickHashConstant() {
        return PRIMES[(int)((double)PRIMES.length * Math.random())];
    }

    private String getFieldName(int arg) {
        return "FIELD_" + arg;
    }

    private void generateEquals() {
        this.begin_method(MethodConstants.EQUALS);
        this.load_arg(0);
        this.instance_of_this();
        this.ifeq("failure");
        int i = 0;
        while (i < this.numArgs) {
            this.load_this();
            this.getfield(this.getFieldName(i));
            this.load_arg(0);
            this.checkcast_this();
            this.getfield(this.getFieldName(i));
            this.not_equals(this.parameterTypes[i], "failure");
            ++i;
        }
        this.push(1);
        this.return_value();
        this.nop("failure");
        this.push(0);
        this.return_value();
        this.end_method();
    }

    private void generateGetArgs() {
        this.begin_method(GET_ARGS);
        this.push(this.parameterTypes.length);
        this.newarray();
        int i = 0;
        while (i < this.parameterTypes.length) {
            this.dup();
            this.push(i);
            this.load_this();
            this.getfield(this.getFieldName(i));
            this.box(this.parameterTypes[i]);
            this.aastore();
            ++i;
        }
        this.return_value();
        this.end_method();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

