/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.lang.ObjectUtils;
import com.mchange.v2.ser.SerializableUtils;
import com.mchange.v2.ser.UnsupportedVersionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public abstract class WrapperConnectionPoolDataSource
implements ConnectionPoolDataSource,
Referenceable {
    static final Coalescer IMMUTABLES_COALESCER = CoalescerFactory.createCoalescer(true, true);
    transient DataSource nestedDataSource;
    transient int maxStatements = C3P0Defaults.maxStatements();
    transient int initialPoolSize = C3P0Defaults.initialPoolSize();
    transient int minPoolSize = C3P0Defaults.minPoolSize();
    transient int maxPoolSize = C3P0Defaults.maxPoolSize();
    transient int idleConnectionTestPeriod = C3P0Defaults.idleConnectionTestPeriod();
    transient int maxIdleTime = C3P0Defaults.maxIdleTime();
    transient int propertyCycle = C3P0Defaults.propertyCycle();
    transient int acquireIncrement = C3P0Defaults.acquireIncrement();
    transient String connectionTesterClassName = C3P0Defaults.connectionTester().getClass().getName();
    transient boolean testConnectionOnCheckout = C3P0Defaults.testConnectionOnCheckout();
    transient boolean autoCommitOnClose = C3P0Defaults.autoCommitOnClose();
    transient boolean forceIgnoreUnresolvedTransactions = C3P0Defaults.forceIgnoreUnresolvedTransactions();
    transient String factoryClassLocation;
    transient ConnectionTester connectionTester = C3P0Defaults.connectionTester();
    transient DbAuth auth = null;
    static final String REFADDR_VERSION = "version";
    static final String REFADDR_nestedDataSource = "nestedDataSource";
    static final String REFADDR_maxStatements = "maxStatements";
    static final String REFADDR_initialPoolSize = "initialPoolSize";
    static final String REFADDR_minPoolSize = "minPoolSize";
    static final String REFADDR_maxPoolSize = "maxPoolSize";
    static final String REFADDR_idleConnectionTestPeriod = "idleConnectionTestPeriod";
    static final String REFADDR_maxIdleTime = "maxIdleTime";
    static final String REFADDR_propertyCycle = "propertyCycle";
    static final String REFADDR_acquireIncrement = "acquireIncrement";
    static final String REFADDR_connectionTesterClassName = "connectionTesterClassName";
    static final String REFADDR_testConnectionOnCheckout = "testConnectionOnCheckout";
    static final String REFADDR_autoCommitOnClose = "autoCommitOnClose";
    static final String REFADDR_forceIgnoreUnresolvedTransactions = "forceIgnoreUnresolvedTransactions";
    static final int CURRENT_VERSION = 1;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$ObjectFactory;

    DataSource getNestedDataSource() {
        return this.nestedDataSource;
    }

    int getMaxStatements() {
        return this.maxStatements;
    }

    int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    int getMinPoolSize() {
        return this.minPoolSize;
    }

    int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    int getIdleConnectionTestPeriod() {
        return this.idleConnectionTestPeriod;
    }

    int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    int getPropertyCycle() {
        return this.propertyCycle;
    }

    int getAcquireIncrement() {
        return this.acquireIncrement;
    }

    String getConnectionTesterClassName() {
        return this.connectionTesterClassName;
    }

    boolean isTestConnectionOnCheckout() {
        return this.testConnectionOnCheckout;
    }

    boolean isAutoCommitOnClose() {
        return this.autoCommitOnClose;
    }

    boolean isForceIgnoreUnresolvedTransactions() {
        return this.forceIgnoreUnresolvedTransactions;
    }

    String getUser() {
        return this.auth.getUser();
    }

    String getPassword() {
        return this.auth.getPassword();
    }

    String getFactoryClassLocation() {
        return this.factoryClassLocation;
    }

    void setNestedDataSource(DataSource nestedDataSource) {
        this.nestedDataSource = nestedDataSource;
        this._findAuth();
    }

    void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }

    void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    void setIdleConnectionTestPeriod(int idleConnectionTestPeriod) {
        this.idleConnectionTestPeriod = idleConnectionTestPeriod;
    }

    void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    void setPropertyCycle(int propertyCycle) {
        this.propertyCycle = propertyCycle;
    }

    void setAcquireIncrement(int acquireIncrement) {
        this.acquireIncrement = acquireIncrement;
    }

    void setConnectionTesterClassName(String connectionTesterClassName) {
        this.connectionTesterClassName = connectionTesterClassName;
        this._instantiateConnectionTester();
    }

    void setTestConnectionOnCheckout(boolean testConnectionOnCheckout) {
        this.testConnectionOnCheckout = testConnectionOnCheckout;
    }

    void setAutoCommitOnClose(boolean autoCommitOnClose) {
        this.autoCommitOnClose = autoCommitOnClose;
    }

    void setForceIgnoreUnresolvedTransactions(boolean forceIgnoreUnresolvedTransactions) {
        this.forceIgnoreUnresolvedTransactions = forceIgnoreUnresolvedTransactions;
    }

    void setFactoryClassLocation(String factoryClassLocation) {
        this.factoryClassLocation = factoryClassLocation;
    }

    public Immutable asImmutable() {
        return Immutable.find(this.nestedDataSource, this.maxStatements, this.initialPoolSize, this.minPoolSize, this.maxPoolSize, this.idleConnectionTestPeriod, this.maxIdleTime, this.propertyCycle, this.acquireIncrement, this.connectionTesterClassName, this.testConnectionOnCheckout, this.autoCommitOnClose, this.forceIgnoreUnresolvedTransactions, this.factoryClassLocation);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return new C3P0PooledConnection(this.nestedDataSource.getConnection(), this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new C3P0PooledConnection(this.nestedDataSource.getConnection(user, password), this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.nestedDataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.nestedDataSource.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.nestedDataSource.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.nestedDataSource.getLoginTimeout();
    }

    void _instantiateConnectionTester() {
        try {
            this.connectionTester = (ConnectionTester)Class.forName(this.connectionTesterClassName).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not instantiate specified connection tester class: " + this.connectionTesterClassName);
        }
    }

    void _findAuth() {
        try {
            this.auth = C3P0ImplUtils.findAuth(this.nestedDataSource);
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.auth = C3P0ImplUtils.NULL_AUTH;
        }
    }

    private static boolean parseBoolean(String sRep) {
        return Boolean.valueOf(sRep);
    }

    private static char firstChar(String s) {
        return s.charAt(0);
    }

    public final Reference getReference() throws NamingException {
        try {
            Reference out = new Reference((class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable = WrapperConnectionPoolDataSource.class$("com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable).getName(), (class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$ObjectFactory == null ? (class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$ObjectFactory = WrapperConnectionPoolDataSource.class$("com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSource$ObjectFactory")) : class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$ObjectFactory).getName(), this.factoryClassLocation);
            out.add(new StringRefAddr(REFADDR_VERSION, String.valueOf(1)));
            out.add(new BinaryRefAddr(REFADDR_nestedDataSource, SerializableUtils.toByteArray(this.nestedDataSource)));
            out.add(new StringRefAddr(REFADDR_maxStatements, String.valueOf(this.maxStatements)));
            out.add(new StringRefAddr(REFADDR_initialPoolSize, String.valueOf(this.initialPoolSize)));
            out.add(new StringRefAddr(REFADDR_minPoolSize, String.valueOf(this.minPoolSize)));
            out.add(new StringRefAddr(REFADDR_maxPoolSize, String.valueOf(this.maxPoolSize)));
            out.add(new StringRefAddr(REFADDR_idleConnectionTestPeriod, String.valueOf(this.idleConnectionTestPeriod)));
            out.add(new StringRefAddr(REFADDR_maxIdleTime, String.valueOf(this.maxIdleTime)));
            out.add(new StringRefAddr(REFADDR_propertyCycle, String.valueOf(this.propertyCycle)));
            out.add(new StringRefAddr(REFADDR_acquireIncrement, String.valueOf(this.acquireIncrement)));
            out.add(new StringRefAddr(REFADDR_connectionTesterClassName, this.connectionTesterClassName));
            out.add(new StringRefAddr(REFADDR_testConnectionOnCheckout, String.valueOf(this.testConnectionOnCheckout)));
            out.add(new StringRefAddr(REFADDR_autoCommitOnClose, String.valueOf(this.autoCommitOnClose)));
            out.add(new StringRefAddr(REFADDR_forceIgnoreUnresolvedTransactions, String.valueOf(this.forceIgnoreUnresolvedTransactions)));
            return out;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NamingException("Nested Exception: " + e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class Mutable
    extends WrapperConnectionPoolDataSource
    implements Serializable {
        public synchronized DataSource getNestedDataSource() {
            return super.getNestedDataSource();
        }

        public synchronized int getMaxStatements() {
            return super.getMaxStatements();
        }

        public synchronized int getInitialPoolSize() {
            return super.getInitialPoolSize();
        }

        public synchronized int getMinPoolSize() {
            return super.getMinPoolSize();
        }

        public synchronized int getMaxPoolSize() {
            return super.getMaxPoolSize();
        }

        public synchronized int getIdleConnectionTestPeriod() {
            return super.getIdleConnectionTestPeriod();
        }

        public synchronized int getMaxIdleTime() {
            return super.getMaxIdleTime();
        }

        public synchronized int getPropertyCycle() {
            return super.getPropertyCycle();
        }

        public synchronized int getAcquireIncrement() {
            return super.getAcquireIncrement();
        }

        public synchronized String getConnectionTesterClassName() {
            return super.getConnectionTesterClassName();
        }

        public synchronized boolean isTestConnectionOnCheckout() {
            return super.isTestConnectionOnCheckout();
        }

        public synchronized boolean isAutoCommitOnClose() {
            return super.isAutoCommitOnClose();
        }

        public synchronized boolean isForceIgnoreUnresolvedTransactions() {
            return super.isForceIgnoreUnresolvedTransactions();
        }

        public synchronized String getUser() {
            return super.getUser();
        }

        public synchronized String getPassword() {
            return super.getPassword();
        }

        public synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public synchronized void setNestedDataSource(DataSource nestedDataSource) {
            super.setNestedDataSource(nestedDataSource);
        }

        public synchronized void setMaxStatements(int maxStatements) {
            super.setMaxStatements(maxStatements);
        }

        public synchronized void setInitialPoolSize(int initialPoolSize) {
            super.setInitialPoolSize(initialPoolSize);
        }

        public synchronized void setMinPoolSize(int minPoolSize) {
            super.setMinPoolSize(minPoolSize);
        }

        public synchronized void setMaxPoolSize(int maxPoolSize) {
            super.setMaxPoolSize(maxPoolSize);
        }

        public synchronized void setIdleConnectionTestPeriod(int idleConnectionTestPeriod) {
            super.setIdleConnectionTestPeriod(idleConnectionTestPeriod);
        }

        public synchronized void setMaxIdleTime(int maxIdleTime) {
            super.setMaxIdleTime(maxIdleTime);
        }

        public synchronized void setPropertyCycle(int propertyCycle) {
            super.setPropertyCycle(propertyCycle);
        }

        public synchronized void setAcquireIncrement(int acquireIncrement) {
            super.setAcquireIncrement(acquireIncrement);
        }

        public synchronized void setConnectionTesterClassName(String connectionTesterClassName) {
            super.setConnectionTesterClassName(connectionTesterClassName);
        }

        public synchronized void setTestConnectionOnCheckout(boolean testConnectionOnCheckout) {
            super.setTestConnectionOnCheckout(testConnectionOnCheckout);
        }

        public synchronized void setAutoCommitOnClose(boolean autoCommitOnClose) {
            super.setAutoCommitOnClose(autoCommitOnClose);
        }

        public synchronized void setForceIgnoreUnresolvedTransactions(boolean forceIgnoreUnresolvedTransactions) {
            super.setForceIgnoreUnresolvedTransactions(forceIgnoreUnresolvedTransactions);
        }

        public synchronized void setFactoryClassLocation(String factoryClassLocation) {
            super.setFactoryClassLocation(factoryClassLocation);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of WrapperConnectionPoolDataSource");
        }

        private void readObject(ObjectInputStream in) throws IOException {
            throw new IOException("We should not be finding this mutable version of WrapperConnectionPoolDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static abstract class Base
    extends WrapperConnectionPoolDataSource
    implements Serializable {
        protected synchronized DataSource getNestedDataSource() {
            return super.getNestedDataSource();
        }

        protected synchronized int getMaxStatements() {
            return super.getMaxStatements();
        }

        protected synchronized int getInitialPoolSize() {
            return super.getInitialPoolSize();
        }

        protected synchronized int getMinPoolSize() {
            return super.getMinPoolSize();
        }

        protected synchronized int getMaxPoolSize() {
            return super.getMaxPoolSize();
        }

        protected synchronized int getIdleConnectionTestPeriod() {
            return super.getIdleConnectionTestPeriod();
        }

        protected synchronized int getMaxIdleTime() {
            return super.getMaxIdleTime();
        }

        protected synchronized int getPropertyCycle() {
            return super.getPropertyCycle();
        }

        protected synchronized int getAcquireIncrement() {
            return super.getAcquireIncrement();
        }

        protected synchronized String getConnectionTesterClassName() {
            return super.getConnectionTesterClassName();
        }

        protected synchronized boolean isTestConnectionOnCheckout() {
            return super.isTestConnectionOnCheckout();
        }

        protected synchronized boolean isAutoCommitOnClose() {
            return super.isAutoCommitOnClose();
        }

        protected synchronized boolean isForceIgnoreUnresolvedTransactions() {
            return super.isForceIgnoreUnresolvedTransactions();
        }

        protected synchronized String getUser() {
            return super.getUser();
        }

        protected synchronized String getPassword() {
            return super.getPassword();
        }

        protected synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        protected synchronized void setNestedDataSource(DataSource nestedDataSource) {
            super.setNestedDataSource(nestedDataSource);
        }

        protected synchronized void setMaxStatements(int maxStatements) {
            super.setMaxStatements(maxStatements);
        }

        protected synchronized void setInitialPoolSize(int initialPoolSize) {
            super.setInitialPoolSize(initialPoolSize);
        }

        protected synchronized void setMinPoolSize(int minPoolSize) {
            super.setMinPoolSize(minPoolSize);
        }

        protected synchronized void setMaxPoolSize(int maxPoolSize) {
            super.setMaxPoolSize(maxPoolSize);
        }

        protected synchronized void setIdleConnectionTestPeriod(int idleConnectionTestPeriod) {
            super.setIdleConnectionTestPeriod(idleConnectionTestPeriod);
        }

        protected synchronized void setMaxIdleTime(int maxIdleTime) {
            super.setMaxIdleTime(maxIdleTime);
        }

        protected synchronized void setPropertyCycle(int propertyCycle) {
            super.setPropertyCycle(propertyCycle);
        }

        protected synchronized void setAcquireIncrement(int acquireIncrement) {
            super.setAcquireIncrement(acquireIncrement);
        }

        protected synchronized void setConnectionTesterClassName(String connectionTesterClassName) {
            super.setConnectionTesterClassName(connectionTesterClassName);
        }

        protected synchronized void setTestConnectionOnCheckout(boolean testConnectionOnCheckout) {
            super.setTestConnectionOnCheckout(testConnectionOnCheckout);
        }

        protected synchronized void setAutoCommitOnClose(boolean autoCommitOnClose) {
            super.setAutoCommitOnClose(autoCommitOnClose);
        }

        protected synchronized void setForceIgnoreUnresolvedTransactions(boolean forceIgnoreUnresolvedTransactions) {
            super.setForceIgnoreUnresolvedTransactions(forceIgnoreUnresolvedTransactions);
        }

        protected synchronized void setFactoryClassLocation(String factoryClassLocation) {
            super.setFactoryClassLocation(factoryClassLocation);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of WrapperConnectionPoolDataSource");
        }

        private void readObject(ObjectInputStream in) throws IOException {
            throw new IOException("We should not be finding this mutable version of WrapperConnectionPoolDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static final class Immutable
    extends WrapperConnectionPoolDataSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final short VERSION = 1;

        public static Immutable find(DataSource _nestedDataSource, int _maxStatements, int _initialPoolSize, int _minPoolSize, int _maxPoolSize, int _idleConnectionTestPeriod, int _maxIdleTime, int _propertyCycle, int _acquireIncrement, String _connectionTesterClassName, boolean _testConnectionOnCheckout, boolean _autoCommitOnClose, boolean _forceIgnoreUnresolvedTransactions, String _factoryClassLocation) {
            Immutable uncanonical = new Immutable();
            uncanonical.nestedDataSource = _nestedDataSource;
            uncanonical._findAuth();
            uncanonical.maxStatements = _maxStatements;
            uncanonical.initialPoolSize = _initialPoolSize;
            uncanonical.minPoolSize = _minPoolSize;
            uncanonical.maxPoolSize = _maxPoolSize;
            uncanonical.idleConnectionTestPeriod = _idleConnectionTestPeriod;
            uncanonical.maxIdleTime = _maxIdleTime;
            uncanonical.propertyCycle = _propertyCycle;
            uncanonical.acquireIncrement = _acquireIncrement;
            uncanonical.connectionTesterClassName = _connectionTesterClassName;
            uncanonical._instantiateConnectionTester();
            uncanonical.testConnectionOnCheckout = _testConnectionOnCheckout;
            uncanonical.autoCommitOnClose = _autoCommitOnClose;
            uncanonical.forceIgnoreUnresolvedTransactions = _forceIgnoreUnresolvedTransactions;
            uncanonical.factoryClassLocation = _factoryClassLocation;
            return (Immutable)IMMUTABLES_COALESCER.coalesce(uncanonical);
        }

        private Immutable() {
        }

        public DataSource getNestedDataSource() {
            return super.getNestedDataSource();
        }

        public int getMaxStatements() {
            return super.getMaxStatements();
        }

        public int getInitialPoolSize() {
            return super.getInitialPoolSize();
        }

        public int getMinPoolSize() {
            return super.getMinPoolSize();
        }

        public int getMaxPoolSize() {
            return super.getMaxPoolSize();
        }

        public int getIdleConnectionTestPeriod() {
            return super.getIdleConnectionTestPeriod();
        }

        public int getMaxIdleTime() {
            return super.getMaxIdleTime();
        }

        public int getPropertyCycle() {
            return super.getPropertyCycle();
        }

        public int getAcquireIncrement() {
            return super.getAcquireIncrement();
        }

        public String getConnectionTesterClassName() {
            return super.getConnectionTesterClassName();
        }

        public boolean isTestConnectionOnCheckout() {
            return super.isTestConnectionOnCheckout();
        }

        public boolean isAutoCommitOnClose() {
            return super.isAutoCommitOnClose();
        }

        public boolean isForceIgnoreUnresolvedTransactions() {
            return super.isForceIgnoreUnresolvedTransactions();
        }

        public String getUser() {
            return super.getUser();
        }

        public String getPassword() {
            return super.getPassword();
        }

        public String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public Immutable asImmutable() {
            return this;
        }

        public boolean equals(Object o) {
            if (o instanceof Immutable) {
                Immutable other = (Immutable)o;
                return ObjectUtils.eqOrBothNull(this.nestedDataSource, other.nestedDataSource) && this.maxStatements == other.maxStatements && this.initialPoolSize == other.initialPoolSize && this.minPoolSize == other.minPoolSize && this.maxPoolSize == other.maxPoolSize && this.idleConnectionTestPeriod == other.idleConnectionTestPeriod && this.maxIdleTime == other.maxIdleTime && this.propertyCycle == other.propertyCycle && this.acquireIncrement == other.acquireIncrement && ObjectUtils.eqOrBothNull(this.connectionTesterClassName, other.connectionTesterClassName) && this.testConnectionOnCheckout == other.testConnectionOnCheckout && this.autoCommitOnClose == other.autoCommitOnClose && this.forceIgnoreUnresolvedTransactions == other.forceIgnoreUnresolvedTransactions && ObjectUtils.eqOrBothNull(this.factoryClassLocation, other.factoryClassLocation);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtils.hashOrZero(this.nestedDataSource) ^ this.maxStatements ^ this.initialPoolSize ^ this.minPoolSize ^ this.maxPoolSize ^ this.idleConnectionTestPeriod ^ this.maxIdleTime ^ this.propertyCycle ^ this.acquireIncrement ^ ObjectUtils.hashOrZero(this.connectionTesterClassName) ^ (this.testConnectionOnCheckout ? 1 : 0) ^ (this.autoCommitOnClose ? 1 : 0) ^ (this.forceIgnoreUnresolvedTransactions ? 1 : 0) ^ ObjectUtils.hashOrZero(this.factoryClassLocation);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeShort(1);
            out.writeObject(this.nestedDataSource);
            out.writeInt(this.maxStatements);
            out.writeInt(this.initialPoolSize);
            out.writeInt(this.minPoolSize);
            out.writeInt(this.maxPoolSize);
            out.writeInt(this.idleConnectionTestPeriod);
            out.writeInt(this.maxIdleTime);
            out.writeInt(this.propertyCycle);
            out.writeInt(this.acquireIncrement);
            out.writeObject(this.connectionTesterClassName);
            out.writeBoolean(this.testConnectionOnCheckout);
            out.writeBoolean(this.autoCommitOnClose);
            out.writeBoolean(this.forceIgnoreUnresolvedTransactions);
            out.writeObject(this.factoryClassLocation);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            short version = in.readShort();
            switch (version) {
                case 1: {
                    this.nestedDataSource = (DataSource)in.readObject();
                    this._findAuth();
                    this.maxStatements = in.readInt();
                    this.initialPoolSize = in.readInt();
                    this.minPoolSize = in.readInt();
                    this.maxPoolSize = in.readInt();
                    this.idleConnectionTestPeriod = in.readInt();
                    this.maxIdleTime = in.readInt();
                    this.propertyCycle = in.readInt();
                    this.acquireIncrement = in.readInt();
                    this.connectionTesterClassName = (String)in.readObject();
                    this._instantiateConnectionTester();
                    this.testConnectionOnCheckout = in.readBoolean();
                    this.autoCommitOnClose = in.readBoolean();
                    this.forceIgnoreUnresolvedTransactions = in.readBoolean();
                    this.factoryClassLocation = (String)in.readObject();
                    break;
                }
                default: {
                    throw new UnsupportedVersionException(this, version);
                }
            }
        }
    }

    public static class ObjectFactory
    implements javax.naming.spi.ObjectFactory {
        static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable;

        public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
            Reference ref;
            String className = (class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable = ObjectFactory.class$("com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable).getName();
            if (refObj instanceof Reference && (ref = (Reference)refObj).getClassName().equals(className)) {
                int version = Integer.parseInt((String)ref.get(WrapperConnectionPoolDataSource.REFADDR_VERSION).getContent());
                if (version == 1) {
                    DataSource nascentNestedDataSource = (DataSource)SerializableUtils.fromByteArray((byte[])ref.get(WrapperConnectionPoolDataSource.REFADDR_nestedDataSource).getContent());
                    int nascentMaxStatements = Integer.parseInt((String)ref.get(WrapperConnectionPoolDataSource.REFADDR_maxStatements).getContent());
                    int nascentInitialPoolSize = Integer.parseInt((String)ref.get(WrapperConnectionPoolDataSource.REFADDR_initialPoolSize).getContent());
                    int nascentMinPoolSize = Integer.parseInt((String)ref.get(WrapperConnectionPoolDataSource.REFADDR_minPoolSize).getContent());
                    int nascentMaxPoolSize = Integer.parseInt((String)ref.get(WrapperConnectionPoolDataSource.REFADDR_maxPoolSize).getContent());
                    int nascentIdleConnectionTestPeriod = Integer.parseInt((String)ref.get(WrapperConnectionPoolDataSource.REFADDR_idleConnectionTestPeriod).getContent());
                    int nascentMaxIdleTime = Integer.parseInt((String)ref.get(WrapperConnectionPoolDataSource.REFADDR_maxIdleTime).getContent());
                    int nascentPropertyCycle = Integer.parseInt((String)ref.get(WrapperConnectionPoolDataSource.REFADDR_propertyCycle).getContent());
                    int nascentAcquireIncrement = Integer.parseInt((String)ref.get(WrapperConnectionPoolDataSource.REFADDR_acquireIncrement).getContent());
                    String nascentConnectionTesterClassName = (String)ref.get(WrapperConnectionPoolDataSource.REFADDR_connectionTesterClassName).getContent();
                    boolean nascentTestConnectionOnCheckout = WrapperConnectionPoolDataSource.parseBoolean((String)ref.get(WrapperConnectionPoolDataSource.REFADDR_testConnectionOnCheckout).getContent());
                    boolean nascentAutoCommitOnClose = WrapperConnectionPoolDataSource.parseBoolean((String)ref.get(WrapperConnectionPoolDataSource.REFADDR_autoCommitOnClose).getContent());
                    boolean nascentForceIgnoreUnresolvedTransactions = WrapperConnectionPoolDataSource.parseBoolean((String)ref.get(WrapperConnectionPoolDataSource.REFADDR_forceIgnoreUnresolvedTransactions).getContent());
                    return Immutable.find(nascentNestedDataSource, nascentMaxStatements, nascentInitialPoolSize, nascentMinPoolSize, nascentMaxPoolSize, nascentIdleConnectionTestPeriod, nascentMaxIdleTime, nascentPropertyCycle, nascentAcquireIncrement, nascentConnectionTesterClassName, nascentTestConnectionOnCheckout, nascentAutoCommitOnClose, nascentForceIgnoreUnresolvedTransactions, ref.getFactoryClassLocation());
                }
                throw new NamingException("Cannot resolve reference (version " + version + " unknown.");
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

