/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.test;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.PoolBackedDataSourceFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import javax.sql.DataSource;

public final class PSLoadPoolBackedDataSource {
    static final String INSERT_STMT = "INSERT INTO testpbds VALUES ( ? , ? )";
    static final String SELECT_STMT = "SELECT count(*) FROM testpbds";
    static Random random = new Random();
    static DataSource ds;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] argv) {
        try {
            block8: {
                ds = PoolBackedDataSourceFactory.create("org.postgresql.Driver", "jdbc:postgresql://localhost/test", "swaldman", "test", 3, 15, 5, 30, 6);
                Connection con = null;
                Statement stmt = null;
                try {
                    Object var5_4;
                    try {
                        con = ds.getConnection();
                        stmt = con.createStatement();
                        stmt.executeUpdate("CREATE TABLE testpbds ( a varchar(16), b varchar(16) )");
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        System.err.println("relation testpbds already exists, or something bad happened.");
                        var5_4 = null;
                        StatementUtils.attemptClose(stmt);
                        ConnectionUtils.attemptClose(con);
                        break block8;
                    }
                    var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    StatementUtils.attemptClose(stmt);
                    ConnectionUtils.attemptClose(con);
                    throw throwable;
                }
                StatementUtils.attemptClose(stmt);
                ConnectionUtils.attemptClose(con);
            }
            int i = 0;
            while (true) {
                if (i >= 50) {
                    return;
                }
                ChurnThread t = new ChurnThread();
                t.start();
                System.out.println("THREAD MADE [" + i + "]");
                Thread.sleep(1000L);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void executeInsert(Connection con) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(INSERT_STMT);
            pstmt.setInt(1, random.nextInt());
            pstmt.setInt(2, random.nextInt());
            pstmt.executeUpdate();
            System.out.println("INSERTION");
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            StatementUtils.attemptClose(pstmt);
            throw throwable;
        }
        StatementUtils.attemptClose(pstmt);
    }

    static void executeSelect(Connection con) throws SQLException {
        long l = System.currentTimeMillis();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(SELECT_STMT);
            rs = pstmt.executeQuery();
            rs.next();
            System.out.println("SELECT [count=" + rs.getInt(1) + ", time=" + (System.currentTimeMillis() - l) + " msecs]");
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ResultSetUtils.attemptClose(rs);
            StatementUtils.attemptClose(pstmt);
            throw throwable;
        }
        ResultSetUtils.attemptClose(rs);
        StatementUtils.attemptClose(pstmt);
    }

    static class ChurnThread
    extends Thread {
        ChurnThread() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Object var4_4;
                    Connection con = null;
                    try {
                        con = ds.getConnection();
                        boolean select = random.nextBoolean();
                        if (select) {
                            PSLoadPoolBackedDataSource.executeSelect(con);
                        } else {
                            PSLoadPoolBackedDataSource.executeInsert(con);
                        }
                        var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        var4_4 = null;
                        ConnectionUtils.attemptClose(con);
                        throw throwable;
                    }
                    ConnectionUtils.attemptClose(con);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

