/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import middlegen.MiddlegenException;
import middlegen.TableDecorator;
import middlegen.TableElement;
import org.apache.log4j.Category;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public final class FileProducer {
    private File _destinationDir;
    private String _destinationFileName;
    private URL _template;
    private final Map _contexMap = new HashMap();
    private Map _tableElements = new HashMap();
    private String _id;
    private boolean _isCustom;
    private static Category _log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.FileProducer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public FileProducer() {
        this._isCustom = true;
    }

    public FileProducer(File destinationDir, String destinationFileName, URL template) {
        this._isCustom = false;
        if (destinationDir == null) {
            throw new IllegalArgumentException("destinationDir can't be null");
        }
        if (destinationFileName == null) {
            throw new IllegalArgumentException("destinationFileName can't be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("template can't be null");
        }
        this.setDestination(destinationDir);
        this.setFilename(destinationFileName);
        this.setTemplate(template);
        int lastSlash = template.toString().lastIndexOf("/");
        int lastDot = template.toString().lastIndexOf(".");
        String id = template.toString().substring(lastSlash + 1, lastDot);
        this.setId(id);
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setDestination(File destinationDir) {
        this._destinationDir = destinationDir;
    }

    public void setFilename(String destinationFileName) {
        this._destinationFileName = destinationFileName;
    }

    public void setTemplate(File template) {
        try {
            this.setTemplate(template.toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public String getId() {
        return this._id;
    }

    public boolean isGenerationPerTable() {
        return this._destinationFileName.indexOf("{0}") != -1;
    }

    public void validate() throws IllegalStateException {
        if (this._template == null) {
            String msg = "Please specify the template attribute in the fileproducer.";
            _log.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        if (this._isCustom) {
            if (this.getId() != null) {
                if (this._destinationDir != null) {
                    String msg = "In fileproducer with id=\"" + this.getId() + "\", destination should *not* be specified. " + "The fileproducer is overriding an existing template in the plugin, " + "but the plugin should still decide where to store the generated file. " + this._destinationDir.getAbsolutePath();
                    _log.error((Object)msg);
                    throw new IllegalStateException(msg);
                }
                if (this._destinationFileName != null) {
                    String msg = "In fileproducer with id=\"" + this.getId() + "\", filename should *not* be specified. " + "The fileproducer is overriding an existing template in the plugin, " + "but the plugin should still decide how to name the generated file. " + this._destinationFileName;
                    _log.error((Object)msg);
                    throw new IllegalStateException(msg);
                }
            } else {
                if (this._destinationDir == null) {
                    String msg = "Please specify the destination attribute in the fileproducer.";
                    _log.error((Object)msg);
                    throw new IllegalStateException(msg);
                }
                if (this._destinationDir == null) {
                    String msg = "Please specify the filename attribute in the fileproducer.";
                    _log.error((Object)msg);
                    throw new IllegalStateException(msg);
                }
            }
        }
    }

    public void addConfiguredTable(TableElement tableElement) {
        this._tableElements.put(tableElement.getName(), tableElement);
    }

    public void generateForTable(VelocityEngine velocityEngine, TableDecorator tableDecorator) throws MiddlegenException {
        File destinationDir = new File(this._destinationDir, tableDecorator.getSubDirPath());
        String destinationFileName = MessageFormat.format(this._destinationFileName, tableDecorator.getReplaceName());
        File outputFile = new File(destinationDir, destinationFileName);
        this.getContextMap().put("table", tableDecorator);
        this.generate(velocityEngine, outputFile);
    }

    public void generateForTables(VelocityEngine velocityEngine, Collection tableDecorators) throws MiddlegenException {
        File outputFile = new File(this._destinationDir, this._destinationFileName);
        this.getContextMap().put("tables", tableDecorators);
        this.generate(velocityEngine, outputFile);
    }

    void setTemplate(URL template) {
        this._template = template;
    }

    Map getContextMap() {
        return this._contexMap;
    }

    void copyPropsFrom(FileProducer other) {
        this._destinationDir = other._destinationDir;
        this._destinationFileName = other._destinationFileName;
    }

    boolean accept(TableDecorator tableDecorator) {
        if (this._tableElements.size() == 0) {
            return true;
        }
        return this._tableElements.containsKey(tableDecorator.getSqlName());
    }

    private void generate(VelocityEngine velocityEngine, File outputFile) throws MiddlegenException {
        try {
            VelocityContext context = new VelocityContext(this.getContextMap());
            outputFile.getParentFile().mkdirs();
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
            BufferedReader templateReader = new BufferedReader(new InputStreamReader(this._template.openStream()));
            _log.info((Object)("Generating " + outputFile.getAbsolutePath() + " using template from " + this._template.toString()));
            boolean success = velocityEngine.evaluate((Context)context, (Writer)writer, "middlegen", (Reader)templateReader);
            writer.flush();
            writer.close();
            if (!success) {
                throw new MiddlegenException("Velocity failed");
            }
        }
        catch (IOException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
            throw new MiddlegenException(e.getMessage());
        }
        catch (ParseErrorException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
            throw new MiddlegenException(e.getMessage());
        }
        catch (MethodInvocationException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
            throw new MiddlegenException(e.getMessage());
        }
        catch (ResourceNotFoundException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw new MiddlegenException(e.getMessage());
        }
    }
}

