/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import middlegen.Column;
import middlegen.ColumnMap;
import middlegen.CrossrefElement;
import middlegen.Database;
import middlegen.DatabaseInfo;
import middlegen.DbColumn;
import middlegen.DbNameConverter;
import middlegen.DbTable;
import middlegen.Many2ManyElement;
import middlegen.Middlegen;
import middlegen.MiddlegenException;
import middlegen.Relation;
import middlegen.RelationshipRole;
import middlegen.TableElement;
import middlegen.Util;
import middlegen.javax.Sql2Java;
import org.apache.log4j.Category;

public class MiddlegenPopulator {
    private Database _database;
    private DatabaseMetaData _metaData;
    private Middlegen _middlegen;
    private String _schema;
    private String _catalog;
    private String[] _types = null;
    private final Map _many2many;
    private Connection _connection;
    private final Collection EMPTY_COLLECTION = new ArrayList(0);
    private static Category _log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.MiddlegenPopulator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public MiddlegenPopulator(Middlegen middlegen, Database database, String schema, String catalog, Map many2many) throws MiddlegenException {
        this._middlegen = middlegen;
        this._database = database;
        this._schema = schema;
        this._catalog = catalog;
        this._many2many = many2many;
        try {
            this.tune(this.getConnection().getMetaData());
        }
        catch (SQLException e) {
            throw new MiddlegenException("Couldn't tune database:" + e.getMessage());
        }
    }

    public void addRegularTableElements() throws MiddlegenException {
        ResultSet tableRs;
        block26: {
            tableRs = null;
            try {
                StringBuffer sb;
                String nl;
                ResultSet catalogRs;
                ResultSet schemaRs;
                try {
                    tableRs = this.getMetaData().getTables(this._catalog, this._schema, null, this._types);
                    while (tableRs.next()) {
                        String tableName = tableRs.getString("TABLE_NAME");
                        String tableType = tableRs.getString("TABLE_TYPE");
                        String schemaName = tableRs.getString("TABLE_SCHEM");
                        if ("TABLE".equals(tableType)) {
                            _log.debug((Object)("schema:" + this._schema + "," + schemaName));
                            _log.debug((Object)("table:" + tableName));
                            TableElement tableElement = new TableElement();
                            tableElement.setName(tableName);
                            this._middlegen.addTableElement(tableElement);
                            continue;
                        }
                        _log.debug((Object)("Ignoring table " + tableName + " of type " + tableType));
                    }
                    if (this._middlegen.getTableElements().isEmpty()) {
                        throw new MiddlegenException("Middlegen successfully connected to the database, but couldn't find any tables. Perhaps the specified schema or catalog is wrong? -Or maybe there aren't any tables in the database at all?");
                    }
                    break block26;
                }
                catch (SQLException e) {
                    schemaRs = null;
                    catalogRs = null;
                    nl = System.getProperty("line.separator");
                    sb = new StringBuffer(nl);
                    sb.append("Configured schema:").append(this._schema).append(nl);
                    sb.append("Configured catalog:").append(this._catalog).append(nl);
                    try {
                        try {
                            schemaRs = this.getMetaData().getSchemas();
                            sb.append("Available schemas:").append(nl);
                            while (schemaRs.next()) {
                                sb.append("  ").append(schemaRs.getString("TABLE_SCHEM ")).append(nl);
                            }
                        }
                        catch (SQLException e2) {
                            sb.append("  ?? Couldn't get schemas ??").append(nl);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_15 = null;
                        try {
                            schemaRs.close();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                Object var8_16 = null;
                try {
                    schemaRs.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                try {
                    try {
                        catalogRs = this.getMetaData().getCatalogs();
                        sb.append("Available catalogs:").append(nl);
                        while (catalogRs.next()) {
                            sb.append("  ").append(catalogRs.getString("TABLE_CAT")).append(nl);
                        }
                    }
                    catch (SQLException e2) {
                        sb.append("  ?? Couldn't get catalogs ??").append(nl);
                    }
                }
                catch (Throwable throwable) {
                    var8_16 = null;
                    try {
                        catalogRs.close();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
                var8_16 = null;
                try {
                    catalogRs.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                _log.error((Object)e.getMessage(), (Throwable)e);
                throw new MiddlegenException("Couldn't get list of tables from database. Probably a JDBC driver problem." + sb.toString());
            }
            catch (Throwable throwable) {
                Object var11_20 = null;
                try {
                    tableRs.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        Object var11_21 = null;
        try {
            tableRs.close();
        }
        catch (Exception ignore) {}
    }

    public void closeConnection() {
        try {
            if (this._connection != null) {
                this._connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void populate(Map wantedTables) throws MiddlegenException {
        try {
            DbTable table;
            this.addTables(wantedTables);
            Iterator tableIterator = this._middlegen.getTables().iterator();
            while (tableIterator.hasNext()) {
                table = (DbTable)tableIterator.next();
                this.addColumns(table);
            }
            tableIterator = this._middlegen.getTables().iterator();
            while (tableIterator.hasNext()) {
                table = (DbTable)tableIterator.next();
                this.addRelations(table, wantedTables);
            }
            if (this._middlegen.getRelations().size() == 0) {
                _log.warn((Object)"WARNING: Middlegen couldn't find any relations between any tables. This may be intentional from the design of the database, but it may also be because you have incorrectly defined the relationships. It could also be because the JDBC driver you're using doesn't correctly implement DatabaseMetaData. See the samples (for an example on how to define relationships) and verify that your driver correctly implements DatabaseMetaData.");
            }
            this.addMany2ManyRelations();
            this.warnUnidentifiedM2ms();
            this.getConnection().close();
        }
        catch (SQLException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
            throw new MiddlegenException("Database problem:" + e.getMessage());
        }
    }

    protected void addRelations(DbTable pkTable, Map wantedTables) throws MiddlegenException, SQLException {
        HashMap fkTables = new HashMap();
        int lastKeySeq = -1;
        int bogusFkName = 0;
        ResultSet exportedKeyRs = this.getMetaData().getExportedKeys(this._catalog, this._schema, pkTable.getSqlName());
        while (exportedKeyRs.next()) {
            String fkTableName = exportedKeyRs.getString("FKTABLE_NAME");
            if (wantedTables.containsKey(fkTableName)) {
                String pkColumnName = exportedKeyRs.getString("PKCOLUMN_NAME");
                String fkColumnName = exportedKeyRs.getString("FKCOLUMN_NAME");
                String fkName = exportedKeyRs.getString("FK_NAME");
                short keySeq = exportedKeyRs.getShort("KEY_SEQ");
                if (keySeq == 0) {
                    bogusFkName = (short)(bogusFkName + 1);
                }
                if (fkName == null) {
                    fkName = String.valueOf(bogusFkName);
                }
                this.addCrossref(pkTable, pkColumnName, fkTableName, fkColumnName, fkName, fkTables);
                continue;
            }
            _log.info((Object)("Found a relation between " + pkTable.getSqlName() + " and " + fkTableName + ". Skipping it since " + fkTableName + " isn't among the specified tables."));
        }
        exportedKeyRs.close();
        Iterator crossrefs = pkTable.getTableElement().getCrossrefs().iterator();
        while (crossrefs.hasNext()) {
            CrossrefElement crossref = (CrossrefElement)crossrefs.next();
            if (wantedTables.containsKey(crossref.getFktable())) {
                String pkColumnName;
                String fkName = crossref.getName();
                if (fkName == null) {
                    bogusFkName = (short)(bogusFkName + 1);
                    fkName = String.valueOf(bogusFkName);
                }
                if ((pkColumnName = crossref.getPkcolumn()) == null) {
                    Column pkColumn = pkTable.getPkColumn();
                    if (pkColumn != null) {
                        pkColumnName = pkColumn.getSqlName();
                    } else {
                        throw new MiddlegenException("In custom defined crossref, the table " + pkTable.getSqlName() + " doesn't have a single-column primary key. You must therefore explicitly " + "declare pkcolumn=\"something\" in the crossref element.");
                    }
                }
                this.addCrossref(pkTable, pkColumnName, crossref.getFktable(), crossref.getFkcolumn(), fkName, fkTables);
                continue;
            }
            _log.info((Object)("The declared relation between " + pkTable.getSqlName() + " and " + crossref.getFktable() + " will be skipped since " + crossref.getFktable() + " isn't among the specified tables."));
        }
        Iterator fkTableIterator = fkTables.keySet().iterator();
        while (fkTableIterator.hasNext()) {
            DbTable fkTable = (DbTable)fkTableIterator.next();
            Map fkNameToColumnMapsMap = (Map)fkTables.get(fkTable);
            Iterator fkIterator = fkNameToColumnMapsMap.keySet().iterator();
            while (fkIterator.hasNext()) {
                String fkName = (String)fkIterator.next();
                Collection columnMaps = (Collection)fkNameToColumnMapsMap.get(fkName);
                if (columnMaps.size() < pkTable.getPrimaryKeyColumns().size()) {
                    _log.warn((Object)("WARNING: There is a relation between " + fkTable.getSqlName() + " and " + pkTable.getSqlName() + " that doesn't include all the " + " primary key columns. This may cause errors later on."));
                }
                ColumnMap[] columnMapArray = new ColumnMap[columnMaps.size()];
                columnMapArray = columnMaps.toArray(columnMapArray);
                String relationSuffix = "";
                String fkRoleSuffix = "";
                if (fkNameToColumnMapsMap.size() > 1) {
                    relationSuffix = "-";
                    fkRoleSuffix = String.valueOf(fkRoleSuffix) + "_by_";
                    int i = 0;
                    while (i < columnMapArray.length) {
                        if (i >= 1) {
                            relationSuffix = String.valueOf(relationSuffix) + "-";
                            fkRoleSuffix = String.valueOf(fkRoleSuffix) + "_and_";
                        }
                        relationSuffix = String.valueOf(relationSuffix) + columnMapArray[i].getForeignKey().toLowerCase();
                        fkRoleSuffix = String.valueOf(fkRoleSuffix) + columnMapArray[i].getForeignKey();
                        ++i;
                    }
                }
                fkRoleSuffix = DbNameConverter.getInstance().columnNameToVariableName(fkRoleSuffix);
                _log.debug((Object)("relationSuffix:" + relationSuffix + " (" + fkRoleSuffix + ")"));
                Relation relation = new Relation(pkTable, columnMapArray, fkTable, new ColumnMap[0], null, relationSuffix, fkRoleSuffix);
                this._middlegen.addRelation(relation);
            }
        }
    }

    String getSchemaName() {
        return this._schema;
    }

    private Connection getConnection() throws MiddlegenException {
        if (this._connection == null) {
            this._connection = this._database.getConnection();
        }
        return this._connection;
    }

    private DatabaseMetaData getMetaData() throws MiddlegenException {
        if (this._metaData == null) {
            try {
                this._metaData = this.getConnection().getMetaData();
            }
            catch (SQLException e) {
                throw new MiddlegenException("Couldn't load Metadata");
            }
        }
        return this._metaData;
    }

    private Collection getM2Ms(String table1, String table2) {
        String orderedNameWithoutJoinTable;
        Collection result;
        if (table1.compareTo(table2) > 0) {
            String swap = table1;
            table1 = table2;
            table2 = swap;
        }
        if ((result = (Collection)this._many2many.get(orderedNameWithoutJoinTable = String.valueOf(table1) + "--" + table2)) == null) {
            result = this.EMPTY_COLLECTION;
        }
        return result;
    }

    private boolean isWanted(String table1, String jointable, String table2) {
        boolean result = false;
        Collection candidates = this.getM2Ms(table1, table2);
        Iterator i = candidates.iterator();
        while (i.hasNext()) {
            Many2ManyElement eminem = (Many2ManyElement)i.next();
            if (!eminem.matches(table1, jointable, table2)) continue;
            result = true;
            break;
        }
        return result;
    }

    private String getRelationSuffix(Relation a, Relation b) {
        String result = a.getRelationSuffix().equals("") || b.getRelationSuffix().equals("") ? String.valueOf(a.getRelationSuffix()) + b.getRelationSuffix() : String.valueOf(a.getRelationSuffix()) + "-" + b.getRelationSuffix();
        if (!result.equals("")) {
            result = "-by-" + result;
        }
        return result;
    }

    private String getFkRoleSuffix(Relation a, Relation b) {
        String result = a.getFkRoleSuffix().equals("") || b.getFkRoleSuffix().equals("") ? String.valueOf(a.getFkRoleSuffix()) + b.getFkRoleSuffix() : String.valueOf(a.getFkRoleSuffix()) + "-" + b.getFkRoleSuffix();
        if (!result.equals("")) {
            result = "_by_" + result;
        }
        return result;
    }

    private void addCrossref(DbTable pkTable, String pkColumnName, String fkTableName, String fkColumnName, String fkName, Map fkTables) {
        ArrayList<ColumnMap> columnMaps;
        HashMap<String, ArrayList<ColumnMap>> fkNameToColumnMapsMap;
        DbTable fkTable = this._middlegen.getTable(fkTableName);
        DbColumn pkColumn = (DbColumn)pkTable.getColumn(pkColumnName);
        if (!pkColumn.isPk()) {
            _log.warn((Object)("WARNING: In the relation involving foreign key column " + fkTableName + "(" + fkColumnName + ") and primary key column " + pkTable.getSqlName() + "(" + pkColumnName + ") the primary key column isn't " + "declared as a primary key column in the database. This may cause errors later on."));
        }
        if ((fkNameToColumnMapsMap = (HashMap<String, ArrayList<ColumnMap>>)fkTables.get(fkTable)) == null) {
            fkNameToColumnMapsMap = new HashMap<String, ArrayList<ColumnMap>>();
            fkTables.put(fkTable, fkNameToColumnMapsMap);
        }
        if ((columnMaps = (ArrayList<ColumnMap>)fkNameToColumnMapsMap.get(fkName)) == null) {
            columnMaps = new ArrayList<ColumnMap>();
            fkNameToColumnMapsMap.put(fkName, columnMaps);
        }
        columnMaps.add(new ColumnMap(pkColumnName, fkColumnName));
        DbColumn fkColumn = (DbColumn)fkTable.getColumn(fkColumnName);
        fkColumn.setFk(true);
    }

    private void addColumns(DbTable table) throws MiddlegenException, SQLException {
        _log.debug((Object)("-------setColumns(" + table.getSqlName() + ")"));
        LinkedList<String> primaryKeys = new LinkedList<String>();
        ResultSet primaryKeyRs = this.getMetaData().getPrimaryKeys(this._catalog, this._schema, table.getSqlName());
        while (primaryKeyRs.next()) {
            String columnName = primaryKeyRs.getString("COLUMN_NAME");
            _log.debug((Object)("primary key:" + columnName));
            primaryKeys.add(columnName);
        }
        primaryKeyRs.close();
        LinkedList<String> indices = new LinkedList<String>();
        ResultSet indexRs = null;
        try {
            try {
                indexRs = this.getMetaData().getIndexInfo(this._catalog, this._schema, table.getSqlName(), false, true);
                while (indexRs.next()) {
                    String columnName = indexRs.getString("COLUMN_NAME");
                    if (columnName == null) continue;
                    _log.debug((Object)("index:" + columnName));
                    indices.add(columnName);
                }
            }
            catch (Throwable columnName) {}
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (indexRs != null) {
                indexRs.close();
            }
            throw throwable;
        }
        Object var7_11 = null;
        if (indexRs != null) {
            indexRs.close();
        }
        ResultSet columnRs = this.getMetaData().getColumns(this._catalog, this._schema, table.getSqlName(), null);
        while (columnRs.next()) {
            int sqlType = columnRs.getInt("DATA_TYPE");
            String sqlTypeName = columnRs.getString("TYPE_NAME");
            String columnName = columnRs.getString("COLUMN_NAME");
            String columnDefaultValue = columnRs.getString("COLUMN_DEF");
            boolean isNullable = 1 == columnRs.getInt("NULLABLE");
            int size = columnRs.getInt("COLUMN_SIZE");
            int decimalDigits = columnRs.getInt("DECIMAL_DIGITS");
            boolean isPk = primaryKeys.contains(columnName);
            boolean isIndexed = indices.contains(columnName);
            DbColumn column = new DbColumn(table, sqlType, sqlTypeName, columnName, size, decimalDigits, isPk, isNullable, isIndexed, columnDefaultValue);
            table.addColumn(column);
        }
        columnRs.close();
        if (primaryKeys.size() == 0) {
            _log.warn((Object)("WARNING: The JDBC driver didn't report any primary key columns in " + table.getSqlName()));
        }
    }

    private void tune(DatabaseMetaData metaData) throws SQLException {
        String databaseProductName = metaData.getDatabaseProductName();
        String databaseProductVersion = metaData.getDatabaseProductVersion();
        String driverName = metaData.getDriverName();
        String driverVersion = metaData.getDriverVersion();
        DatabaseInfo databaseInfo = new DatabaseInfo(databaseProductName, databaseProductVersion, driverName, driverVersion);
        this._middlegen.setDatabaseInfo(databaseInfo);
        _log.debug((Object)("databaseProductName=" + databaseProductName));
        _log.debug((Object)("databaseProductVersion=" + databaseProductVersion));
        _log.debug((Object)("driverName=" + driverName));
        _log.debug((Object)("driverVersion=" + driverVersion));
        _log.debug((Object)("schema=" + this._schema));
        _log.debug((Object)("catalog=" + this._catalog));
        if (databaseProductName.toLowerCase().indexOf("oracle") != -1) {
            if (this._catalog != null) {
                this._catalog = this._catalog.toUpperCase();
            }
            if (this._schema != null) {
                this._schema = this._schema.toUpperCase();
            }
            this._types = new String[]{"TABLE", "VIEW"};
        }
        if (databaseProductName.toLowerCase().indexOf("microsoft") != -1) {
            Sql2Java.overridePreferredJavaTypeForSqlType(-2, "java.lang.String");
        }
        databaseProductName.toLowerCase().indexOf("hsql");
    }

    private void addMany2ManyRelations() {
        List relations = this._middlegen.getRelations();
        int one2manyCount = relations.size();
        int i = 0;
        while (i < one2manyCount - 1) {
            Relation firstRelation = (Relation)relations.get(i);
            RelationshipRole firstRole = firstRelation.getLeftRole();
            _log.debug((Object)("first:" + firstRole.getName()));
            int j = i + 1;
            while (j < one2manyCount) {
                Relation secondRelation = (Relation)relations.get(j);
                RelationshipRole secondRole = secondRelation.getLeftRole();
                _log.debug((Object)("second:" + secondRole.getName()));
                if (firstRole.getTarget() == secondRole.getTarget() && firstRole.getTarget() != null && this.isWanted(firstRole.getOrigin().getSqlName(), firstRole.getTarget().getSqlName(), secondRole.getOrigin().getSqlName())) {
                    Collection m2mElements = this.getM2Ms(firstRole.getOrigin().getSqlName(), secondRole.getOrigin().getSqlName());
                    String relationSuffix = null;
                    String fkRoleSuffix = null;
                    if (m2mElements.size() > 1) {
                        relationSuffix = "-via-" + firstRole.getTarget().getSqlName() + this.getRelationSuffix(firstRelation, secondRelation);
                        fkRoleSuffix = "_via_" + firstRole.getTarget().getSqlName() + this.getRelationSuffix(firstRelation, secondRelation);
                        fkRoleSuffix = DbNameConverter.getInstance().columnNameToVariableName(fkRoleSuffix);
                    } else {
                        relationSuffix = this.getRelationSuffix(firstRelation, secondRelation);
                        fkRoleSuffix = this.getRelationSuffix(firstRelation, secondRelation);
                    }
                    Relation m2m = new Relation(firstRole.getOrigin(), firstRole.getColumnMaps(), secondRole.getOrigin(), secondRole.getColumnMaps(), firstRole.getTarget(), relationSuffix, fkRoleSuffix);
                    this._middlegen.addRelation(m2m);
                }
                ++j;
            }
            ++i;
        }
    }

    private void warnUnidentifiedM2ms() {
        Iterator i = this._many2many.values().iterator();
        while (i.hasNext()) {
            Collection c = (Collection)i.next();
            Iterator j = c.iterator();
            while (j.hasNext()) {
                Many2ManyElement eminem = (Many2ManyElement)j.next();
                if (eminem.isMatched()) continue;
                _log.warn((Object)("The many2many relation " + eminem.toString() + " was declared, but not identified."));
            }
        }
    }

    private void addTables(Map wantedTables) throws MiddlegenException, SQLException {
        _log.debug((Object)"-- tables --");
        HashMap<String, String> tableSchemaMap = new HashMap<String, String>();
        Iterator tableElementIterator = wantedTables.values().iterator();
        while (tableElementIterator.hasNext()) {
            NullPointerException ignore2;
            SQLException sQLException2;
            Object var10_10;
            TableElement tableElement = (TableElement)tableElementIterator.next();
            String tableName = tableElement.getName();
            String schemaName = null;
            ResultSet tableRs = null;
            try {
                tableRs = this.getMetaData().getTables(this._catalog, this._schema, tableName, this._types);
                if (!tableRs.next()) {
                    throw new MiddlegenException("The database doesn't have any table named " + tableName + ".  Please make sure the table exists. Also note that some databases are case sensitive.");
                }
                schemaName = tableRs.getString("TABLE_SCHEM");
                String realTableName = tableRs.getString("TABLE_NAME");
                tableElement.setName(realTableName);
                String alreadySchema = (String)tableSchemaMap.get(realTableName);
                if (alreadySchema != null) {
                    throw new MiddlegenException("The table named " + realTableName + " was found both in the schema " + "named " + alreadySchema + " and in the schema named " + schemaName + ". " + "You have to specify schema=\"something\" in the middlegen task.");
                }
                tableSchemaMap.put(realTableName, schemaName);
                if (!Util.equals(this._schema, schemaName)) {
                    _log.warn((Object)("The table named " + realTableName + " was found in the schema " + "named \"" + schemaName + "\". However, Middlegen was not configured " + "to look for tables in a specific schema. You should consider specifying " + "schema=\"" + schemaName + "\" in the middlegen task."));
                }
            }
            catch (Throwable throwable) {
                var10_10 = null;
                try {
                    tableRs.close();
                }
                catch (SQLException sQLException2) {
                }
                catch (NullPointerException ignore2) {
                    // empty catch block
                }
                throw throwable;
            }
            var10_10 = null;
            try {
                tableRs.close();
            }
            catch (SQLException sQLException2) {
            }
            catch (NullPointerException ignore2) {
                // empty catch block
            }
            DbTable table = new DbTable(tableElement, schemaName);
            table.init();
            this._middlegen.addTable(table);
        }
    }
}

