/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import middlegen.Database;
import middlegen.JNDIDatabase;
import middlegen.Many2ManyElement;
import middlegen.Middlegen;
import middlegen.MiddlegenException;
import middlegen.MiddlegenPopulator;
import middlegen.Plugin;
import middlegen.PluginFinder;
import middlegen.Prefs;
import middlegen.StandardDatabase;
import middlegen.TableElement;
import middlegen.swing.JMiddlegenFrame;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.Task;

public class MiddlegenTask
extends Task
implements DynamicConfigurator {
    private final Middlegen _middlegen;
    private boolean _isGui = false;
    private String _providerURL;
    private String _initialContextFactory;
    private String _driver;
    private String _databaseURL;
    private String _username;
    private String _password;
    private String _catalog;
    private String _schema;
    private String _databaseType;
    private boolean _many2many = false;
    private File _prefsDir = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".middlegen");
    private final String _classpath;
    private Map _many2Many = new HashMap();
    private static String _dataSourceJNDIName;
    private static final Object _lock;

    static {
        _lock = new Object();
    }

    public MiddlegenTask() {
        this._middlegen = new Middlegen(this);
        try {
            this._classpath = ((AntClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getClasspath();
            PluginFinder.registerPlugins(this._middlegen, this._classpath);
        }
        catch (ClassCastException e) {
            throw new BuildException("middlegen.jar should not be on the system classpath when starting Ant. It should be on a path passed to the <taskdef> using classpath or classpathref.");
        }
    }

    public void setDatabaseType(String databaseType) {
        this._databaseType = databaseType;
    }

    public void setDatasourceJNDIName(String dataSourceJNDIName) {
        _dataSourceJNDIName = dataSourceJNDIName;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this._initialContextFactory = initialContextFactory;
    }

    public void setProviderURL(String providerURL) {
        this._providerURL = providerURL;
    }

    public void setMany2many(boolean many2many) {
        throw new BuildException("many2many is obsolete. please use a nested many2many element instead.");
    }

    public void setDriver(String driver) {
        this._driver = driver;
    }

    public void setAppname(String s) {
        this._middlegen.setAppname(s);
    }

    public void setXmlprefs(boolean flag) {
        Prefs.setXmlprefs(flag);
    }

    public void setDatabaseURL(String databaseURL) {
        this.log("Database URL:" + databaseURL, 2);
        this._databaseURL = databaseURL;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setSchema(String schema) {
        this._schema = schema;
    }

    public void setCatalog(String catalog) {
        this._catalog = catalog;
    }

    public void setGui(boolean flag) {
        this._isGui = flag;
    }

    public void setDynamicAttribute(String name, String value) {
        throw new BuildException("The <" + this.getTaskName() + "> task doesn't support the \"" + name + "\" attribute.");
    }

    public void setPrefsdir(File prefsDir) {
        this._prefsDir = prefsDir;
    }

    public void addConfiguredTable(TableElement tableElement) {
        this._middlegen.addTableElement(tableElement);
    }

    public void addConfiguredMany2many(Many2ManyElement many2manyElement) {
        many2manyElement.order();
        LinkedList<Many2ManyElement> c = (LinkedList<Many2ManyElement>)this._many2Many.get(many2manyElement.getOrderedNameWithoutJoinTable());
        if (c == null) {
            c = new LinkedList<Many2ManyElement>();
            this._many2Many.put(many2manyElement.getOrderedNameWithoutJoinTable(), c);
        }
        c.add(many2manyElement);
        this._middlegen.addTableElement(many2manyElement.getTablea());
        this._middlegen.addTableElement(many2manyElement.getJointable());
        this._middlegen.addTableElement(many2manyElement.getTableb());
    }

    public void execute() throws BuildException {
        this.validate();
        try {
            Prefs.getInstance().init(this._prefsDir, this._middlegen.getAppname());
        }
        catch (MiddlegenException e) {
            throw new BuildException((Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            this.log("It seems you're running a JDK inferior to 1.4. You should upgrade to JDK 1.4 if you want Middlegen to remeber the settings.", 1);
        }
        try {
            Database database;
            if (this._databaseURL != null) {
                this.log("Getting database connection via standard JDBC", 4);
                database = new StandardDatabase(this._driver, this._databaseURL, this._username, this._password);
            } else {
                this.log("Getting database connection via JNDI and DataSource", 4);
                database = new JNDIDatabase(this._initialContextFactory, this._providerURL, _dataSourceJNDIName);
            }
            MiddlegenPopulator middlegenPopulator = new MiddlegenPopulator(this._middlegen, database, this._schema, this._catalog, this._many2Many);
            if (this._middlegen.getTableElements().isEmpty()) {
                this.log("No <table> elements specified. Reading all tables. This might take a while...", 1);
                middlegenPopulator.addRegularTableElements();
            }
            middlegenPopulator.populate(this._middlegen.getTableElements());
            middlegenPopulator.closeConnection();
            this._middlegen.validate();
            this._middlegen.decorateAll();
            if (this._isGui) {
                String title = "Middlegen - " + this._middlegen.getDatabaseInfo().getDriverName() + " - " + this._databaseURL;
                JMiddlegenFrame frame = new JMiddlegenFrame(this._middlegen, title);
                frame.setVisible(true);
                Object object = MiddlegenTask.getLock();
                synchronized (object) {
                    try {
                        MiddlegenTask.getLock().wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            this._middlegen.writeSource();
            try {
                Prefs.getInstance().save();
            }
            catch (NoClassDefFoundError ignore) {}
        }
        catch (MiddlegenException e) {
            throw new BuildException((Throwable)e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new BuildException(e);
        }
    }

    public Object createDynamicElement(String name) {
        Class pluginClass = this._middlegen.getPluginClass(name);
        if (pluginClass == null) {
            throw new BuildException("Nothing known about plugin <" + name + ">. Make sure the jar file containing the " + "corresponding plugin class is on the classpath specified in the <taskdef> that defined " + this.getTaskName() + "." + " Your classpath is: " + this._classpath);
        }
        Plugin plugin = null;
        try {
            plugin = (Plugin)pluginClass.newInstance();
            plugin.setName(name);
            this._middlegen.addPlugin(plugin);
        }
        catch (Exception e) {
            throw new BuildException("Couldn't instantiate Plugin " + pluginClass.getName(), (Throwable)e);
        }
        return plugin;
    }

    private void warnIfNoJdk14(String message) {
        try {
            Class.forName("java.util.prefs.Preferences");
        }
        catch (Throwable t) {
            this.log(message, 1);
        }
    }

    private void validate() throws BuildException {
        if (this._driver == null && _dataSourceJNDIName == null) {
            throw new BuildException("You must either specify driver or dataSourceJNDIName");
        }
        if (this._middlegen.getAppname() == null) {
            throw new BuildException("You must specify the appname");
        }
        this.presentRequired(_dataSourceJNDIName, "dataSourceJNDIName", this._providerURL, "providerURL");
        this.presentRequired(_dataSourceJNDIName, "dataSourceJNDIName", this._initialContextFactory, "initialContextFactory");
        this.presentRequired(this._databaseURL, "databaseURL", this._driver, "driver");
    }

    private void presentIllegal(String presentValue, String presentName, String illegalValue, String illegalName) throws BuildException {
        if (presentValue != null && illegalValue != null) {
            throw new BuildException("You can't specify both " + presentName + " and " + illegalName);
        }
    }

    private void presentRequired(String presentValue, String presentName, String requiredValue, String requiredName) throws BuildException {
        if (presentValue != null && requiredValue == null) {
            throw new BuildException("When " + presentName + " is specified, you also have to specify " + requiredName);
        }
    }

    public static String getDatasourceJNDIName() {
        return _dataSourceJNDIName;
    }

    public static Object getLock() {
        return _lock;
    }
}

