/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import middlegen.MiddlegenException;
import org.apache.log4j.Category;

public class Prefs {
    private SortedMap _prefsMap;
    private File _prefsFile;
    private static boolean _isXmlprefs = false;
    private static Prefs _instance;
    private static Category _log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.Prefs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public void set(String pathName, String key, String value) {
        this._prefsMap.put(this.toProperty(pathName, key), value);
    }

    public String get(String pathName, String key) {
        return (String)this._prefsMap.get(this.toProperty(pathName, key));
    }

    public String get(String pathName, String key, String defaultValue) {
        String value = this.get(pathName, key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public void save() {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this._prefsFile));
            out.println("# Middlegen Preferences");
            Iterator i = this._prefsMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                out.print(entry.getKey().toString());
                out.print('=');
                out.println(entry.getValue().toString());
            }
            out.flush();
            out.close();
            System.out.println("Updated preferences in " + this._prefsFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.out.println("Couldn't save the preferences to " + this._prefsFile + ":" + e.getMessage());
        }
    }

    public void init(File prefsDir, String prefsId) throws MiddlegenException {
        this._prefsFile = new File(prefsDir, String.valueOf(prefsId) + "-prefs.properties");
        this._prefsMap = new TreeMap();
        try {
            prefsDir.mkdirs();
            if (this._prefsFile.exists()) {
                try {
                    FileInputStream in = new FileInputStream(this._prefsFile);
                    Properties props = new Properties();
                    props.load(in);
                    this._prefsMap.putAll(props);
                }
                catch (IOException e) {
                    System.out.println("Bad preferences format: " + this._prefsFile.getAbsolutePath());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new MiddlegenException("Couldn't initialise preferences system:" + t.getMessage());
        }
    }

    private String toProperty(String pathName, String key) {
        String property = pathName.replace('/', '.');
        if (!property.endsWith(".")) {
            property = String.valueOf(property) + ".";
        }
        property = String.valueOf(property) + key;
        return property;
    }

    public static void setXmlprefs(boolean flag) {
        _isXmlprefs = flag;
    }

    public static Prefs getInstance() {
        if (_instance == null) {
            try {
                _instance = _isXmlprefs ? (Prefs)Class.forName("middlegen.Prefs14").newInstance() : new Prefs();
            }
            catch (Exception ignore) {
                _log.warn((Object)"It looks like the JDK is inferior to 1.4. Can't use xml based prefs. Using properties instead.");
                _instance = new Prefs();
            }
            catch (NoClassDefFoundError ignore) {
                _log.warn((Object)"It looks like this Middlegen was compiled on a JDK inferior to 1.4. Can't use xml based prefs. Using properties instead.");
                _instance = new Prefs();
            }
            try {
                _instance.init(new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".middlegen"), "middlegen");
            }
            catch (Exception ex) {
                System.out.println("Could not open the preferences: " + ex);
            }
        }
        return _instance;
    }
}

