/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.text.MessageFormat;
import middlegen.ColumnMap;
import middlegen.Middlegen;
import middlegen.Plugin;
import middlegen.RelationshipRole;
import middlegen.Table;
import org.apache.log4j.Category;

public class Relation {
    private final String _namePattern;
    private Table _leftTable;
    private Table _rightTable;
    private Table _joinTable;
    private RelationshipRole _leftRole;
    private RelationshipRole _rightRole;
    private String _relationSuffix;
    private String _fkRoleSuffix;
    private static Category _log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.Relation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public Relation(Table leftTable, ColumnMap[] leftColumnMaps, Table rightTable, ColumnMap[] rightColumnMaps, Table joinTable, String relationSuffix, String fkRoleSuffix) {
        if (leftTable == null) {
            throw new IllegalArgumentException("leftTable can't be null!" + Middlegen.BUGREPORT);
        }
        if (rightTable == null) {
            throw new IllegalArgumentException("rightTable can't be null!" + Middlegen.BUGREPORT);
        }
        Class<?> clazz = leftTable.getClass();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("middlegen.DbTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz != clazz2) {
            StringBuffer stringBuffer = new StringBuffer("leftTable must be of class ");
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("middlegen.DbTable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new IllegalArgumentException(stringBuffer.append(clazz3.getName()).append(Middlegen.BUGREPORT).toString());
        }
        Class<?> clazz4 = rightTable.getClass();
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("middlegen.DbTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4 != clazz5) {
            StringBuffer stringBuffer = new StringBuffer("rightTable must be of class ");
            Class<?> clazz6 = class$1;
            if (clazz6 == null) {
                try {
                    clazz6 = class$1 = Class.forName("middlegen.DbTable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new IllegalArgumentException(stringBuffer.append(clazz6.getName()).append(Middlegen.BUGREPORT).toString());
        }
        _log.debug((Object)("new Relation:" + leftTable.getSqlName() + "," + rightTable.getSqlName() + ":" + relationSuffix + ":" + fkRoleSuffix));
        this._leftTable = leftTable;
        this._rightTable = rightTable;
        this._joinTable = joinTable;
        this._relationSuffix = relationSuffix;
        this._fkRoleSuffix = fkRoleSuffix;
        this._namePattern = "{0}-{1}" + relationSuffix;
        this._leftRole = new RelationshipRole(leftTable, rightTable, leftColumnMaps, this, fkRoleSuffix);
        this._rightRole = new RelationshipRole(rightTable, leftTable, rightColumnMaps, this, fkRoleSuffix);
        this._leftRole.setTargetRole(this._rightRole);
        this._rightRole.setTargetRole(this._leftRole);
        this._leftTable.addRelationshipRole(this._leftRole);
        this._rightTable.addRelationshipRole(this._rightRole);
    }

    public boolean isBothTablesGenerate() {
        return this._leftTable.getTableElement().isGenerate() && this._rightTable.getTableElement().isGenerate();
    }

    public boolean isOne2One() {
        return !this._leftRole.isTargetMany() && !this._rightRole.isTargetMany();
    }

    public String getName(Plugin plugin) {
        String leftName = plugin.getRelationName(this._leftTable);
        String rightName = plugin.getRelationName(this._rightTable);
        String name = MessageFormat.format(this._namePattern, leftName, rightName);
        return name;
    }

    public String getName() {
        String name = MessageFormat.format(this._namePattern, this._leftTable.getSqlName(), this._rightTable.getSqlName());
        return name;
    }

    public Table getLeftTable() {
        return this._leftTable;
    }

    public Table getLeft(Plugin plugin) {
        return plugin.decorate(this.getLeftTable());
    }

    public Table getRight(Plugin plugin) {
        return plugin.decorate(this.getRightTable());
    }

    public Table getRightTable() {
        return this._rightTable;
    }

    public Table getJoinTable() {
        return this._joinTable;
    }

    public boolean isBidirectional() {
        return this._leftRole.isEnabled() && this._rightRole.isEnabled();
    }

    public boolean isMany2Many() {
        return this.getJoinTable() != null;
    }

    public RelationshipRole getLeftRole() {
        return this._leftRole;
    }

    public RelationshipRole getRightRole() {
        return this._rightRole;
    }

    String getRelationSuffix() {
        return this._relationSuffix;
    }

    String getFkRoleSuffix() {
        return this._fkRoleSuffix;
    }
}

