/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.concurrent;

import java.util.Random;
import org.logicalcobwebs.concurrent.FJTask;
import org.logicalcobwebs.concurrent.FJTaskRunnerGroup;

public class FJTaskRunner
extends Thread {
    protected final FJTaskRunnerGroup group;
    protected static final int INITIAL_CAPACITY = 4096;
    protected static final int MAX_CAPACITY = 0x40000000;
    protected VolatileTaskRef[] deq = VolatileTaskRef.newArray(4096);
    protected volatile int top = 0;
    protected volatile int base = 0;
    protected final Object barrier = new Object();
    protected boolean active = false;
    protected final Random victimRNG;
    protected int scanPriority = 2;
    protected int runPriority;
    static final boolean COLLECT_STATS = true;
    protected int runs = 0;
    protected int scans = 0;
    protected int steals = 0;

    protected FJTaskRunner(FJTaskRunnerGroup g) {
        this.group = g;
        this.victimRNG = new Random(System.identityHashCode(this));
        this.runPriority = this.getPriority();
        this.setDaemon(true);
    }

    protected final FJTaskRunnerGroup getGroup() {
        return this.group;
    }

    protected int deqSize() {
        return this.deq.length;
    }

    protected void setScanPriority(int pri) {
        this.scanPriority = pri;
    }

    protected void setRunPriority(int pri) {
        this.runPriority = pri;
    }

    protected final void push(FJTask r) {
        int t = this.top;
        if (t < (this.base & this.deq.length - 1) + this.deq.length) {
            this.deq[t & this.deq.length - 1].put(r);
            this.top = t + 1;
        } else {
            this.slowPush(r);
        }
    }

    protected synchronized void slowPush(FJTask r) {
        this.checkOverflow();
        this.push(r);
    }

    protected final synchronized void put(FJTask r) {
        while (true) {
            int b;
            if (this.top < (b = this.base - 1) + this.deq.length) {
                int newBase = b & this.deq.length - 1;
                this.deq[newBase].put(r);
                this.base = newBase;
                if (b != newBase) {
                    int newTop = this.top & this.deq.length - 1;
                    if (newTop < newBase) {
                        newTop += this.deq.length;
                    }
                    this.top = newTop;
                }
                return;
            }
            this.checkOverflow();
        }
    }

    protected final FJTask pop() {
        int t;
        if (this.base + 1 < (t = --this.top)) {
            return this.deq[t & this.deq.length - 1].take();
        }
        return this.confirmPop(t);
    }

    protected final synchronized FJTask confirmPop(int provisionalTop) {
        if (this.base <= provisionalTop) {
            return this.deq[provisionalTop & this.deq.length - 1].take();
        }
        this.base = 0;
        this.top = 0;
        return null;
    }

    protected final synchronized FJTask take() {
        int b;
        if ((b = this.base++) < this.top) {
            return this.confirmTake(b);
        }
        this.base = b;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FJTask confirmTake(int oldBase) {
        Object object = this.barrier;
        synchronized (object) {
            if (oldBase < this.top) {
                return this.deq[oldBase & this.deq.length - 1].get();
            }
            this.base = oldBase;
            return null;
        }
    }

    protected void checkOverflow() {
        int t = this.top;
        int b = this.base;
        if (t - b < this.deq.length - 1) {
            int newTop = this.top & this.deq.length - 1;
            int newBase = b & this.deq.length - 1;
            if (newTop < newBase) {
                newTop += this.deq.length;
            }
            this.top = newTop;
            this.base = newBase;
            int i = newBase;
            while (i != newTop && this.deq[i].ref != null) {
                this.deq[i].ref = null;
                i = i - 1 & this.deq.length - 1;
            }
        } else {
            int newTop = t - b;
            int oldcap = this.deq.length;
            int newcap = oldcap * 2;
            if (newcap >= 0x40000000) {
                throw new Error("FJTask queue maximum capacity exceeded");
            }
            VolatileTaskRef[] newdeq = new VolatileTaskRef[newcap];
            int j = 0;
            while (j < oldcap) {
                newdeq[j] = this.deq[b++ & oldcap - 1];
                ++j;
            }
            int j2 = oldcap;
            while (j2 < newcap) {
                newdeq[j2] = new VolatileTaskRef();
                ++j2;
            }
            this.deq = newdeq;
            this.base = 0;
            this.top = newTop;
        }
    }

    protected void scan(FJTask waitingFor) {
        FJTask task = null;
        boolean lowered = false;
        FJTaskRunner[] ts = this.group.getArray();
        int idx = this.victimRNG.nextInt(ts.length);
        int i = 0;
        while (i < ts.length) {
            FJTaskRunner t = ts[idx];
            if (++idx >= ts.length) {
                idx = 0;
            }
            if (t != null && t != this) {
                if (waitingFor != null && waitingFor.isDone()) break;
                ++this.scans;
                task = t.take();
                if (task != null) {
                    ++this.steals;
                    break;
                }
                if (this.isInterrupted()) break;
                if (!lowered) {
                    lowered = true;
                    this.setPriority(this.scanPriority);
                } else {
                    Thread.yield();
                }
            }
            ++i;
        }
        if (task == null) {
            ++this.scans;
            task = this.group.pollEntryQueue();
            if (task != null) {
                ++this.steals;
            }
        }
        if (lowered) {
            this.setPriority(this.runPriority);
        }
        if (task != null && !task.isDone()) {
            ++this.runs;
            task.run();
            task.setDone();
        }
    }

    protected void scanWhileIdling() {
        FJTask task = null;
        boolean lowered = false;
        long iters = 0L;
        FJTaskRunner[] ts = this.group.getArray();
        int idx = this.victimRNG.nextInt(ts.length);
        do {
            int i = 0;
            while (i < ts.length) {
                FJTaskRunner t = ts[idx];
                if (++idx >= ts.length) {
                    idx = 0;
                }
                if (t != null && t != this) {
                    ++this.scans;
                    task = t.take();
                    if (task != null) {
                        ++this.steals;
                        if (lowered) {
                            this.setPriority(this.runPriority);
                        }
                        this.group.setActive(this);
                        break;
                    }
                }
                ++i;
            }
            if (task != null) continue;
            if (this.isInterrupted()) {
                return;
            }
            ++this.scans;
            task = this.group.pollEntryQueue();
            if (task != null) {
                ++this.steals;
                if (lowered) {
                    this.setPriority(this.runPriority);
                }
                this.group.setActive(this);
                continue;
            }
            if (++iters >= 15L) {
                this.group.checkActive(this, iters);
                if (!this.isInterrupted()) continue;
                return;
            }
            if (!lowered) {
                lowered = true;
                this.setPriority(this.scanPriority);
                continue;
            }
            Thread.yield();
        } while (task == null);
        if (!task.isDone()) {
            ++this.runs;
            task.run();
            task.setDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!Thread.interrupted()) {
                FJTask task = this.pop();
                if (task != null) {
                    if (task.isDone()) continue;
                    ++this.runs;
                    task.run();
                    task.setDone();
                    continue;
                }
                this.scanWhileIdling();
            }
            Object var3_2 = null;
            this.group.setInactive(this);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.group.setInactive(this);
            throw throwable;
        }
    }

    protected final void taskYield() {
        FJTask task = this.pop();
        if (task != null) {
            if (!task.isDone()) {
                ++this.runs;
                task.run();
                task.setDone();
            }
        } else {
            this.scan(null);
        }
    }

    protected final void taskJoin(FJTask w) {
        while (!w.isDone()) {
            FJTask task = this.pop();
            if (task != null) {
                if (task.isDone()) continue;
                ++this.runs;
                task.run();
                task.setDone();
                if (task != w) continue;
                return;
            }
            this.scan(w);
        }
    }

    protected final void coInvoke(FJTask w, FJTask v) {
        int t = this.top;
        if (t < (this.base & this.deq.length - 1) + this.deq.length) {
            this.deq[t & this.deq.length - 1].put(w);
            this.top = t + 1;
            if (!v.isDone()) {
                ++this.runs;
                v.run();
                v.setDone();
            }
            while (!w.isDone()) {
                FJTask task = this.pop();
                if (task != null) {
                    if (task.isDone()) continue;
                    ++this.runs;
                    task.run();
                    task.setDone();
                    if (task != w) continue;
                    return;
                }
                this.scan(w);
            }
        } else {
            this.slowCoInvoke(w, v);
        }
    }

    protected void slowCoInvoke(FJTask w, FJTask v) {
        this.push(w);
        FJTask.invoke(v);
        this.taskJoin(w);
    }

    protected final void coInvoke(FJTask[] tasks) {
        int nforks = tasks.length - 1;
        int t = this.top;
        if (nforks >= 0 && t + nforks < (this.base & this.deq.length - 1) + this.deq.length) {
            int i = 0;
            while (i < nforks) {
                this.deq[t++ & this.deq.length - 1].put(tasks[i]);
                this.top = t;
                ++i;
            }
            FJTask v = tasks[nforks];
            if (!v.isDone()) {
                ++this.runs;
                v.run();
                v.setDone();
            }
            int i2 = 0;
            while (i2 < nforks) {
                FJTask w = tasks[i2];
                while (!w.isDone()) {
                    FJTask task = this.pop();
                    if (task != null) {
                        if (task.isDone()) continue;
                        ++this.runs;
                        task.run();
                        task.setDone();
                        continue;
                    }
                    this.scan(w);
                }
                ++i2;
            }
        } else {
            this.slowCoInvoke(tasks);
        }
    }

    protected void slowCoInvoke(FJTask[] tasks) {
        int i = 0;
        while (i < tasks.length) {
            this.push(tasks[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < tasks.length) {
            this.taskJoin(tasks[i2]);
            ++i2;
        }
    }

    protected static final class VolatileTaskRef {
        protected volatile FJTask ref;

        protected VolatileTaskRef() {
        }

        protected final void put(FJTask r) {
            this.ref = r;
        }

        protected final FJTask get() {
            return this.ref;
        }

        protected final FJTask take() {
            FJTask r = this.ref;
            this.ref = null;
            return r;
        }

        protected static VolatileTaskRef[] newArray(int cap) {
            VolatileTaskRef[] a = new VolatileTaskRef[cap];
            int k = 0;
            while (k < cap) {
                a[k] = new VolatileTaskRef();
                ++k;
            }
            return a;
        }
    }
}

