/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.tool.hbm2java.AbstractRenderer;
import net.sf.hibernate.tool.hbm2java.ClassMapping;
import net.sf.hibernate.tool.hbm2java.ClassName;
import net.sf.hibernate.tool.hbm2java.Field;
import net.sf.hibernate.tool.hbm2java.MetaAttributeHelper;

public class BasicRenderer
extends AbstractRenderer {
    protected static final int ORDINARY = 0;
    protected static final int BOUND = 1;
    protected static final int CONSTRAINT = 3;
    static Map primitiveToObject = new HashMap();

    public BasicRenderer() {
        primitiveToObject.put("char", "Character");
        primitiveToObject.put("byte", "Byte");
        primitiveToObject.put("short", "Short");
        primitiveToObject.put("int", "Integer");
        primitiveToObject.put("long", "Long");
        primitiveToObject.put("boolean", "Boolean");
        primitiveToObject.put("float", "Float");
        primitiveToObject.put("double", "Double");
    }

    public void render(String savedToPackage, String savedToClass, ClassMapping classMapping, Map class2classmap, PrintWriter mainwriter) throws Exception {
        if (savedToPackage != null && !savedToPackage.trim().equals("")) {
            mainwriter.println("package " + savedToPackage + ";");
        } else if (classMapping.getGeneratedPackageName() != null) {
            mainwriter.println("package " + classMapping.getGeneratedPackageName() + ";");
        } else {
            mainwriter.println("// default package");
        }
        mainwriter.println();
        StringWriter strWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(strWriter);
        if (classMapping.getMeta("class-description") == null) {
            writer.println("/** @author Hibernate CodeGenerator */");
        } else {
            writer.println("/** \n" + this.toJavaDoc(classMapping.getMetaAsString("class-description"), 0) + "*/");
        }
        String classScope = "public";
        if (classMapping.getMeta("scope-class") != null) {
            classScope = classMapping.getMetaAsString("scope-class").trim();
        }
        if (classMapping.shouldBeAbstract() && classScope.indexOf("abstract") == -1) {
            writer.print("abstract " + classScope + " class " + savedToClass);
        } else {
            writer.print(classScope + " class " + savedToClass);
        }
        if (classMapping.getSuperClass() != null) {
            writer.print(" extends " + classMapping.getSuperClass());
        } else if (classMapping.getMeta("extends") != null) {
            writer.print(" extends " + classMapping.getMetaAsString("extends"));
        }
        writer.print(" implements Serializable");
        if (classMapping.getProxy() != null && !classMapping.getProxy().equals(classMapping.getCanonicalName())) {
            writer.print(", ");
            writer.print(classMapping.getProxy());
        }
        if (classMapping.getMeta("implements") != null) {
            writer.print(MetaAttributeHelper.getMetaAsString(classMapping.getMeta("implements"), ", "));
        }
        writer.println(" {");
        writer.println();
        StringWriter strPropWriter = new StringWriter();
        PrintWriter propWriter = new PrintWriter(strPropWriter);
        this.doFields(classMapping, propWriter);
        this.doConstructors(savedToClass, classMapping, class2classmap, propWriter);
        String vetoSupport = this.makeSupportField("vetos", classMapping.getAllFields());
        String changeSupport = this.makeSupportField("changes", classMapping.getAllFields());
        int fieldTypes = this.doFieldAccessors(classMapping, class2classmap, propWriter, vetoSupport, changeSupport);
        this.doSupportMethods(fieldTypes, vetoSupport, changeSupport, propWriter);
        this.doToString(classMapping, propWriter);
        this.doEqualsAndHashCode(savedToClass, classMapping, propWriter);
        propWriter.println("}");
        this.doSupports(fieldTypes, classMapping, vetoSupport, changeSupport, writer);
        writer.print(strPropWriter.toString());
        this.doImports(classMapping, mainwriter);
        mainwriter.print(strWriter.toString());
    }

    private void doSupportMethods(int fieldTypes, String vetoSupport, String changeSupport, PrintWriter writer) {
        if ((fieldTypes & 3) == 3) {
            writer.println("    public void addVetoableChangeListener( VetoableChangeListener l ) {");
            writer.println("        " + vetoSupport + ".addVetoableChangeListener(l);");
            writer.println("    }");
            writer.println("    public void removeVetoableChangeListener( VetoableChangeListener l ) {");
            writer.println("        " + vetoSupport + ".removeVetoableChangeListener(l);");
            writer.println("    }");
            writer.println();
        }
        if ((fieldTypes & 1) == 1) {
            writer.println("    public void addPropertyChangeListener( PropertyChangeListener l ) {");
            writer.println("        " + changeSupport + ".addPropertyChangeListener(l);");
            writer.println("    }");
            writer.println("    public void removePropertyChangeListener( PropertyChangeListener l ) {");
            writer.println("        " + changeSupport + ".removePropertyChangeListener(l);");
            writer.println("    }");
            writer.println();
        }
    }

    private void doSupports(int fieldTypes, ClassMapping classMapping, String vetoSupport, String changeSupport, PrintWriter writer) {
        if ((fieldTypes & 3) == 3) {
            writer.println("    private VetoableChangeSupport " + vetoSupport + " = new VetoableChangeSupport(this);");
            classMapping.getImports().add("java.beans.VetoableChangeSupport");
            classMapping.getImports().add("java.beans.PropertyVetoException");
            classMapping.getImports().add("java.beans.VetoableChangeListener");
        }
        if ((fieldTypes & 1) == 1) {
            writer.println("    private PropertyChangeSupport " + changeSupport + " = new PropertyChangeSupport(this);");
            writer.println();
            classMapping.getImports().add("java.beans.PropertyChangeSupport");
            classMapping.getImports().add("java.beans.PropertyChangeListener");
        }
    }

    public void doConstructors(String savedToClass, ClassMapping classMapping, Map class2classmap, PrintWriter writer) {
        Field field;
        Iterator fields;
        List allFieldsForFullConstructor = classMapping.getAllFieldsForFullConstructor();
        writer.println("    /** full constructor */");
        String fullCons = "    public " + savedToClass + "(";
        Iterator fields2 = allFieldsForFullConstructor.iterator();
        while (fields2.hasNext()) {
            Field field2 = (Field)fields2.next();
            fullCons = fullCons + this.shortenType(BasicRenderer.getTrueTypeName(field2, class2classmap), classMapping.getImports()) + " " + field2.getName();
            if (!fields2.hasNext()) continue;
            fullCons = fullCons + ", ";
        }
        writer.println(fullCons + ") {");
        List supersConstructorFields = classMapping.getFieldsForSupersFullConstructor();
        if (!supersConstructorFields.isEmpty()) {
            writer.print("        super(");
            fields = supersConstructorFields.iterator();
            while (fields.hasNext()) {
                field = (Field)fields.next();
                writer.print(field.getName());
                if (!fields.hasNext()) continue;
                writer.print(", ");
            }
            writer.println(");");
        }
        fields = classMapping.getLocalFieldsForFullConstructor().iterator();
        while (fields.hasNext()) {
            field = (Field)fields.next();
            if (!field.isGeneratedAsProperty()) continue;
            writer.println("        this." + field.getName() + " = " + field.getName() + ";");
        }
        writer.println("    }");
        writer.println();
        if (allFieldsForFullConstructor.size() > 0) {
            writer.println("    /** default constructor */");
            writer.println("    public " + savedToClass + "() {");
            writer.println("    }");
            writer.println();
        }
        if (allFieldsForFullConstructor.size() > 0 && classMapping.needsMinimalConstructor()) {
            Field field3;
            Iterator fields3;
            List allFieldsForMinimalConstructor = classMapping.getAllFieldsForMinimalConstructor();
            writer.println("    /** minimal constructor */");
            String minCons = "    public " + savedToClass + "(";
            Iterator fields4 = allFieldsForMinimalConstructor.iterator();
            while (fields4.hasNext()) {
                Field field4 = (Field)fields4.next();
                minCons = minCons + this.shortenType(BasicRenderer.getTrueTypeName(field4, class2classmap), classMapping.getImports()) + " " + field4.getName();
                if (!fields4.hasNext()) continue;
                minCons = minCons + ", ";
            }
            writer.println(minCons + ") {");
            List supersMinConstructorFields = classMapping.getFieldsForSupersMinimalConstructor();
            if (!supersMinConstructorFields.isEmpty()) {
                writer.print("      super(");
                fields3 = supersMinConstructorFields.iterator();
                while (fields3.hasNext()) {
                    field3 = (Field)fields3.next();
                    writer.print(field3.getName());
                    if (!fields3.hasNext()) continue;
                    writer.print(", ");
                }
                writer.println(");");
            }
            fields3 = classMapping.getLocalFieldsForMinimalConstructor().iterator();
            while (fields3.hasNext()) {
                field3 = (Field)fields3.next();
                if (!field3.isGeneratedAsProperty()) continue;
                writer.println("        this." + field3.getName() + " = " + field3.getName() + ";");
            }
            writer.println("    }");
            writer.println();
        }
    }

    public void doFields(ClassMapping classMapping, PrintWriter writer) {
        Iterator fields = classMapping.getFields().iterator();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            if (field.isGeneratedAsProperty()) {
                String fieldScope = this.getFieldScope(field, "scope-field", "private");
                writer.println("    /** " + (field.isNullable() && !field.isIdentifier() ? "nullable " : "") + (field.isIdentifier() ? "identifier" : "persistent") + " field */");
                writer.println("    " + fieldScope + " " + this.shortenType(field.getType(), classMapping.getImports()) + ' ' + field.getName() + ';');
            }
            writer.println();
        }
    }

    public void doEqualsAndHashCode(String savedToClass, ClassMapping classMapping, PrintWriter writer) {
        if (classMapping.mustImplementEquals()) {
            Field field;
            writer.println("    public boolean equals(Object other) {");
            writer.println("        if ( !(other instanceof " + savedToClass + ") ) return false;");
            writer.println("        " + savedToClass + " castOther = (" + savedToClass + ") other;");
            writer.println("        return new EqualsBuilder()");
            Iterator fields = classMapping.getFields().iterator();
            while (fields.hasNext()) {
                field = (Field)fields.next();
                if (!field.isIdentifier()) continue;
                writer.println("            .append(this." + field.getGetterSignature() + ", castOther." + field.getGetterSignature() + ")");
            }
            writer.println("            .isEquals();");
            writer.println("    }");
            writer.println();
            writer.println("    public int hashCode() {");
            writer.println("        return new HashCodeBuilder()");
            fields = classMapping.getFields().iterator();
            while (fields.hasNext()) {
                field = (Field)fields.next();
                if (!field.isIdentifier()) continue;
                writer.println("            .append(" + field.getGetterSignature() + ")");
            }
            writer.println("            .toHashCode();");
            writer.println("    }");
            writer.println();
        }
    }

    public void doToString(ClassMapping classMapping, PrintWriter writer) {
        writer.println("    public String toString() {");
        writer.println("        return new ToStringBuilder(this)");
        Iterator fields = classMapping.getAllFields().iterator();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            if (field.isIdentifier() && field.getMeta("use-in-tostring") == null) {
                writer.println("            .append(\"" + field.getName() + "\", " + field.getGetterSignature() + ")");
                continue;
            }
            if (!field.getMetaAsBool("use-in-tostring")) continue;
            writer.println("            .append(\"" + field.getName() + "\", " + field.getGetterSignature() + ")");
        }
        writer.println("            .toString();");
        writer.println("    }");
        writer.println();
    }

    public int doFieldAccessors(ClassMapping classMapping, Map class2classmap, PrintWriter writer, String vetoSupport, String changeSupport) {
        int fieldTypes = 0;
        Iterator fields = classMapping.getFields().iterator();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            if (!field.isGeneratedAsProperty()) continue;
            String getAccessScope = this.getFieldScope(field, "scope-get", "public");
            if (field.getMeta("field-description") != null) {
                writer.println("    /** \n" + this.toJavaDoc(field.getMetaAsString("field-description"), 4) + "     */");
            }
            writer.println("    " + getAccessScope + " " + BasicRenderer.getTrueTypeName(field, class2classmap) + " " + field.getGetterSignature() + " {");
            writer.println("        return this." + field.getName() + ";");
            writer.println("    }");
            writer.println();
            int fieldType = 0;
            if (field.getMeta("beans-property-type") != null) {
                String beansPropertyType = field.getMetaAsString("beans-property-type").trim().toLowerCase();
                if (beansPropertyType.equals("constraint")) {
                    fieldTypes |= 3;
                    fieldType = 3;
                } else if (beansPropertyType.equals("bound")) {
                    fieldTypes |= 1;
                    fieldType = 1;
                }
            }
            String setAccessScope = this.getFieldScope(field, "scope-set", "public");
            writer.print("    " + setAccessScope + " void set" + field.getAsSuffix() + "(" + BasicRenderer.getTrueTypeName(field, class2classmap) + " " + field.getName() + ")");
            writer.println((fieldType & 3) == 3 ? " throws PropertyVetoException {" : " {");
            if ((fieldType & 3) == 3) {
                writer.println("        " + vetoSupport + ".fireVetoableChange(\"" + field.getName() + "\",");
                writer.println("                " + this.getFieldAsObject(true, field) + ",");
                writer.println("                " + this.getFieldAsObject(false, field) + ");");
            }
            writer.println("        this." + field.getName() + " = " + field.getName() + ";");
            if ((fieldType & 1) == 1) {
                writer.println("        " + changeSupport + ".firePropertyChange(\"" + field.getName() + "\",");
                writer.println("                " + this.getFieldAsObject(true, field) + ",");
                writer.println("                " + this.getFieldAsObject(false, field) + ");");
            }
            writer.println("    }");
            writer.println();
        }
        return fieldTypes;
    }

    public void doImports(ClassMapping classMapping, PrintWriter writer) {
        classMapping.getImports().add("java.io.Serializable");
        classMapping.getImports().add("org.apache.commons.lang.builder.ToStringBuilder");
        if (classMapping.mustImplementEquals()) {
            classMapping.getImports().add("org.apache.commons.lang.builder.EqualsBuilder");
            classMapping.getImports().add("org.apache.commons.lang.builder.HashCodeBuilder");
        }
        Iterator imports = classMapping.getImports().iterator();
        while (imports.hasNext()) {
            writer.println("import " + imports.next() + ";");
        }
        writer.println();
    }

    protected String makeSupportField(String fieldName, List fieldList) {
        String suffix = "";
        boolean needSuffix = false;
        Iterator fields = fieldList.iterator();
        while (fields.hasNext()) {
            String name = ((Field)fields.next()).getName();
            if (name.equals(fieldName)) {
                needSuffix = true;
            }
            suffix = suffix + name;
        }
        return needSuffix ? fieldName + "_" + suffix : fieldName;
    }

    private String getFieldAsObject(boolean prependThis, Field field) {
        ClassName type = field.getClassType();
        if (type != null && type.isPrimitive() && !type.isArray()) {
            String typeName = (String)primitiveToObject.get(type.getName());
            typeName = "new " + typeName + "( ";
            typeName = typeName + (prependThis ? "this." : "");
            return typeName + field.getName() + " )";
        }
        return field.getName();
    }
}

