/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.util.ArrayList;

public class MethodSignatureBuilder {
    private String name = "";
    private String returnType = "";
    private String accessModifier = "";
    private ArrayList paramList = new ArrayList();
    private ArrayList throwsList = new ArrayList();

    public MethodSignatureBuilder(String methodName, String returnType, String accessModifier) {
        this.name = methodName;
        this.returnType = returnType;
        this.accessModifier = accessModifier;
    }

    public String buildMethodSignature() {
        int i;
        StringBuffer sb = new StringBuffer(this.accessModifier + " " + this.returnType + " " + this.name + "(");
        for (i = 0; i < this.paramList.size(); ++i) {
            String param = (String)this.paramList.get(i);
            sb.append(param);
            if (i >= this.paramList.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(") ");
        for (i = 0; i < this.throwsList.size(); ++i) {
            if (i == 0) {
                sb.append(" throws ");
            }
            String thr = (String)this.throwsList.get(i);
            sb.append(thr);
            if (i >= this.throwsList.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(" {");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getAccessModifier() {
        return this.accessModifier;
    }

    public void setAccessModifier(String accessModifier) {
        this.accessModifier = accessModifier;
    }

    public ArrayList getParamList() {
        return this.paramList;
    }

    public void setParamList(ArrayList paramList) {
        this.paramList = paramList;
    }

    public void addParam(String param) {
        this.paramList.add(param);
    }

    public void addThrows(String throwsString) {
        this.throwsList.add(throwsString);
    }
}

