/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

class FactoryCache {
    private final Map cache;

    public FactoryCache() {
        this(new WeakHashMap());
    }

    public FactoryCache(Map cache) {
        this.cache = cache;
    }

    public Object get(ClassLoader loader, Object key) {
        return this.getFactoryMap(loader).get(key);
    }

    public void put(ClassLoader loader, Object key, Object factory) {
        this.getFactoryMap(loader).put(key, factory);
    }

    private Map getFactoryMap(ClassLoader loader) {
        HashMap factories = (HashMap)this.cache.get(loader);
        if (factories == null) {
            factories = new HashMap();
            this.cache.put(loader, factories);
        }
        return factories;
    }
}

