/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.cglib.CodeGenerationException;
import net.sf.cglib.CodeGenerator;
import net.sf.cglib.Constants;
import net.sf.cglib.Delegator;
import net.sf.cglib.MethodWrapper;
import net.sf.cglib.ReflectUtils;

class DelegatorGenerator
extends CodeGenerator {
    private static final String FIELD_NAME = "CGLIB$DELEGATES";
    private static final Method NEW_INSTANCE = ReflectUtils.findMethod("Delegator$Factory.cglib_newInstance(Object[])");
    private Class[] classes;
    private boolean multicast;
    private boolean bean;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public DelegatorGenerator(Class cls, boolean multicast, String className, Class[] classes, ClassLoader loader, boolean bean) {
        super(className, cls, loader);
        this.multicast = multicast;
        this.classes = classes;
        this.bean = bean;
    }

    protected void generate() throws NoSuchMethodException {
        this.declare_interface(Delegator.Factory.TYPE);
        HashMap methodMap = new HashMap();
        int i = 0;
        while (i < this.classes.length) {
            Method[] methods;
            Class clazz = this.classes[i];
            if (this.bean) {
                methods = DelegatorGenerator.getBeanMethods(clazz);
            } else {
                if (!clazz.isInterface()) {
                    throw new IllegalArgumentException(clazz + " is not an interface");
                }
                this.declare_interface(clazz);
                methods = clazz.getMethods();
            }
            int j = 0;
            while (j < methods.length) {
                Method method = methods[j];
                Object key = MethodWrapper.create(method);
                LinkedList<MethodInfo> list = (LinkedList<MethodInfo>)methodMap.get(key);
                if (list == null) {
                    list = new LinkedList<MethodInfo>();
                    methodMap.put(key, list);
                }
                if (this.multicast || list.size() == 0) {
                    list.add(new MethodInfo(method, i));
                }
                ++j;
            }
            ++i;
        }
        this.generateConstructor();
        this.generateFactoryMethod(NEW_INSTANCE);
        Iterator it = methodMap.values().iterator();
        while (it.hasNext()) {
            this.generateProxy((List)it.next());
        }
    }

    private static Method[] getBeanMethods(Class clazz) {
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz, class$java$lang$Object == null ? (class$java$lang$Object = DelegatorGenerator.class$("java.lang.Object")) : class$java$lang$Object);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            ArrayList<Method> methods = new ArrayList<Method>(descriptors.length * 2);
            int i = 0;
            while (i < descriptors.length) {
                Method write;
                PropertyDescriptor pd = descriptors[i];
                Method read = pd.getReadMethod();
                if (read != null) {
                    methods.add(read);
                }
                if ((write = pd.getWriteMethod()) != null) {
                    methods.add(write);
                }
                ++i;
            }
            return methods.toArray(new Method[methods.size()]);
        }
        catch (IntrospectionException e) {
            throw new CodeGenerationException(e);
        }
    }

    private void generateConstructor() {
        this.declare_field(2, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = DelegatorGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, FIELD_NAME);
        this.begin_constructor(Constants.TYPES_OBJECT_ARRAY);
        this.load_this();
        this.super_invoke_constructor();
        this.load_this();
        this.load_arg(0);
        this.putfield(FIELD_NAME);
        this.return_value();
        this.end_method();
    }

    private void generateProxy(List methods) {
        this.begin_method(((MethodInfo)methods.get(0)).getMethod());
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            MethodInfo info = (MethodInfo)it.next();
            this.load_this();
            this.getfield(FIELD_NAME);
            this.aaload(info.getArrayRef());
            this.checkcast(info.getMethod().getDeclaringClass());
            this.load_args();
            this.invoke(info.getMethod());
        }
        this.return_value();
        this.end_method();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MethodInfo {
        private Method method;
        private int arrayref;

        public MethodInfo(Method method, int arrayref) {
            this.method = method;
            this.arrayref = arrayref;
        }

        public Method getMethod() {
            return this.method;
        }

        public int getArrayRef() {
            return this.arrayref;
        }
    }
}

