/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.tool.hbm2java.ClassMapping;
import net.sf.hibernate.tool.hbm2java.ClassName;
import net.sf.hibernate.tool.hbm2java.Field;
import net.sf.hibernate.tool.hbm2java.FinderRenderer;

public class QueryBuilder {
    public static final String CRITERIA_EQUALS = "=";
    public static final String CRITERIA_GREATER_THAN = ">";
    public static final String CRITERIA_LESS_THAN = "<";
    public static final String CRITERIA_LIKE = "LIKE";
    private ArrayList objects = new ArrayList();
    private ArrayList joinConditions = new ArrayList();
    private ArrayList criteria = new ArrayList();
    private ArrayList params = new ArrayList();
    private ArrayList criteriaParamTypes = new ArrayList();
    private ClassMapping localClass = null;
    private ClassMapping foreignClass = null;
    private String joinFieldName = "";

    public void setLocalClass(ClassMapping localClass) {
        this.localClass = localClass;
    }

    public void setForeignClass(ClassName foreignClass, Map classMappings, String joinFieldName) {
        ClassMapping classMapToAdd;
        this.foreignClass = classMapToAdd = (ClassMapping)classMappings.get(foreignClass.getFullyQualifiedName());
        this.joinFieldName = joinFieldName;
    }

    public void addCritera(ClassMapping criteriaClass, Field field, String condition) {
        String newCritera = criteriaClass.getName().toLowerCase() + "." + field.getName() + condition + "?";
        this.params.add(FinderRenderer.getFieldAsObject(false, field));
        this.criteria.add(newCritera);
        this.criteriaParamTypes.add(FinderRenderer.getFieldAsHibernateType(false, field));
    }

    public String getQuery() {
        StringBuffer sb = new StringBuffer("select ");
        sb.append(this.foreignClass.getName().toLowerCase() + " from ");
        sb.append(this.foreignClass.getName().toLowerCase() + " in class ");
        sb.append(this.foreignClass.getName() + ", ");
        sb.append(this.localClass.getName().toLowerCase() + " in ");
        sb.append(this.foreignClass.getName().toLowerCase() + ".");
        sb.append(this.joinFieldName + ".elements where ");
        sb.append(this.localClass.getName().toLowerCase() + "=? and ");
        if (this.criteria.size() > 0) {
            for (int i = 0; i < this.criteria.size(); ++i) {
                String thisCriteria = (String)this.criteria.get(i);
                sb.append(" " + thisCriteria + " ");
                if (i >= this.criteria.size() - 1) continue;
                sb.append(" and ");
            }
        }
        return sb.toString();
    }

    public List getParamTypes() {
        return this.criteriaParamTypes;
    }

    public String getParamTypesAsString() {
        String types = "new Type[] {";
        types = types + "Hibernate.association(" + this.localClass.getName() + ".class), ";
        for (int i = 0; i < this.criteriaParamTypes.size(); ++i) {
            String s = (String)this.criteriaParamTypes.get(i);
            types = types + s;
            if (i == this.criteriaParamTypes.size() - 1) continue;
            types = types + ",";
        }
        return types + "}";
    }

    public List getParams() {
        return this.params;
    }

    public String getParamsAsString() {
        String types = "new Object[] {";
        types = types + this.localClass.getName().toLowerCase() + ", ";
        for (int i = 0; i < this.params.size(); ++i) {
            String s = (String)this.params.get(i);
            types = types + s;
            if (i == this.params.size() - 1) continue;
            types = types + ",";
        }
        return types + "}";
    }
}

