/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.class2hbm;

import net.sf.hibernate.tool.class2hbm.MapGenerator;
import net.sf.hibernate.tool.class2hbm.ReflectedProperty;

class ReflectedArrayProperty
extends ReflectedProperty {
    protected ReflectedProperty element = null;

    ReflectedArrayProperty(String name, Class type, MapGenerator map) {
        super(name, type, map, "array");
        Class<?> elmcls = type.getComponentType();
        if (elmcls == null) {
            this.emitPCommentStr(1, "NOT an array!?", name, type.getName());
            return;
        }
        String roleName = map.tableNameFor(elmcls.getName());
        this.element = map.makeProperty(roleName, elmcls);
    }

    protected void getXMLinArray(int level, StringBuffer buf) {
        this.buf = buf;
        this.emitPCommentStr(level, "BUG!?: array of array ", this.name, this.element.name);
    }

    protected void getXMLinComposite(int level, StringBuffer buf) {
        this.buf = buf;
        this.emitCollectionInCompositeStr(level);
    }

    protected void getXML(int level, StringBuffer buf) {
        this.buf = buf;
        if (this.comment != null) {
            this.emitPCommentStr(level, this.comment, this.name, this.type.getName());
        }
        if (this.element == null) {
            this.emitPCommentStr(level, "BUG array of unknown kind!", this.name, this.element.name);
        } else {
            boolean p = this.element.type.isPrimitive();
            this.emitCollectionStrL(level, p ? "primitive-array" : "array", this.name, false);
            this.emitCollectionStrK(level + 1, "uid");
            this.emitCollectionStrI(level + 1, "idx");
            this.element.getXMLinArray(level + 1, buf);
            this.emitCollectionStrR(level, p ? "primitive-array" : "array");
        }
    }
}

