/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.hibernate.tool.hbm2java.ClassMapping;
import net.sf.hibernate.tool.hbm2java.Generator;
import net.sf.hibernate.tool.hbm2java.MetaAttributeHelper;
import net.sf.hibernate.util.DTDEntityResolver;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class CodeGenerator {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$tool$hbm2java$CodeGenerator == null ? (class$net$sf$hibernate$tool$hbm2java$CodeGenerator = CodeGenerator.class$("net.sf.hibernate.tool.hbm2java.CodeGenerator")) : class$net$sf$hibernate$tool$hbm2java$CodeGenerator));
    static /* synthetic */ Class class$net$sf$hibernate$tool$hbm2java$CodeGenerator;

    public static void main(String[] args) {
        try {
            ArrayList<String> mappingFiles = new ArrayList<String>();
            SAXBuilder builder = new SAXBuilder();
            builder.setEntityResolver((EntityResolver)new DTDEntityResolver());
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException error) {
                    log.error((Object)("Error parsing XML: " + error.getSystemId() + '(' + error.getLineNumber() + ')'), (Throwable)error);
                }

                public void fatalError(SAXParseException error) {
                    this.error(error);
                }

                public void warning(SAXParseException error) {
                    log.warn((Object)("Warning parsing XML: " + error.getSystemId() + '(' + error.getLineNumber() + ')'));
                }
            });
            String outputDir = null;
            ArrayList<Generator> generators = new ArrayList<Generator>();
            MultiHashMap globalMetas = new MultiHashMap();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].startsWith("--config=")) {
                        Document document = builder.build(new File(args[i].substring(9)));
                        globalMetas = MetaAttributeHelper.loadAndMergeMetaMap(document.getRootElement(), null);
                        Iterator generateElements = document.getRootElement().getChildren("generate").iterator();
                        while (generateElements.hasNext()) {
                            generators.add(new Generator((Element)generateElements.next()));
                        }
                        continue;
                    }
                    if (args[i].startsWith("--output=")) {
                        outputDir = args[i].substring(9);
                        continue;
                    }
                    if (!args[i].startsWith("--inputdir=")) continue;
                    String inputStr = args[i];
                    String dirLocation = inputStr.substring(11);
                    File inputDir = new File(dirLocation);
                    if (inputDir.exists() && inputDir.isDirectory()) {
                        FilenameFilter filter = new FilenameFilter(){

                            public boolean accept(File dir, String name) {
                                return name.endsWith(".xml");
                            }
                        };
                        File[] files = inputDir.listFiles(filter);
                        for (int j = 0; j < files.length; ++j) {
                            File file = files[j];
                            log.warn((Object)("filename:" + file.getName()));
                            mappingFiles.add(file.getPath());
                        }
                        continue;
                    }
                    log.error((Object)("Invalid input directory: " + dirLocation));
                    continue;
                }
                mappingFiles.add(args[i]);
            }
            if (generators.size() == 0) {
                generators.add(new Generator());
            }
            HashMap<String, ClassMapping> classMappings = new HashMap<String, ClassMapping>();
            builder.setValidation(true);
            Iterator iter = mappingFiles.iterator();
            while (iter.hasNext()) {
                File file = new File((String)iter.next());
                Document document = builder.build(file);
                Element rootElement = document.getRootElement();
                Iterator classElements = rootElement.getChildren("class").iterator();
                MultiMap mm = MetaAttributeHelper.loadAndMergeMetaMap(rootElement, (MultiMap)globalMetas);
                while (classElements.hasNext()) {
                    ClassMapping cmap = new ClassMapping((Element)classElements.next(), mm);
                    classMappings.put(cmap.getCanonicalName(), cmap);
                }
            }
            Iterator iterator = generators.iterator();
            while (iterator.hasNext()) {
                Generator g = (Generator)iterator.next();
                g.setBaseDirName(outputDir);
                g.generate(classMappings);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

