/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.tool.hbm2java.AbstractRenderer;
import net.sf.hibernate.tool.hbm2java.ClassMapping;
import net.sf.hibernate.tool.hbm2java.ClassName;
import net.sf.hibernate.tool.hbm2java.Field;
import net.sf.hibernate.tool.hbm2java.MethodSignatureBuilder;
import net.sf.hibernate.tool.hbm2java.QueryBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FinderRenderer
extends AbstractRenderer {
    private static final String MT_FINDERMETHOD = "finder";
    private static final String MT_FOREIGNFINDERMETHOD = "foreign-finder-name";
    private static final String MT_FOREIGNFINDERFIELD = "foreign-finder-field";
    private static final String MT_FOREIGNJOINFIELD = "foreign-join-field";
    private static Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$tool$hbm2java$FinderRenderer == null ? (class$net$sf$hibernate$tool$hbm2java$FinderRenderer = FinderRenderer.class$("net.sf.hibernate.tool.hbm2java.FinderRenderer")) : class$net$sf$hibernate$tool$hbm2java$FinderRenderer));
    static Map primitiveToObject = new HashMap();
    static Map hibType = new HashMap();
    static /* synthetic */ Class class$net$sf$hibernate$tool$hbm2java$FinderRenderer;

    public FinderRenderer() {
        primitiveToObject.put("char", "Character");
        primitiveToObject.put("byte", "Byte");
        primitiveToObject.put("short", "Short");
        primitiveToObject.put("int", "Integer");
        primitiveToObject.put("long", "Long");
        primitiveToObject.put("boolean", "Boolean");
        primitiveToObject.put("float", "Float");
        primitiveToObject.put("double", "Double");
        hibType.put("char", "Hibernate.CHARACTER");
        hibType.put("byte", "Hibernate.BYTE");
        hibType.put("short", "Hibernate.SHORT");
        hibType.put("int", "Hibernate.INTEGER");
        hibType.put("long", "Hibernate.LONG");
        hibType.put("boolean", "Hibernate.BOOLEAN");
        hibType.put("float", "Hibernate.FLOAT");
        hibType.put("double", "Hibernate.DOUBLE");
        hibType.put("String", "Hibernate.STRING");
    }

    public void render(String savedToPackage, String savedToClass, ClassMapping classMapping, Map class2classmap, PrintWriter mainwriter) throws Exception {
        if (savedToPackage != null && !savedToPackage.trim().equals("")) {
            mainwriter.println("package " + savedToPackage + ";");
        } else if (classMapping.getGeneratedPackageName() != null) {
            mainwriter.println("package " + classMapping.getGeneratedPackageName() + ";");
        } else {
            mainwriter.println("// default package");
        }
        mainwriter.println();
        StringWriter strWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(strWriter);
        writer.println("/** Automatically generated Finder class for " + savedToClass + ".\n" + " * @author Hibernate FinderGenerator " + " **/");
        String classScope = "public";
        writer.print(classScope + " class " + savedToClass);
        writer.print(" implements Serializable");
        writer.println(" {");
        writer.println();
        StringWriter strPropWriter = new StringWriter();
        PrintWriter propWriter = new PrintWriter(strPropWriter);
        this.doFinders(classMapping, class2classmap, propWriter);
        propWriter.println("}");
        writer.print(strPropWriter.toString());
        this.doImports(classMapping, mainwriter);
        mainwriter.print(strWriter.toString());
    }

    public void doFinders(ClassMapping classMapping, Map class2classmap, PrintWriter writer) {
        String sessionMethod = classMapping.getMetaAsString("session-method").trim();
        Iterator fields = classMapping.getFields().iterator();
        while (fields.hasNext()) {
            String finderName;
            Field field = (Field)fields.next();
            if (field.getMeta(MT_FINDERMETHOD) != null) {
                finderName = field.getMetaAsString(MT_FINDERMETHOD);
                if ("".equals(sessionMethod)) {
                    writer.println("    public static List " + finderName + "(Session session, " + FinderRenderer.getTrueTypeName(field, class2classmap) + " " + field.getName() + ") " + "throws HibernateException {");
                } else {
                    writer.println("    public static List " + finderName + "(" + FinderRenderer.getTrueTypeName(field, class2classmap) + " " + field.getName() + ") " + "throws HibernateException {");
                    writer.println("        Session session = " + sessionMethod);
                }
                writer.println("        List finds = session.find(\"from " + classMapping.getName() + " as " + classMapping.getName().toLowerCase() + " where " + classMapping.getName().toLowerCase() + "." + field.getName() + "=?\", " + FinderRenderer.getFieldAsObject(false, field) + ", " + FinderRenderer.getFieldAsHibernateType(false, field) + ");");
                writer.println("        return finds;");
                writer.println("    }");
                writer.println();
                continue;
            }
            if (field.getMeta(MT_FOREIGNFINDERMETHOD) == null) continue;
            finderName = field.getMetaAsString(MT_FOREIGNFINDERMETHOD);
            String fieldName = field.getMetaAsString(MT_FOREIGNFINDERFIELD);
            String joinFieldName = field.getMetaAsString(MT_FOREIGNJOINFIELD);
            QueryBuilder qb = new QueryBuilder();
            qb.setLocalClass(classMapping);
            qb.setForeignClass(field.getForeignClass(), class2classmap, joinFieldName);
            ClassMapping foreignClass = (ClassMapping)class2classmap.get(field.getForeignClass().getFullyQualifiedName());
            if (foreignClass == null) {
                log.error((Object)("Could not find the class " + field.getForeignClass().getName()));
                return;
            }
            Field foreignField = null;
            Iterator foreignFields = foreignClass.getFields().iterator();
            while (foreignFields.hasNext()) {
                Field f = (Field)foreignFields.next();
                if (!f.getName().equals(fieldName)) continue;
                foreignField = f;
            }
            if (foreignField == null) {
                log.error((Object)("Could not find the field " + fieldName + " that was supposed to be in class " + field.getForeignClass().getName()));
                return;
            }
            qb.addCritera(foreignClass, foreignField, "=");
            MethodSignatureBuilder msb = new MethodSignatureBuilder(finderName, "List", "public static");
            if ("".equals(sessionMethod)) {
                msb.addParam("Session session");
            }
            msb.addParam(classMapping.getName() + " " + classMapping.getName().toLowerCase());
            msb.addParam(FinderRenderer.getTrueTypeName(foreignField, class2classmap) + " " + foreignField.getName());
            msb.addThrows("HibernateException");
            writer.println("    " + msb.buildMethodSignature());
            if (!"".equals(sessionMethod)) {
                writer.println("        Session session = " + sessionMethod);
            }
            writer.println("        List finds = session.find(\"" + qb.getQuery() + "\", " + qb.getParamsAsString() + ", " + qb.getParamTypesAsString() + ");");
            writer.println("        return finds;");
            writer.println("    }");
            writer.println();
        }
        if ("".equals(sessionMethod)) {
            writer.println("    public static List findAll(Session session) throws HibernateException {");
        } else {
            writer.println("    public static List findAll() throws HibernateException {");
            writer.println("        Session session = " + sessionMethod);
        }
        writer.println("        List finds = session.find(\"from " + classMapping.getName() + " in class " + classMapping.getPackageName() + "." + classMapping.getName() + "\");");
        writer.println("        return finds;");
        writer.println("    }");
        writer.println();
    }

    public void doImports(ClassMapping classMapping, PrintWriter writer) {
        writer.println("import java.io.Serializable;");
        writer.println("import java.util.List;");
        writer.println();
        writer.println("import net.sf.hibernate.type.Type;");
        writer.println("import net.sf.hibernate.Hibernate;");
        writer.println("import net.sf.hibernate.Session;");
        writer.println("import net.sf.hibernate.HibernateException;");
        writer.println();
    }

    public static String getFieldAsObject(boolean prependThis, Field field) {
        ClassName type = field.getClassType();
        if (type != null && type.isPrimitive() && !type.isArray()) {
            String typeName = (String)primitiveToObject.get(type.getName());
            typeName = "new " + typeName + "( ";
            typeName = typeName + (prependThis ? "this." : "");
            return typeName + field.getName() + " )";
        }
        return field.getName();
    }

    public static String getFieldAsHibernateType(boolean prependThis, Field field) {
        ClassName type = field.getClassType();
        String hibTypeString = (String)hibType.get(type.getName());
        if (hibType != null) {
            return hibTypeString;
        }
        return "Hibernate.OBJECT";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

