/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.async;

import com.mchange.v2.async.Queuable;
import com.mchange.v2.async.RunnableQueue;
import com.mchange.v2.async.StrandedTaskReporting;
import com.mchange.v2.util.ResourceClosedException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CarefulRunnableQueue
implements RunnableQueue,
Queuable,
StrandedTaskReporting {
    private List taskList = new LinkedList();
    private TaskThread t = new TaskThread();
    private boolean shutdown_on_interrupt;
    private boolean gentle_close_requested = false;
    private List strandedTasks = null;

    public CarefulRunnableQueue(boolean daemon, boolean shutdown_on_interrupt) {
        this.shutdown_on_interrupt = shutdown_on_interrupt;
        this.t.setDaemon(daemon);
        this.t.start();
    }

    public RunnableQueue asRunnableQueue() {
        return this;
    }

    public synchronized void postRunnable(Runnable r) {
        try {
            if (this.gentle_close_requested) {
                throw new ResourceClosedException("Attempted to post a task to a closing CarefulRunnableQueue.");
            }
            this.taskList.add(r);
            this.notifyAll();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            if (this.taskList == null) {
                throw new ResourceClosedException("Attempted to post a task to a CarefulRunnableQueue which has been closed, or whose TaskThread has been interrupted.");
            }
            throw e;
        }
    }

    public synchronized void close(boolean skip_remaining_tasks) {
        if (skip_remaining_tasks) {
            this.t.safeStop();
        } else {
            this.gentle_close_requested = true;
        }
    }

    public synchronized void close() {
        this.close(true);
    }

    public synchronized List getStrandedTasks() {
        try {
            while (this.gentle_close_requested && this.taskList != null) {
                this.wait();
            }
            return this.strandedTasks;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(Thread.currentThread() + " interrupted while waiting for stranded tasks from CarefulRunnableQueue.");
        }
    }

    private synchronized Runnable dequeueRunnable() {
        Runnable r = (Runnable)this.taskList.get(0);
        this.taskList.remove(0);
        return r;
    }

    private synchronized void awaitTask() throws InterruptedException {
        while (this.taskList.size() == 0) {
            if (this.gentle_close_requested) {
                this.t.safeStop();
            }
            this.wait();
        }
    }

    class TaskThread
    extends Thread {
        boolean should_stop = false;

        TaskThread() {
            super("CarefulRunnableQueue.TaskThread");
        }

        public synchronized void safeStop() {
            this.should_stop = true;
        }

        private synchronized boolean shouldStop() {
            return this.should_stop;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            CarefulRunnableQueue carefulRunnableQueue;
            try {
                try {
                    while (!this.shouldStop()) {
                        try {
                            CarefulRunnableQueue.this.awaitTask();
                            Runnable r = CarefulRunnableQueue.this.dequeueRunnable();
                            try {
                                r.run();
                            }
                            catch (Exception e) {
                                System.err.println(this.getClass().getName() + " -- Unexpected exception in task!");
                                e.printStackTrace();
                            }
                        }
                        catch (InterruptedException e) {
                            if (CarefulRunnableQueue.this.shutdown_on_interrupt) {
                                CarefulRunnableQueue.this.close(false);
                                System.err.println(this.toString() + " interrupted. Shutting down after current tasks" + " have completed.");
                                continue;
                            }
                            System.err.println(this.toString() + " received interrupt. IGNORING.");
                        }
                    }
                }
                catch (ThreadDeath td) {
                    System.err.print("c3p0-TRAVIS: ");
                    System.err.println(this.getName() + ": Some bastard used the deprecated stop() method to kill me!!!!");
                    td.printStackTrace();
                    throw td;
                }
                catch (Throwable t) {
                    System.err.print("c3p0-TRAVIS: ");
                    System.err.println(this.getName() + ": Some unexpected Throwable occurred and killed me!!!!");
                    t.printStackTrace();
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (!(t instanceof RuntimeException)) throw new InternalError(t.toString());
                    throw (RuntimeException)t;
                }
                Object var4_6 = null;
                carefulRunnableQueue = CarefulRunnableQueue.this;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                CarefulRunnableQueue carefulRunnableQueue2 = CarefulRunnableQueue.this;
                synchronized (carefulRunnableQueue2) {
                    CarefulRunnableQueue.this.strandedTasks = Collections.unmodifiableList(CarefulRunnableQueue.this.taskList);
                    CarefulRunnableQueue.this.taskList = null;
                    CarefulRunnableQueue.this.t = null;
                    CarefulRunnableQueue.this.notifyAll();
                    throw throwable;
                }
            }
            synchronized (carefulRunnableQueue) {
                CarefulRunnableQueue.this.strandedTasks = Collections.unmodifiableList(CarefulRunnableQueue.this.taskList);
                CarefulRunnableQueue.this.taskList = null;
                CarefulRunnableQueue.this.t = null;
                CarefulRunnableQueue.this.notifyAll();
                return;
            }
        }
    }
}

