/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.PoolBackedDataSource;
import com.mchange.v2.c3p0.PoolConfig;
import com.mchange.v2.c3p0.impl.DriverManagerDataSource;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSource;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.DataSource;

public final class DataSources {
    public static DataSource unpooledDataSource(String jdbcUrl) {
        return DataSources.unpooledDataSource(jdbcUrl, new Properties());
    }

    public static DataSource unpooledDataSource(String jdbcUrl, String user, String password) {
        Properties props = new Properties();
        ((Hashtable)props).put("user", user);
        ((Hashtable)props).put("password", password);
        return DataSources.unpooledDataSource(jdbcUrl, props);
    }

    public static DataSource unpooledDataSource(String jdbcUrl, Properties driverProps) {
        DriverManagerDataSource.Mutable out = new DriverManagerDataSource.Mutable();
        out.setJdbcUrl(jdbcUrl);
        out.setProperties(driverProps);
        return out.asImmutable();
    }

    public static DataSource pooledDataSource(DataSource unpooledDataSource) {
        return DataSources.pooledDataSource(unpooledDataSource, PoolConfig.DEFAULTS);
    }

    public static DataSource pooledDataSource(DataSource unpooledDataSource, int statement_cache_size) {
        PoolConfig pcfg = new PoolConfig();
        pcfg.setMaxStatements(statement_cache_size);
        return DataSources.pooledDataSource(unpooledDataSource, pcfg);
    }

    public static DataSource pooledDataSource(DataSource unpooledDataSource, PoolConfig pcfg) {
        WrapperConnectionPoolDataSource.Mutable wcpds = new WrapperConnectionPoolDataSource.Mutable();
        wcpds.setNestedDataSource(unpooledDataSource);
        wcpds.setMaxStatements(pcfg.getMaxStatements());
        wcpds.setInitialPoolSize(pcfg.getInitialPoolSize());
        wcpds.setMinPoolSize(pcfg.getMinPoolSize());
        wcpds.setMaxPoolSize(pcfg.getMaxPoolSize());
        wcpds.setIdleConnectionTestPeriod(pcfg.getIdleConnectionTestPeriod());
        wcpds.setMaxIdleTime(pcfg.getMaxIdleTime());
        wcpds.setPropertyCycle(pcfg.getPropertyCycle());
        wcpds.setAcquireIncrement(pcfg.getAcquireIncrement());
        wcpds.setConnectionTesterClassName(pcfg.getConnectionTesterClassName());
        wcpds.setTestConnectionOnCheckout(pcfg.isTestConnectionOnCheckout());
        wcpds.setAutoCommitOnClose(pcfg.isAutoCommitOnClose());
        wcpds.setForceIgnoreUnresolvedTransactions(pcfg.isForceIgnoreUnresolvedTransactions());
        wcpds.setFactoryClassLocation(pcfg.getFactoryClassLocation());
        WrapperConnectionPoolDataSource.Immutable cpds = wcpds.asImmutable();
        PoolBackedDataSource nascent_pbds = new PoolBackedDataSource();
        nascent_pbds.setConnectionPoolDataSource(cpds);
        nascent_pbds.setNumHelperThreads(pcfg.getNumHelperThreads());
        nascent_pbds.setFactoryClassLocation(pcfg.getFactoryClassLocation());
        return nascent_pbds.asImmutable();
    }

    public static DataSource pooledDataSource(DataSource unpooledDataSource, Properties props) {
        return DataSources.pooledDataSource(unpooledDataSource, new PoolConfig(props));
    }

    private DataSources() {
    }
}

