/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.async.RoundRobinAsynchronousRunner;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPool;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.sql.SqlUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import javax.sql.ConnectionPoolDataSource;

public final class C3P0PooledConnectionPoolManager {
    static final int DFLT_NUM_TASK_THREADS_PER_DATA_SOURCE = 3;
    Map authsToPools = new HashMap();
    final ConnectionPoolDataSource cpds;
    final RoundRobinAsynchronousRunner taskRunner;
    final Timer timer;
    final ResourcePoolFactory rpfact;
    GooGooStatementCache scache;
    int num_task_threads = 3;
    int maxStatements = C3P0Defaults.maxStatements();
    int minPoolSize = C3P0Defaults.minPoolSize();
    int maxPoolSize = C3P0Defaults.maxPoolSize();
    int idleConnectionTestPeriod = C3P0Defaults.idleConnectionTestPeriod();
    int maxIdleTime = C3P0Defaults.maxIdleTime();
    int acquireIncrement = C3P0Defaults.acquireIncrement();
    boolean testConnectionOnCheckout = C3P0Defaults.testConnectionOnCheckout();
    boolean autoCommitOnClose = C3P0Defaults.autoCommitOnClose();
    boolean forceIgnoreUnresolvedTransactions = C3P0Defaults.forceIgnoreUnresolvedTransactions();
    DbAuth defaultAuth = C3P0ImplUtils.NULL_AUTH;
    ConnectionTester connectionTester = C3P0Defaults.connectionTester();
    static /* synthetic */ Class class$java$lang$String;

    public C3P0PooledConnectionPoolManager(ConnectionPoolDataSource cpds, DbAuth defaultAuth, int maxStatements, int minPoolSize, int maxPoolSize, int idleConnectionTestPeriod, int maxIdleTime, int acquireIncrement, boolean testConnectionOnCheckout, boolean autoCommitOnClose, boolean forceIgnoreUnresolvedTransactions, ConnectionTester connectionTester) {
        this.taskRunner = new RoundRobinAsynchronousRunner(this.num_task_threads, true);
        this.timer = new Timer(true);
        this.rpfact = ResourcePoolFactory.createInstance(this.taskRunner, this.timer);
        this.cpds = cpds;
        this.defaultAuth = defaultAuth == null ? C3P0ImplUtils.NULL_AUTH : defaultAuth;
        this.maxStatements = maxStatements;
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.idleConnectionTestPeriod = idleConnectionTestPeriod;
        this.maxIdleTime = maxIdleTime;
        this.acquireIncrement = acquireIncrement;
        this.testConnectionOnCheckout = testConnectionOnCheckout;
        this.autoCommitOnClose = autoCommitOnClose;
        this.testConnectionOnCheckout = testConnectionOnCheckout;
        this.forceIgnoreUnresolvedTransactions = forceIgnoreUnresolvedTransactions;
        this.initStatementCache();
    }

    public C3P0PooledConnectionPoolManager(ConnectionPoolDataSource cpds, int num_task_threads) throws SQLException {
        this.taskRunner = new RoundRobinAsynchronousRunner(this.num_task_threads, true);
        this.timer = new Timer(true);
        this.rpfact = ResourcePoolFactory.createInstance(this.taskRunner, this.timer);
        try {
            this.cpds = cpds;
            this.num_task_threads = num_task_threads;
            this.defaultAuth = C3P0ImplUtils.findAuth(cpds);
            BeanInfo bi = Introspector.getBeanInfo(cpds.getClass());
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            int i = 0;
            int len = pds.length;
            while (i < len) {
                int value;
                Object propVal;
                PropertyDescriptor pd = pds[i];
                Class<?> propCl = pd.getPropertyType();
                String propName = pd.getName();
                Method readMethod = pd.getReadMethod();
                if (propCl == Integer.TYPE) {
                    propVal = readMethod.invoke((Object)cpds, C3P0ImplUtils.NOARGS);
                    value = (Integer)propVal;
                    if ("maxStatements".equals(propName)) {
                        this.maxStatements = value;
                    } else if ("minPoolSize".equals(propName)) {
                        this.minPoolSize = value;
                    } else if ("maxPoolSize".equals(propName)) {
                        this.maxPoolSize = value;
                    } else if ("idleConnectionTestPeriod".equals(propName)) {
                        this.idleConnectionTestPeriod = value;
                    } else if ("maxIdleTime".equals(propName)) {
                        this.maxIdleTime = value;
                    } else if ("acquireIncrement".equals(propName)) {
                        this.acquireIncrement = value;
                    }
                } else if (propCl == (class$java$lang$String == null ? C3P0PooledConnectionPoolManager.class$("java.lang.String") : class$java$lang$String)) {
                    propVal = readMethod.invoke((Object)cpds, C3P0ImplUtils.NOARGS);
                    String value2 = (String)propVal;
                    if ("connectionTesterClassName".equals(propName)) {
                        this.connectionTester = (ConnectionTester)Class.forName(value2).newInstance();
                    }
                } else if (propCl == Boolean.TYPE) {
                    propVal = readMethod.invoke((Object)cpds, C3P0ImplUtils.NOARGS);
                    value = ((Boolean)propVal).booleanValue() ? 1 : 0;
                    if ("testConnectionOnCheckout".equals(propName)) {
                        this.testConnectionOnCheckout = value;
                    } else if ("autoCommitOnClose".equals(propName)) {
                        this.autoCommitOnClose = value;
                    } else if ("forceIgnoreUnresolvedTransactions".equals(propName)) {
                        this.forceIgnoreUnresolvedTransactions = value;
                    }
                }
                ++i;
            }
            this.initStatementCache();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw SqlUtils.toSQLException(e);
        }
    }

    private void initStatementCache() {
        if (this.maxStatements > 0) {
            this.scache = new GooGooStatementCache(this.taskRunner, this.maxStatements);
        }
    }

    public synchronized C3P0PooledConnectionPool getPool(DbAuth auth) throws SQLException {
        C3P0PooledConnectionPool out = (C3P0PooledConnectionPool)this.authsToPools.get(auth);
        if (out == null) {
            out = this.createPooledConnectionPool(auth);
            this.authsToPools.put(auth, out);
        }
        return out;
    }

    public C3P0PooledConnectionPool getPool() throws SQLException {
        return this.getPool(this.defaultAuth);
    }

    public synchronized void close() {
        Iterator ii = this.authsToPools.values().iterator();
        while (ii.hasNext()) {
            try {
                ((C3P0PooledConnectionPool)ii.next()).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.taskRunner.close(true);
        this.timer.cancel();
        this.authsToPools = null;
    }

    protected synchronized void finalize() {
        if (this.authsToPools != null) {
            this.close();
        }
    }

    private C3P0PooledConnectionPool createPooledConnectionPool(DbAuth auth) throws SQLException {
        return new C3P0PooledConnectionPool(this.cpds, auth, this.minPoolSize, this.maxPoolSize, this.acquireIncrement, this.idleConnectionTestPeriod, this.maxIdleTime, this.testConnectionOnCheckout, this.scache, this.connectionTester, this.rpfact);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

