/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.lang.AmbiguousClassNameException;
import com.mchange.v1.lang.ClassUtils;
import com.mchange.v1.xml.DomParseUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DataSourceGenerator {
    Document doc;
    String pkg;
    String[] genImports;
    String[] spcImports;
    String outputClassName;
    String extendsClassName;
    String[] intfcs;
    Property[] properties;
    String implementsCode;
    String otherCode;
    static final Property FACTORY_CLASS_LOCATION_PROP = new Property();
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$DataSourceGenerator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$javax$naming$Referenceable;

    public DataSourceGenerator(Document doc) throws DOMException, AmbiguousClassNameException, ClassNotFoundException {
        this.doc = doc;
        Element rootElem = doc.getDocumentElement();
        this.pkg = DomParseUtils.allTextFromUniqueChild(rootElem, "package");
        Element importsElem = DomParseUtils.uniqueChild(rootElem, "imports");
        this.genImports = DomParseUtils.allTextFromImmediateChildElements(importsElem, "general");
        this.spcImports = DomParseUtils.allTextFromImmediateChildElements(importsElem, "specific");
        this.outputClassName = DomParseUtils.allTextFromUniqueChild(rootElem, "output-class");
        this.extendsClassName = DomParseUtils.allTextFromUniqueChild(rootElem, "extends");
        Element implementsElem = DomParseUtils.uniqueChild(rootElem, "implements");
        this.intfcs = DomParseUtils.allTextFromImmediateChildElements(implementsElem, "interface");
        Element propertiesElem = DomParseUtils.uniqueChild(rootElem, "properties");
        this.properties = this.findProperties(propertiesElem);
        this.implementsCode = DomParseUtils.allTextFromUniqueChild(rootElem, "interface-impl");
        this.otherCode = DomParseUtils.allTextFromUniqueChild(rootElem, "other-code");
    }

    private String createBannerComment() {
        return "/* This file generated by " + (class$com$mchange$v2$c3p0$impl$DataSourceGenerator == null ? (class$com$mchange$v2$c3p0$impl$DataSourceGenerator = DataSourceGenerator.class$("com.mchange.v2.c3p0.impl.DataSourceGenerator")) : class$com$mchange$v2$c3p0$impl$DataSourceGenerator).getName() + "\r\n" + " * DO NOT HAND EDIT!!!" + " */";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generate(PrintWriter out) throws IOException {
        out.println(this.createBannerComment());
        out.println();
        out.println("package " + this.pkg + ';');
        out.println();
        int i = 0;
        int len = this.genImports.length;
        while (i < len) {
            out.println("import " + this.genImports[i] + ".*;");
            ++i;
        }
        out.println("import com.mchange.v2.lang.ObjectUtils;");
        out.println();
        int i2 = 0;
        int len2 = this.spcImports.length;
        while (i2 < len2) {
            out.println("import " + this.spcImports[i2] + ".*;");
            ++i2;
        }
        out.println();
        out.print("public abstract class " + this.outputClassName);
        if (this.extendsClassName != null) {
            out.print(" extends " + this.extendsClassName);
        }
        out.print(" implements");
        boolean saw_referenceable = false;
        int i3 = 0;
        int len3 = this.intfcs.length;
        while (i3 < len3) {
            if (i3 != 0) {
                out.print(',');
            }
            out.print(' ');
            out.print(this.intfcs[i3]);
            if (this.intfcs[i3].equals("Referenceable")) {
                saw_referenceable = true;
            }
            ++i3;
        }
        if (!saw_referenceable) {
            if (this.intfcs.length > 0) {
                out.print(", ");
            }
            out.print("Referenceable");
        }
        out.println();
        out.println("{");
        out.println("\t//MT: protected by its own lock");
        out.println("\tfinal static Coalescer IMMUTABLES_COALESCER");
        out.println("\t\t= CoalescerFactory.createCoalescer( true, true );");
        out.println();
        out.println("\t/* properties */");
        int i4 = 0;
        int len4 = this.properties.length;
        while (i4 < len4) {
            Property prop = this.properties[i4];
            if (!prop.isVirtual()) {
                out.print("\ttransient " + prop.simpleTypeName + ' ' + prop.name);
                if (prop.dfltValExpr != null) {
                    out.print(" = " + prop.dfltValExpr.trim());
                }
                out.println(';');
            }
            ++i4;
        }
        out.println();
        out.println("\t/* getters */");
        int i5 = 0;
        int len5 = this.properties.length;
        while (i5 < len5) {
            Property prop = this.properties[i5];
            boolean is_boolean = prop.simpleTypeName.equals("boolean");
            out.println('\t' + prop.simpleTypeName + ' ' + DataSourceGenerator.getterName(prop.name, is_boolean) + "()");
            out.println("\t{");
            if (prop.virtualGetter != null) {
                out.println("\t\t" + prop.virtualGetter.trim());
            } else {
                out.print("\t\treturn ");
                if (prop.defensiveCopyExpression == null) {
                    out.println(prop.name + ';');
                } else {
                    out.println(prop.defensiveCopyExpression.trim() + ';');
                }
            }
            out.println("\t}");
            out.println();
            ++i5;
        }
        out.println("\t/* setters */");
        int i6 = 0;
        int len6 = this.properties.length;
        while (i6 < len6) {
            Property prop = this.properties[i6];
            if (!prop.is_read_only) {
                out.println("\tvoid " + DataSourceGenerator.setterName(prop.name) + "( " + prop.simpleTypeName + ' ' + prop.name + " )");
                out.println("\t{");
                if (prop.virtualSetter != null) {
                    out.println("\t\t" + prop.virtualSetter.trim());
                } else {
                    if (prop.setterValidationCode != null) {
                        out.println("\t\t" + prop.setterValidationCode.trim());
                    }
                    if (prop.defensiveCopyExpression != null) {
                        out.println("\t\t" + prop.name + " = " + prop.defensiveCopyExpression.trim() + ';');
                    }
                    out.println("\t\tthis." + prop.name + " = " + prop.name + ';');
                }
                if (prop.onRealizeFunction != null) {
                    out.println("\t\t" + prop.onRealizeFunction.trim() + "();");
                }
                out.println("\t}");
                out.println();
            }
            ++i6;
        }
        out.println("\tpublic " + this.outputClassName + ".Immutable asImmutable()");
        out.println("\t{");
        out.print("\t\treturn " + this.outputClassName + ".Immutable.find( ");
        int i7 = 0;
        int len7 = this.properties.length;
        while (i7 < len7) {
            Property prop = this.properties[i7];
            if (!prop.isVirtual()) {
                out.print(prop.name);
                if (i7 != len7 - 1) {
                    out.print(", ");
                } else {
                    out.println(" );");
                }
            }
            ++i7;
        }
        out.println("\t}");
        out.println();
        this.generateHandWrittenInterfacesImplementation(out);
        out.println(this.otherCode);
        out.println();
        out.println("\tprivate static boolean parseBoolean( String sRep )");
        out.println("\t{ return Boolean.valueOf( sRep ).booleanValue(); }");
        out.println();
        out.println("\tprivate static char firstChar( String s )");
        out.println("\t{ return s.charAt( 0 ); }");
        out.println();
        out.println("\tfinal static String REFADDR_VERSION      = \"version\";");
        int i8 = 0;
        int len8 = this.properties.length;
        while (i8 < len8) {
            Property prop = this.properties[i8];
            if (!prop.name.equals("factoryClassLocation") && !prop.isVirtual()) {
                out.println("\tfinal static String " + prop.refKey + " = \"" + prop.name + "\";");
            }
            ++i8;
        }
        out.println("\tfinal static int CURRENT_VERSION = 1;");
        out.println();
        out.println("\tpublic final Reference getReference() throws NamingException");
        out.println("\t{");
        out.println("\t\ttry");
        out.println("\t\t\t{");
        out.println("\t\t\t\tReference out");
        out.println("\t\t\t\t\t = new Reference(" + this.outputClassName + ".Immutable.class.getName(), " + this.outputClassName + ".ObjectFactory.class.getName(), factoryClassLocation);");
        out.println("\t\t\t\tout.add( new StringRefAddr( REFADDR_VERSION, String.valueOf(CURRENT_VERSION) ) );");
        int i9 = 0;
        int len9 = this.properties.length;
        while (i9 < len9) {
            Property prop = this.properties[i9];
            if (!prop.name.equals("factoryClassLocation") && !prop.isVirtual()) {
                String contentRep = prop.type == (class$java$lang$String == null ? DataSourceGenerator.class$("java.lang.String") : class$java$lang$String) ? "new StringRefAddr( " + prop.refKey + " , " + prop.name + " )" : (prop.type.isPrimitive() ? "new StringRefAddr( " + prop.refKey + " , String.valueOf( " + prop.name + " ) )" : ((class$java$io$Serializable == null ? DataSourceGenerator.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(prop.type) ? "new BinaryRefAddr( " + prop.refKey + " , SerializableUtils.toByteArray( " + prop.name + " ) )" : ((class$javax$naming$Referenceable == null ? DataSourceGenerator.class$("javax.naming.Referenceable") : class$javax$naming$Referenceable).isAssignableFrom(prop.type) ? "new BinaryRefAddr( " + prop.refKey + " , SerializableUtils.toByteArray( " + prop.name + ".getReference()" + " ) )" : "new BinaryRefAddr( " + prop.refKey + " , SerializableUtils.toByteArray( " + prop.name + " ) )")));
                out.println("\t\t\t\tout.add( " + contentRep + " );");
            }
            ++i9;
        }
        out.println("\t\t\t\treturn out;");
        out.println("\t\t\t}");
        out.println("\t\tcatch (Exception e)");
        out.println("\t\t\t{");
        out.println("\t\t\t\te.printStackTrace();");
        out.println("\t\t\t\tthrow new NamingException(\"Nested Exception: \"  + e.toString() );");
        out.println("\t\t\t}");
        out.println("\t}");
        out.println();
        out.println("\tpublic static class ObjectFactory implements javax.naming.spi.ObjectFactory");
        out.println("\t{");
        out.println("\t\tpublic Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env)");
        out.println("\t\t\tthrows Exception");
        out.println("\t\t{");
        out.println("\t\t\tReference ref;");
        out.println("\t\t\tString className = " + this.outputClassName + ".Immutable.class.getName();");
        out.println("\t\t\tif (refObj instanceof Reference && (ref = (Reference) refObj).getClassName().equals(className))");
        out.println("\t\t\t\t{");
        out.println("\t\t\t\tint version = Integer.parseInt( (String) ref.get(REFADDR_VERSION).getContent() );");
        out.println("\t\t\t\tif (version == 1)");
        out.println("\t\t\t\t{");
        StringBuffer findArgsBuf = new StringBuffer();
        int i10 = 0;
        int len10 = this.properties.length;
        while (i10 < len10) {
            Property prop = this.properties[i10];
            if (!prop.name.equals("factoryClassLocation") && !prop.isVirtual()) {
                String nascentPropName = "nascent" + DataSourceGenerator.capitalize(prop.name);
                if (i10 != 0) {
                    findArgsBuf.append(", ");
                }
                findArgsBuf.append(nascentPropName);
                out.println("\t\t\t\t\t" + prop.simpleTypeName + ' ' + nascentPropName + ';');
                if (prop.type == (class$java$lang$String == null ? DataSourceGenerator.class$("java.lang.String") : class$java$lang$String)) {
                    out.println("\t\t\t\t\t" + nascentPropName + " = (String) ref.get( " + prop.refKey + ").getContent();");
                } else if (prop.type.isPrimitive()) {
                    String parseFcn;
                    if (prop.type == Boolean.TYPE) {
                        parseFcn = "parseBoolean";
                    } else if (prop.type == Character.TYPE) {
                        parseFcn = "firstChar";
                    } else if (prop.type == Short.TYPE || prop.type == Integer.TYPE) {
                        parseFcn = "Integer.parseInt";
                    } else if (prop.type == Long.TYPE) {
                        parseFcn = "Long.parseLong";
                    } else if (prop.type == Float.TYPE) {
                        parseFcn = "Float.parseFloat";
                    } else {
                        if (prop.type != Double.TYPE) throw new RuntimeException("What kind of primitive? " + prop.type);
                        parseFcn = "Double.parseDouble";
                    }
                    out.println("\t\t\t\t\t" + nascentPropName + " = (" + prop.simpleTypeName + ") " + parseFcn + "( (String) " + "ref.get( " + prop.refKey + ").getContent() );");
                } else if ((class$java$io$Serializable == null ? DataSourceGenerator.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(prop.type)) {
                    out.println("\t\t\t\t\t" + nascentPropName + " = (" + prop.simpleTypeName + ") " + "SerializableUtils.fromByteArray( (byte[]) ref.get( " + prop.refKey + ").getContent() );");
                } else if ((class$javax$naming$Referenceable == null ? DataSourceGenerator.class$("javax.naming.Referenceable") : class$javax$naming$Referenceable).isAssignableFrom(prop.type)) {
                    String refVar = nascentPropName + "Ref";
                    out.println("\t\t\t\t\tReference" + refVar + ";");
                    out.println("\t\t\t\t\t" + refVar + " = (Reference) " + "SerializableUtils.fromByteArray( (byte[]) ref.get( " + prop.refKey + ").getContent() );");
                    out.println("\t\t\t\t\t" + nascentPropName + " = ReferenceableUtils.referenceToObject( " + refVar + ", name, nameCtx, env);");
                } else {
                    out.println("\t\t\t\t\t" + nascentPropName + " = (" + prop.simpleTypeName + ") " + "SerializableUtils.fromByteArray( (byte[]) ref.get( " + prop.refKey + ").getContent() );");
                }
            }
            ++i10;
        }
        String immutableClassName = this.outputClassName + ".Immutable";
        out.println("\t\t\t\t\treturn " + immutableClassName + ".find( " + findArgsBuf.toString() + ", ref.getFactoryClassLocation() );");
        out.println("\t\t\t\t}");
        out.println("\t\t\t\telse");
        out.println("\t\t\t\t\tthrow new NamingException(\"Cannot resolve reference (version \" + version + \" unknown.\");");
        out.println("\t\t\t}");
        out.println("\t\t\telse");
        out.println("\t\t\t\treturn null;");
        out.println("\t\t}");
        out.println("\t}");
        out.println("\tpublic static final class Immutable");
        out.println("\t\textends " + this.outputClassName + " implements Serializable");
        out.println("\t{");
        StringWriter sw = new StringWriter();
        PrintWriter findSetters = new PrintWriter(sw);
        StringBuffer findArgs = new StringBuffer();
        int i11 = 0;
        int len11 = this.properties.length;
        while (i11 < len11) {
            Property prop = this.properties[i11];
            if (!prop.isVirtual()) {
                if (i11 != 0) {
                    findArgs.append(", ");
                }
                findArgs.append(prop.simpleTypeName + " _" + prop.name);
                findSetters.println("\t\t\tuncanonical." + prop.name + " = _" + prop.name + ';');
                if (prop.onRealizeFunction != null) {
                    findSetters.println("\t\t\tuncanonical." + prop.onRealizeFunction.trim() + "();");
                }
            }
            ++i11;
        }
        findSetters.flush();
        out.println("\t\tpublic static " + immutableClassName + " find( " + findArgs.toString() + " )");
        out.println("\t\t{");
        out.println("\t\t\t" + immutableClassName + " uncanonical = new " + immutableClassName + "();");
        out.print(sw.toString());
        out.println("\t\t\treturn (" + immutableClassName + ") IMMUTABLES_COALESCER.coalesce( uncanonical );");
        out.println("\t\t}");
        out.println();
        out.println("\t\tprivate Immutable()");
        out.println("\t\t{}");
        out.println();
        this.writeNestedClassGetters(out, "public", false);
        out.println("\t\tpublic " + this.outputClassName + ".Immutable asImmutable()");
        out.println("\t\t{");
        out.print("\t\t\treturn this;");
        out.println("\t\t}");
        out.println();
        out.println("\t\tpublic boolean equals(Object o)");
        out.println("\t\t{");
        out.println("\t\t\tif (o instanceof " + immutableClassName + ")");
        out.println("\t\t\t{");
        out.println("\t\t\t\t" + immutableClassName + " other = (" + immutableClassName + ") o;");
        out.println("\t\t\t\treturn");
        int i12 = 0;
        int len12 = this.properties.length;
        while (i12 < len12) {
            Property prop = this.properties[i12];
            if (!prop.isVirtual()) {
                if (prop.type.isPrimitive()) {
                    out.print("\t\t\t\t\tthis." + prop.name + " == other." + prop.name);
                } else {
                    out.print("\t\t\t\t\tObjectUtils.eqOrBothNull( this." + prop.name + ", other." + prop.name + ')');
                }
                if (i12 == len12 - 1) {
                    out.println(';');
                } else {
                    out.println(" &&");
                }
            }
            ++i12;
        }
        out.println("\t\t\t}");
        out.println("\t\t\telse return false;");
        out.println("\t\t}");
        out.println();
        out.println("\t\tpublic int hashCode()");
        out.println("\t\t{");
        out.println("\t\t\treturn");
        int i13 = 0;
        int len13 = this.properties.length;
        while (i13 < len13) {
            Property prop = this.properties[i13];
            if (!prop.isVirtual()) {
                if (prop.type.isPrimitive()) {
                    if (prop.type == Byte.TYPE || prop.type == Character.TYPE || prop.type == Short.TYPE || prop.type == Integer.TYPE) {
                        out.print("\t\t\t\tthis." + prop.name);
                    } else {
                        if (prop.type != Boolean.TYPE) throw new RuntimeException("Not impemented: Can't deal with floating point properties yet. Fix me if necessary.");
                        out.print("\t\t\t\t( this." + prop.name + " ? 1 : 0 )");
                    }
                } else {
                    out.print("\t\t\t\tObjectUtils.hashOrZero( this." + prop.name + ')');
                }
                if (i13 == len13 - 1) {
                    out.println(';');
                } else {
                    out.println(" ^");
                }
            }
            ++i13;
        }
        out.println("\t\t}");
        out.println();
        out.println("\t\tprivate static final long serialVersionUID = 1;");
        out.println("\t\tprivate static final short VERSION = 0x0001;");
        out.println();
        out.println("\t\tprivate void writeObject(ObjectOutputStream out) throws IOException");
        out.println("\t\t{");
        out.println("\t\t\tout.writeShort( VERSION );");
        out.println();
        int i14 = 0;
        int len14 = this.properties.length;
        while (i14 < len14) {
            Property prop = this.properties[i14];
            if (!prop.isVirtual()) {
                if (prop.type.isPrimitive()) {
                    if (prop.type == Byte.TYPE) {
                        out.println("\t\t\tout.writeByte(" + prop.name + ");");
                    } else if (prop.type == Character.TYPE) {
                        out.println("\t\t\tout.writeChar(" + prop.name + ");");
                    } else if (prop.type == Short.TYPE) {
                        out.println("\t\t\tout.writeShort(" + prop.name + ");");
                    } else if (prop.type == Integer.TYPE) {
                        out.println("\t\t\tout.writeInt(" + prop.name + ");");
                    } else {
                        if (prop.type != Boolean.TYPE) throw new RuntimeException("Not implemented: Can't deal with floating point properties yet. FIXME if necessary.");
                        out.println("\t\t\tout.writeBoolean(" + prop.name + ");");
                    }
                } else if ((class$java$io$Serializable == null ? DataSourceGenerator.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(prop.type) || !(class$javax$naming$Referenceable == null ? DataSourceGenerator.class$("javax.naming.Referenceable") : class$javax$naming$Referenceable).isAssignableFrom(prop.type)) {
                    out.println("\t\t\tout.writeObject(" + prop.name + ");");
                } else {
                    out.println("\t\t\tReferenceable r = ((Referenceable) " + prop.name + ").getReference();");
                    out.println("\t\t\tout.writeObject( r );");
                }
            }
            ++i14;
        }
        out.println("\t\t}");
        out.println();
        out.println("\t\tprivate void readObject(ObjectInputStream in)");
        out.println("\t\t\tthrows IOException, ClassNotFoundException");
        out.println("\t\t{");
        out.println("\t\t\tshort version = in.readShort();");
        out.println("\t\t\tswitch (version)");
        out.println("\t\t\t{");
        out.println("\t\t\tcase 0x0001:");
        int i15 = 0;
        int len15 = this.properties.length;
        while (i15 < len15) {
            Property prop = this.properties[i15];
            if (!prop.isVirtual()) {
                if (prop.type.isPrimitive()) {
                    if (prop.type == Byte.TYPE) {
                        out.println("\t\t\t\tthis." + prop.name + " = in.readByte();");
                    } else if (prop.type == Character.TYPE) {
                        out.println("\t\t\t\tthis." + prop.name + " = in.readChar();");
                    } else if (prop.type == Short.TYPE) {
                        out.println("\t\t\t\tthis." + prop.name + " = in.readShort();");
                    } else if (prop.type == Integer.TYPE) {
                        out.println("\t\t\t\tthis." + prop.name + " = in.readInt();");
                    } else {
                        if (prop.type != Boolean.TYPE) throw new RuntimeException("Not Implemented: Can't deal with floating point properties yet. Fix me if necessary.");
                        out.println("\t\t\t\tthis." + prop.name + " = in.readBoolean();");
                    }
                } else if ((class$java$io$Serializable == null ? DataSourceGenerator.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(prop.type) || !(class$javax$naming$Referenceable == null ? DataSourceGenerator.class$("javax.naming.Referenceable") : class$javax$naming$Referenceable).isAssignableFrom(prop.type)) {
                    out.println("\t\t\t\tthis." + prop.name + " = (" + prop.simpleTypeName + ") in.readObject();");
                } else {
                    out.println("Reference ref = (Reference) in.readObject();");
                    out.println("\t\t\t\tthis." + prop.name + " = (" + prop.simpleTypeName + ") ReferenceableUtils." + "referenceToObject( ref, null, null, null );");
                }
                if (prop.onRealizeFunction != null) {
                    out.println("\t\t\t\tthis." + prop.onRealizeFunction.trim() + "();");
                }
            }
            ++i15;
        }
        out.println("\t\t\t\tbreak;");
        out.println("\t\t\tdefault:");
        out.println("\t\t\t\tthrow new UnsupportedVersionException(this, version);");
        out.println("\t\t\t}");
        out.println("\t\t}");
        out.println();
        out.println("\t}");
        out.println();
        out.println("\tpublic static abstract class Base");
        out.println("\t\textends " + this.outputClassName + " implements Serializable");
        out.println("\t{");
        this.writeNestedClassGetters(out, "protected", true);
        this.writeNestedClassSetters(out, "protected", true);
        this.writeImmutableReplacingSerStuff(out);
        out.println("\t}");
        out.println("\tpublic static final class Mutable");
        out.println("\t\textends " + this.outputClassName + " implements Serializable");
        out.println("\t{");
        this.writeNestedClassGetters(out, "public", true);
        this.writeNestedClassSetters(out, "public", true);
        this.writeImmutableReplacingSerStuff(out);
        out.println("\t}");
        out.println("}");
    }

    private void writeImmutableReplacingSerStuff(PrintWriter out) throws IOException {
        out.println("\t\tprotected Object writeReplace() throws ObjectStreamException");
        out.println("\t\t{ return this.asImmutable(); }");
        out.println();
        out.println("\t\tprivate void writeObject(ObjectOutputStream out) throws IOException");
        out.println("\t\t{");
        out.println("\t\t\tthrow new IOException(\"We should be writing a replacement, can't write mutable version of " + this.outputClassName + "\");");
        out.println("\t\t}");
        out.println();
        out.println("\t\tprivate void readObject(ObjectInputStream in) throws IOException");
        out.println("\t\t{");
        out.println("\t\t\tthrow new IOException(\"We should not be finding this mutable version of " + this.outputClassName + "on the wire... we only allow the immutable " + "version to write itself!\");");
        out.println("\t\t}");
        out.println();
    }

    private void writeNestedClassGetters(PrintWriter out, String visibility, boolean synced) throws IOException {
        int i = 0;
        int len = this.properties.length;
        while (i < len) {
            Property prop = this.properties[i];
            boolean is_boolean = prop.simpleTypeName.equals("boolean");
            String gName = DataSourceGenerator.getterName(prop.name, is_boolean);
            out.println("\t\t" + visibility + ' ' + (synced ? "synchronized " : "") + prop.simpleTypeName + ' ' + gName + "()");
            out.print("\t\t{");
            out.print(" return super." + gName + "();");
            out.println(" }");
            out.println();
            ++i;
        }
    }

    private void writeNestedClassSetters(PrintWriter out, String visibility, boolean synced) throws IOException {
        int i = 0;
        int len = this.properties.length;
        while (i < len) {
            Property prop = this.properties[i];
            if (!prop.is_read_only) {
                String sName = DataSourceGenerator.setterName(prop.name);
                out.println("\t\t" + visibility + ' ' + (synced ? "synchronized " : "") + "void " + sName + "( " + prop.simpleTypeName + ' ' + prop.name + " )");
                out.print("\t\t{");
                out.print(" super." + sName + "( " + prop.name + " );");
                out.println(" }");
                out.println();
            }
            ++i;
        }
    }

    private void generateHandWrittenInterfacesImplementation(PrintWriter out) {
        out.println(this.implementsCode);
        out.println();
    }

    private void generateImmutableDelegatingInterfacesImplementation(PrintWriter out) throws AmbiguousClassNameException, ClassNotFoundException {
        int intfcs_len = this.intfcs.length;
        int i = 0;
        while (i < intfcs_len) {
            Class intfc = ClassUtils.classForSimpleName(this.intfcs[i], this.genImports, this.spcImports);
            Method[] methods = intfc.getMethods();
            int m = 0;
            int mlen = methods.length;
            while (m < mlen) {
                Method imethod = methods[m];
                out.print("\tpublic final ");
                Class<?> retType = imethod.getReturnType();
                out.print(this.resolvableTypeName(retType));
                out.print(' ' + imethod.getName() + "( ");
                Class<?>[] paramTypes = imethod.getParameterTypes();
                int p = 0;
                int plen = paramTypes.length;
                while (p < plen) {
                    if (p != 0) {
                        out.print(", ");
                    }
                    out.print(this.resolvableTypeName(paramTypes[p]) + ' ');
                    out.print("param" + p);
                    ++p;
                }
                out.print(" )");
                Class<?>[] excTypes = imethod.getExceptionTypes();
                int elen = excTypes.length;
                if (elen > 0) {
                    out.print(' ');
                    int e = 0;
                    while (e < elen) {
                        if (e != 0) {
                            out.print(", ");
                        }
                        out.print(this.resolvableTypeName(excTypes[e]));
                        ++e;
                    }
                }
                out.println();
                out.print("\t{ this.asImmutable().");
                out.print(imethod.getName());
                out.print("( ");
                int p2 = 0;
                int plen2 = paramTypes.length;
                while (p2 < plen2) {
                    if (p2 != 0) {
                        out.print(", ");
                    }
                    out.print("param" + p2);
                    ++p2;
                }
                out.println(" ); }");
                out.println();
                ++m;
            }
            ++i;
        }
    }

    private String resolvableTypeName(Class type) throws ClassNotFoundException {
        return ClassUtils.resolvableTypeName(type, this.genImports, this.spcImports);
    }

    private static String getterName(String propName, boolean is_boolean) {
        return (is_boolean ? "is" : "get") + DataSourceGenerator.capitalize(propName);
    }

    private static String setterName(String propName) {
        return "set" + DataSourceGenerator.capitalize(propName);
    }

    private static String capitalize(String propName) {
        char c = propName.charAt(0);
        return Character.toUpperCase(c) + propName.substring(1);
    }

    private Property[] findProperties(Element propertiesElem) throws DOMException, AmbiguousClassNameException, ClassNotFoundException {
        NodeList nl = DomParseUtils.immediateChildElementsByTagName(propertiesElem, "property");
        int len = nl.getLength();
        Property[] out = new Property[len + 1];
        int i = 0;
        while (i < len) {
            Element readOnlyElem;
            Element propertyElem = (Element)nl.item(i);
            Property prop = new Property();
            prop.name = DomParseUtils.allTextFromUniqueChild(propertyElem, "name");
            prop.simpleTypeName = DomParseUtils.allTextFromUniqueChild(propertyElem, "type");
            prop.type = ClassUtils.classForSimpleName(prop.simpleTypeName, this.genImports, this.spcImports);
            if (prop.name.equals("factoryClassLocation")) {
                throw new RuntimeException("There's special support for factoryClassLocation,  don't include it in the XML source!");
            }
            if (!prop.type.isPrimitive()) {
                prop.serializable = propertyElem.getElementsByTagName("serializable").getLength() > 0 ? true : (propertyElem.getElementsByTagName("not-serializable").getLength() > 0 ? false : (class$java$io$Serializable == null ? DataSourceGenerator.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(prop.type));
                prop.referenceable = propertyElem.getElementsByTagName("referenceable").getLength() > 0 ? true : (propertyElem.getElementsByTagName("not-referenceable").getLength() > 0 ? true : (class$javax$naming$Referenceable == null ? DataSourceGenerator.class$("javax.naming.Referenceable") : class$javax$naming$Referenceable).isAssignableFrom(prop.type));
            }
            prop.defensiveCopyExpression = DomParseUtils.allTextFromUniqueChild(propertyElem, "defensive-copy");
            prop.setterValidationCode = DomParseUtils.allTextFromUniqueChild(propertyElem, "validate");
            prop.onRealizeFunction = DomParseUtils.allTextFromUniqueChild(propertyElem, "on-realize-function-name");
            prop.dfltValExpr = DomParseUtils.allTextFromUniqueChild(propertyElem, "default-value-expression");
            Element virtual = DomParseUtils.uniqueChild(propertyElem, "virtual");
            if (virtual != null) {
                prop.virtualGetter = DomParseUtils.allTextFromUniqueChild(virtual, "getter-code");
                prop.virtualSetter = DomParseUtils.allTextFromUniqueChild(virtual, "setter-code");
            }
            prop.is_read_only = (readOnlyElem = DomParseUtils.uniqueChild(propertyElem, "read-only")) != null;
            prop.refKey = "REFADDR_" + prop.name;
            out[i] = prop;
            ++i;
        }
        out[out.length - 1] = FACTORY_CLASS_LOCATION_PROP;
        return out;
    }

    public static void main(String[] argv) {
        try {
            if (argv.length != 2) {
                System.err.println("java " + (class$com$mchange$v2$c3p0$impl$DataSourceGenerator == null ? (class$com$mchange$v2$c3p0$impl$DataSourceGenerator = DataSourceGenerator.class$("com.mchange.v2.c3p0.impl.DataSourceGenerator")) : class$com$mchange$v2$c3p0$impl$DataSourceGenerator).getName() + " <infile.xml> <OutputFile.java>");
                return;
            }
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = fact.newDocumentBuilder();
            Document doc = db.parse(new File(argv[0]));
            DataSourceGenerator gen = new DataSourceGenerator(doc);
            PrintWriter pw = new PrintWriter(new FileOutputStream(argv[1]));
            gen.generate(pw);
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DataSourceGenerator.FACTORY_CLASS_LOCATION_PROP.name = "factoryClassLocation";
        DataSourceGenerator.FACTORY_CLASS_LOCATION_PROP.simpleTypeName = "String";
        DataSourceGenerator.FACTORY_CLASS_LOCATION_PROP.type = class$java$lang$String == null ? (class$java$lang$String = DataSourceGenerator.class$("java.lang.String")) : class$java$lang$String;
        DataSourceGenerator.FACTORY_CLASS_LOCATION_PROP.serializable = true;
        DataSourceGenerator.FACTORY_CLASS_LOCATION_PROP.referenceable = false;
        DataSourceGenerator.FACTORY_CLASS_LOCATION_PROP.defensiveCopyExpression = null;
        DataSourceGenerator.FACTORY_CLASS_LOCATION_PROP.setterValidationCode = null;
        DataSourceGenerator.FACTORY_CLASS_LOCATION_PROP.refKey = null;
    }

    static class Property {
        String name;
        String simpleTypeName;
        Class type;
        boolean serializable;
        boolean referenceable;
        String defensiveCopyExpression;
        String setterValidationCode;
        String dfltValExpr;
        String virtualGetter;
        String virtualSetter;
        String onRealizeFunction;
        boolean is_read_only;
        String refKey;

        Property() {
        }

        boolean isVirtual() {
            return this.virtualGetter != null || this.virtualSetter != null;
        }
    }
}

