/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.lang.ObjectUtils;
import com.mchange.v2.ser.SerializableUtils;
import com.mchange.v2.ser.UnsupportedVersionException;
import com.mchange.v2.sql.SqlUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public abstract class JndiRefDataSource
implements DataSource,
Referenceable {
    static final Coalescer IMMUTABLES_COALESCER = CoalescerFactory.createCoalescer(true, true);
    transient Object jndiName;
    transient Hashtable jndiEnv;
    transient boolean caching = true;
    transient String factoryClassLocation;
    transient DataSource cachedInner;
    static final String REFADDR_VERSION = "version";
    static final String REFADDR_jndiName = "jndiName";
    static final String REFADDR_jndiEnv = "jndiEnv";
    static final String REFADDR_caching = "caching";
    static final int CURRENT_VERSION = 1;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$JndiRefDataSource$ObjectFactory;

    Object getJndiName() {
        return this.jndiName instanceof Name ? ((Name)this.jndiName).clone() : this.jndiName;
    }

    Hashtable getJndiEnv() {
        return (Hashtable)this.jndiEnv.clone();
    }

    boolean isCaching() {
        return this.caching;
    }

    String getFactoryClassLocation() {
        return this.factoryClassLocation;
    }

    void setJndiName(Object jndiName) {
        if (!(jndiName instanceof Name) && !(jndiName instanceof String)) {
            throw new IllegalArgumentException("jndiName must be a String or a javax.naming.Name");
        }
        this.jndiName = jndiName = jndiName instanceof Name ? ((Name)jndiName).clone() : jndiName;
    }

    void setJndiEnv(Hashtable jndiEnv) {
        this.jndiEnv = jndiEnv = (Hashtable)jndiEnv.clone();
    }

    void setCaching(boolean caching) {
        this.caching = caching;
    }

    void setFactoryClassLocation(String factoryClassLocation) {
        this.factoryClassLocation = factoryClassLocation;
    }

    public Immutable asImmutable() {
        return Immutable.find(this.jndiName, this.jndiEnv, this.caching, this.factoryClassLocation);
    }

    public Connection getConnection() throws SQLException {
        return this.inner().getConnection();
    }

    public Connection getConnection(String a, String b) throws SQLException {
        return this.inner().getConnection(a, b);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.inner().getLogWriter();
    }

    public int getLoginTimeout() throws SQLException {
        return this.inner().getLoginTimeout();
    }

    public void setLogWriter(PrintWriter a) throws SQLException {
        this.inner().setLogWriter(a);
    }

    public void setLoginTimeout(int a) throws SQLException {
        this.inner().setLoginTimeout(a);
    }

    private DataSource dereference() throws SQLException {
        try {
            InitialContext ctx = this.jndiEnv != null ? new InitialContext(this.jndiEnv) : new InitialContext();
            if (this.jndiName instanceof String) {
                return (DataSource)ctx.lookup((String)this.jndiName);
            }
            if (this.jndiName instanceof Name) {
                return (DataSource)ctx.lookup((Name)this.jndiName);
            }
            throw new SQLException("Could not find DataSource with JNDI name: " + this.jndiName);
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw SqlUtils.toSQLException(e);
        }
    }

    private synchronized DataSource inner() throws SQLException {
        if (this.cachedInner != null) {
            return this.cachedInner;
        }
        DataSource out = this.dereference();
        if (this.caching) {
            this.cachedInner = out;
        }
        return out;
    }

    private static boolean parseBoolean(String sRep) {
        return Boolean.valueOf(sRep);
    }

    private static char firstChar(String s) {
        return s.charAt(0);
    }

    public final Reference getReference() throws NamingException {
        try {
            Reference out = new Reference((class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable = JndiRefDataSource.class$("com.mchange.v2.c3p0.impl.JndiRefDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable).getName(), (class$com$mchange$v2$c3p0$impl$JndiRefDataSource$ObjectFactory == null ? (class$com$mchange$v2$c3p0$impl$JndiRefDataSource$ObjectFactory = JndiRefDataSource.class$("com.mchange.v2.c3p0.impl.JndiRefDataSource$ObjectFactory")) : class$com$mchange$v2$c3p0$impl$JndiRefDataSource$ObjectFactory).getName(), this.factoryClassLocation);
            out.add(new StringRefAddr(REFADDR_VERSION, String.valueOf(1)));
            out.add(new BinaryRefAddr(REFADDR_jndiName, SerializableUtils.toByteArray(this.jndiName)));
            out.add(new BinaryRefAddr(REFADDR_jndiEnv, SerializableUtils.toByteArray(this.jndiEnv)));
            out.add(new StringRefAddr(REFADDR_caching, String.valueOf(this.caching)));
            return out;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NamingException("Nested Exception: " + e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class Mutable
    extends JndiRefDataSource
    implements Serializable {
        public synchronized Object getJndiName() {
            return super.getJndiName();
        }

        public synchronized Hashtable getJndiEnv() {
            return super.getJndiEnv();
        }

        public synchronized boolean isCaching() {
            return super.isCaching();
        }

        public synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public synchronized void setJndiName(Object jndiName) {
            super.setJndiName(jndiName);
        }

        public synchronized void setJndiEnv(Hashtable jndiEnv) {
            super.setJndiEnv(jndiEnv);
        }

        public synchronized void setCaching(boolean caching) {
            super.setCaching(caching);
        }

        public synchronized void setFactoryClassLocation(String factoryClassLocation) {
            super.setFactoryClassLocation(factoryClassLocation);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of JndiRefDataSource");
        }

        private void readObject(ObjectInputStream in) throws IOException {
            throw new IOException("We should not be finding this mutable version of JndiRefDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static abstract class Base
    extends JndiRefDataSource
    implements Serializable {
        protected synchronized Object getJndiName() {
            return super.getJndiName();
        }

        protected synchronized Hashtable getJndiEnv() {
            return super.getJndiEnv();
        }

        protected synchronized boolean isCaching() {
            return super.isCaching();
        }

        protected synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        protected synchronized void setJndiName(Object jndiName) {
            super.setJndiName(jndiName);
        }

        protected synchronized void setJndiEnv(Hashtable jndiEnv) {
            super.setJndiEnv(jndiEnv);
        }

        protected synchronized void setCaching(boolean caching) {
            super.setCaching(caching);
        }

        protected synchronized void setFactoryClassLocation(String factoryClassLocation) {
            super.setFactoryClassLocation(factoryClassLocation);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of JndiRefDataSource");
        }

        private void readObject(ObjectInputStream in) throws IOException {
            throw new IOException("We should not be finding this mutable version of JndiRefDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static final class Immutable
    extends JndiRefDataSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final short VERSION = 1;

        public static Immutable find(Object _jndiName, Hashtable _jndiEnv, boolean _caching, String _factoryClassLocation) {
            Immutable uncanonical = new Immutable();
            uncanonical.jndiName = _jndiName;
            uncanonical.jndiEnv = _jndiEnv;
            uncanonical.caching = _caching;
            uncanonical.factoryClassLocation = _factoryClassLocation;
            return (Immutable)IMMUTABLES_COALESCER.coalesce(uncanonical);
        }

        private Immutable() {
        }

        public Object getJndiName() {
            return super.getJndiName();
        }

        public Hashtable getJndiEnv() {
            return super.getJndiEnv();
        }

        public boolean isCaching() {
            return super.isCaching();
        }

        public String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public Immutable asImmutable() {
            return this;
        }

        public boolean equals(Object o) {
            if (o instanceof Immutable) {
                Immutable other = (Immutable)o;
                return ObjectUtils.eqOrBothNull(this.jndiName, other.jndiName) && ObjectUtils.eqOrBothNull(this.jndiEnv, other.jndiEnv) && this.caching == other.caching && ObjectUtils.eqOrBothNull(this.factoryClassLocation, other.factoryClassLocation);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtils.hashOrZero(this.jndiName) ^ ObjectUtils.hashOrZero(this.jndiEnv) ^ (this.caching ? 1 : 0) ^ ObjectUtils.hashOrZero(this.factoryClassLocation);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeShort(1);
            out.writeObject(this.jndiName);
            out.writeObject(this.jndiEnv);
            out.writeBoolean(this.caching);
            out.writeObject(this.factoryClassLocation);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            short version = in.readShort();
            switch (version) {
                case 1: {
                    this.jndiName = in.readObject();
                    this.jndiEnv = (Hashtable)in.readObject();
                    this.caching = in.readBoolean();
                    this.factoryClassLocation = (String)in.readObject();
                    break;
                }
                default: {
                    throw new UnsupportedVersionException(this, version);
                }
            }
        }
    }

    public static class ObjectFactory
    implements javax.naming.spi.ObjectFactory {
        static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable;

        public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
            Reference ref;
            String className = (class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable = ObjectFactory.class$("com.mchange.v2.c3p0.impl.JndiRefDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$JndiRefDataSource$Immutable).getName();
            if (refObj instanceof Reference && (ref = (Reference)refObj).getClassName().equals(className)) {
                int version = Integer.parseInt((String)ref.get(JndiRefDataSource.REFADDR_VERSION).getContent());
                if (version == 1) {
                    Object nascentJndiName = SerializableUtils.fromByteArray((byte[])ref.get(JndiRefDataSource.REFADDR_jndiName).getContent());
                    Hashtable nascentJndiEnv = (Hashtable)SerializableUtils.fromByteArray((byte[])ref.get(JndiRefDataSource.REFADDR_jndiEnv).getContent());
                    boolean nascentCaching = JndiRefDataSource.parseBoolean((String)ref.get(JndiRefDataSource.REFADDR_caching).getContent());
                    return Immutable.find(nascentJndiName, nascentJndiEnv, nascentCaching, ref.getFactoryClassLocation());
                }
                throw new NamingException("Cannot resolve reference (version " + version + " unknown.");
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

