/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.concurrent;

import org.logicalcobwebs.concurrent.SynchronizedVariable;

public class SynchronizedFloat
extends SynchronizedVariable
implements Comparable,
Cloneable {
    protected float value_;

    public SynchronizedFloat(float initialValue) {
        this.value_ = initialValue;
    }

    public SynchronizedFloat(float initialValue, Object lock) {
        super(lock);
        this.value_ = initialValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float get() {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float set(float newValue) {
        Object object = this.lock_;
        synchronized (object) {
            float old = this.value_;
            this.value_ = newValue;
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit(float assumedValue, float newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success;
            boolean bl = success = assumedValue == this.value_;
            if (success) {
                this.value_ = newValue;
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float swap(SynchronizedFloat other) {
        if (other == this) {
            return this.get();
        }
        SynchronizedFloat fst = this;
        SynchronizedFloat snd = other;
        if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
            fst = other;
            snd = this;
        }
        Object object = fst.lock_;
        synchronized (object) {
            Object object2 = snd.lock_;
            synchronized (object2) {
                fst.set(snd.set(fst.get()));
                return this.get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float add(float amount) {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ += amount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float subtract(float amount) {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ -= amount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized float multiply(float factor) {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ *= factor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float divide(float factor) {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ /= factor;
        }
    }

    public int compareTo(float other) {
        float val = this.get();
        return val < other ? -1 : (val == other ? 0 : 1);
    }

    public int compareTo(SynchronizedFloat other) {
        return this.compareTo(other.get());
    }

    public int compareTo(Object other) {
        return this.compareTo((SynchronizedFloat)other);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SynchronizedFloat) {
            return this.get() == ((SynchronizedFloat)other).get();
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.get());
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

