/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.HouseKeeper;
import org.logicalcobwebs.proxool.HouseKeeperThread;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.util.FastArrayList;

public class HouseKeeperController {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$HouseKeeperController == null ? (class$org$logicalcobwebs$proxool$HouseKeeperController = HouseKeeperController.class$("org.logicalcobwebs.proxool.HouseKeeperController")) : class$org$logicalcobwebs$proxool$HouseKeeperController);
    private static Map houseKeepers = new HashMap();
    private static List houseKeeperList = new FastArrayList();
    private static int houseKeeperIndex = 0;
    private static List houseKeeperThreads = new FastArrayList();
    private static final Object LOCK = new Integer(1);
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$HouseKeeperController;

    private static HouseKeeper getHouseKeeper(String alias) throws ProxoolException {
        HouseKeeper houseKeeper = (HouseKeeper)houseKeepers.get(alias);
        if (houseKeeper == null) {
            throw new ProxoolException("Tried to use an unregistered house keeper '" + alias + "'");
        }
        return houseKeeper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HouseKeeper getHouseKeeperToRun() {
        HouseKeeper houseKeeper = null;
        Object object = LOCK;
        synchronized (object) {
            int i = 0;
            while (i < houseKeeperList.size()) {
                if (houseKeeperIndex > houseKeeperList.size() - 1) {
                    houseKeeperIndex = 0;
                }
                HouseKeeper hk = (HouseKeeper)houseKeeperList.get(houseKeeperIndex);
                ++houseKeeperIndex;
                if (hk.isSweepDue()) {
                    houseKeeper = hk;
                    break;
                }
                ++i;
            }
        }
        return houseKeeper;
    }

    protected static void sweepNow(String alias) {
        try {
            HouseKeeperController.getHouseKeeper(alias).sweep();
        }
        catch (ProxoolException e) {
            LOG.error("Couldn't run house keeper for " + alias, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void register(ConnectionPool connectionPool) {
        String alias = connectionPool.getDefinition().getAlias();
        LOG.debug("Registering '" + alias + "' house keeper");
        HouseKeeper houseKeeper = new HouseKeeper(connectionPool);
        Object object = LOCK;
        synchronized (object) {
            houseKeepers.put(alias, houseKeeper);
            houseKeeperList.add(houseKeeper);
            if (houseKeeperThreads.size() == 0) {
                HouseKeeperThread hkt = new HouseKeeperThread("HouseKeeper");
                LOG.debug("Starting a house keeper thread");
                hkt.start();
                houseKeeperThreads.add(hkt);
            }
        }
    }

    protected static void cancel(String alias) throws ProxoolException {
        HouseKeeper hk = HouseKeeperController.getHouseKeeper(alias);
        houseKeepers.remove(alias);
        houseKeeperList.remove(hk);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

