/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin.servlet;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionInfoIF;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.Version;
import org.logicalcobwebs.proxool.admin.SnapshotIF;
import org.logicalcobwebs.proxool.admin.StatisticsIF;

public class AdminServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$admin$servlet$AdminServlet == null ? (class$org$logicalcobwebs$proxool$admin$servlet$AdminServlet = AdminServlet.class$("org.logicalcobwebs.proxool.admin.servlet.AdminServlet")) : class$org$logicalcobwebs$proxool$admin$servlet$AdminServlet);
    protected static final String ACTION_LIST = "list";
    private static final String ACTION_STATS = "stats";
    protected static final String ACTION_CHART = "chart";
    protected static final String TYPE = "type";
    protected static final String TYPE_CONNECTIONS = "1";
    protected static final String TYPE_ACTIVITY_LEVEL = "2";
    private static final String STYLE_CAPTION = "text-align: right; color: #333333;";
    private static final String STYLE_DATA = "background: white;";
    private static final String STYLE_NO_DATA = "color: #666666;";
    private static final int DATE_OFFSET = 3600000;
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final String LEVEL = "level";
    private static final String LEVEL_MORE = "more";
    private static final String LEVEL_LESS = "less";
    private static final String ACTION = "action";
    private static final String ALIAS = "alias";
    private static final String CONNECTION_ID = "id";
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$admin$servlet$AdminServlet;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Pragma", "no-cache");
        String link = request.getRequestURI();
        String action = request.getParameter(ACTION);
        if (action == null) {
            action = ACTION_STATS;
        }
        String level = request.getParameter(LEVEL);
        String connectionId = request.getParameter(CONNECTION_ID);
        String alias = request.getParameter(ALIAS);
        String[] aliases = ProxoolFacade.getAliases();
        if (alias == null) {
            if (aliases.length == 1) {
                alias = aliases[0];
            } else {
                action = ACTION_LIST;
            }
        }
        if (alias != null) {
            try {
                ProxoolFacade.getConnectionPoolDefinition(alias);
            }
            catch (ProxoolException e) {
                action = ACTION_LIST;
            }
        }
        this.openHtml(response.getOutputStream());
        try {
            if (action.equals(ACTION_LIST)) {
                response.setContentType("text/html");
                this.doList(response.getOutputStream(), alias, link, level);
            } else if (action.equals(ACTION_STATS)) {
                response.setContentType("text/html");
                this.doStats(response.getOutputStream(), alias, link, level, connectionId);
            } else {
                LOG.error("Unrecognised action '" + action + "'");
            }
        }
        catch (ProxoolException e) {
            LOG.error("Problem", e);
        }
        response.getOutputStream().println("<div style=\"text-align: right; width: 550px; color: #333333;\">Proxool " + Version.getVersion() + "</div>");
        this.closeHtml(response.getOutputStream());
    }

    private void doStats(ServletOutputStream out, String alias, String link, String level, String connectionId) throws ProxoolException, IOException {
        this.doList(out, alias, link, level);
        this.doDefinition(out, alias, link);
        this.doSnapshot(out, alias, link, level, connectionId);
        this.doStatistics(out, alias, link);
    }

    private void doStatistics(ServletOutputStream out, String alias, String link) throws ProxoolException, IOException {
        StatisticsIF[] statisticsArray = ProxoolFacade.getStatistics(alias);
        ConnectionPoolDefinitionIF cpd = ProxoolFacade.getConnectionPoolDefinition(alias);
        int i = 0;
        while (i < statisticsArray.length) {
            StatisticsIF statistics = statisticsArray[i];
            out.print("<b>Statistics</b> from ");
            out.print(TIME_FORMAT.format(statistics.getStartDate()));
            out.print(" to ");
            out.print(TIME_FORMAT.format(statistics.getStopDate()));
            this.openTable(out);
            this.printDefinitionEntry(out, "Served", statistics.getServedCount() + " (" + DECIMAL_FORMAT.format(statistics.getServedPerSecond()) + "/s)");
            this.printDefinitionEntry(out, "Refused", statistics.getRefusedCount() + " (" + DECIMAL_FORMAT.format(statistics.getRefusedPerSecond()) + "/s)");
            this.printDefinitionEntry(out, "Average active time", DECIMAL_FORMAT.format(statistics.getAverageActiveTime() / 1000.0) + "s");
            StringBuffer activityLevelBuffer = new StringBuffer();
            int activityLevel = (int)(100.0 * statistics.getAverageActiveCount() / (double)cpd.getMaximumConnectionCount());
            activityLevelBuffer.append(activityLevel);
            activityLevelBuffer.append("%<br/>");
            String[] colours = new String[]{"0000ff", "eeeeee"};
            int[] lengths = new int[]{activityLevel, 100 - activityLevel};
            this.drawBarChart(activityLevelBuffer, colours, lengths);
            this.printDefinitionEntry(out, "Activity level", activityLevelBuffer.toString());
            this.closeTable(out);
            ++i;
        }
    }

    private void drawBarChart(StringBuffer out, String[] colours, int[] lengths) {
        out.append("<table style=\"margin: 8px; font-size: 50%;\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr>");
        int totalLength = 0;
        int i = 0;
        while (i < colours.length) {
            totalLength += lengths[i];
            ++i;
        }
        int j = 0;
        while (j < colours.length) {
            String colour = colours[j];
            int length = lengths[j];
            if (length > 0) {
                out.append("<td bgcolor=\"#");
                out.append(colour);
                out.append("\" width=\"");
                out.append(100 * length / totalLength);
                out.append("%\">&nbsp;</td>");
            }
            ++j;
        }
        out.append("</tr></table>");
    }

    private void doDefinition(ServletOutputStream out, String alias, String link) throws ProxoolException, IOException {
        ConnectionPoolDefinitionIF cpd = ProxoolFacade.getConnectionPoolDefinition(alias);
        out.print("<b>Defintition</b> for ");
        out.println(alias);
        this.openTable(out);
        this.printDefinitionEntry(out, "URL", cpd.getUrl());
        this.printDefinitionEntry(out, "Driver", cpd.getDriver());
        this.printDefinitionEntry(out, "Connections", cpd.getMinimumConnectionCount() + " (min), " + cpd.getMaximumConnectionCount() + " (max)");
        this.printDefinitionEntry(out, "Prototyping", cpd.getPrototypeCount() > 0 ? String.valueOf(cpd.getPrototypeCount()) : null);
        this.printDefinitionEntry(out, "Connection Lifetime", TIME_FORMAT.format(new Date(cpd.getMaximumConnectionLifetime() - 3600000)));
        this.printDefinitionEntry(out, "Maximum active time", TIME_FORMAT.format(new Date(cpd.getMaximumActiveTime() - 3600000)));
        this.printDefinitionEntry(out, "House keeping sleep time", cpd.getHouseKeepingSleepTime() / 1000 + "s");
        this.printDefinitionEntry(out, "House keeping test SQL", cpd.getHouseKeepingTestSql());
        String fatalSqlExceptions = null;
        if (cpd.getFatalSqlExceptions() != null && cpd.getFatalSqlExceptions().size() > 0) {
            StringBuffer fatalSqlExceptionsBuffer = new StringBuffer();
            Iterator i = cpd.getFatalSqlExceptions().iterator();
            while (i.hasNext()) {
                String s = (String)i.next();
                fatalSqlExceptionsBuffer.append(s);
                fatalSqlExceptionsBuffer.append(i.hasNext() ? ", " : "");
            }
            fatalSqlExceptions = fatalSqlExceptionsBuffer.toString();
        }
        this.printDefinitionEntry(out, "Fatal SQL exceptions", fatalSqlExceptions);
        this.printDefinitionEntry(out, "Statistics", cpd.getStatistics());
        this.closeTable(out);
    }

    private void doSnapshot(ServletOutputStream out, String alias, String link, String level, String connectionId) throws IOException, ProxoolException {
        boolean detail = level != null && level.equals(LEVEL_MORE);
        SnapshotIF snapshot = ProxoolFacade.getSnapshot(alias, detail);
        if (snapshot != null) {
            out.print("<b>Snapshot</b> at ");
            out.println(TIME_FORMAT.format(snapshot.getSnapshotDate()));
            this.openTable(out);
            this.printDefinitionEntry(out, "Start date", DATE_FORMAT.format(snapshot.getDateStarted()));
            StringBuffer connectionsBuffer = new StringBuffer();
            connectionsBuffer.append(snapshot.getActiveConnectionCount());
            connectionsBuffer.append(" (active), ");
            connectionsBuffer.append(snapshot.getAvailableConnectionCount());
            connectionsBuffer.append(" (available), ");
            if (snapshot.getOfflineConnectionCount() > 0) {
                connectionsBuffer.append(snapshot.getOfflineConnectionCount());
                connectionsBuffer.append(" (offline), ");
            }
            connectionsBuffer.append(snapshot.getMaximumConnectionCount());
            connectionsBuffer.append(" (max)<br/>");
            String[] colours = new String[]{"ff9999", "66cc66", "cccccc"};
            int[] lengths = new int[]{snapshot.getActiveConnectionCount(), snapshot.getAvailableConnectionCount(), snapshot.getMaximumConnectionCount() - snapshot.getActiveConnectionCount() - snapshot.getAvailableConnectionCount()};
            this.drawBarChart(connectionsBuffer, colours, lengths);
            this.printDefinitionEntry(out, "Connections", connectionsBuffer.toString());
            this.printDefinitionEntry(out, "Served", String.valueOf(snapshot.getServedCount()));
            this.printDefinitionEntry(out, "Refused", String.valueOf(snapshot.getRefusedCount()));
            if (!detail) {
                out.println("    <tr>");
                out.print("<td colspan=\"2\" align=\"right\"><a href=\"");
                out.print(link);
                out.print("?");
                out.print(ALIAS);
                out.print("=");
                out.print(alias);
                out.print("&");
                out.print(LEVEL);
                out.print("=");
                out.print(LEVEL_MORE);
                out.println("\">more information</a></td>");
                out.println("    </tr>");
            } else {
                ConnectionInfoIF drillDownConnection;
                out.println("    <tr>");
                out.print("      <td width=\"200\" valign=\"top\" style=\"text-align: right; color: #333333;\">");
                out.print("Details");
                out.println("</td>");
                out.print("      <td style=\"color: #666666;\">");
                this.doSnapshotDetails(out, alias, snapshot, link, connectionId);
                out.println("</td>");
                out.println("    </tr>");
                long drillDownConnectionId = 0L;
                if (connectionId != null && (drillDownConnection = snapshot.getConnectionInfo(drillDownConnectionId = Long.valueOf(connectionId).longValue())) != null) {
                    out.println("    <tr>");
                    out.print("      <td width=\"200\" valign=\"top\" style=\"text-align: right; color: #333333;\">");
                    out.print("Connection #" + connectionId);
                    out.println("</td>");
                    out.print("      <td style=\"color: #666666;\">");
                    this.doDrillDownConnection(out, drillDownConnection, link);
                    out.println("</td>");
                    out.println("    </tr>");
                }
                out.println("    <tr>");
                out.print("<td colspan=\"2\" align=\"right\"><a href=\"");
                out.print(link);
                out.print("?");
                out.print(ALIAS);
                out.print("=");
                out.print(alias);
                out.print("&");
                out.print(LEVEL);
                out.print("=");
                out.print(LEVEL_LESS);
                out.println("\">less information</a></td>");
                out.println("    </tr>");
            }
            this.closeTable(out);
        }
    }

    private void doSnapshotDetails(ServletOutputStream out, String alias, SnapshotIF snapshot, String link, String connectionId) throws IOException {
        long drillDownConnectionId = 0L;
        if (connectionId != null) {
            drillDownConnectionId = Long.valueOf(connectionId);
        }
        if (snapshot.getConnectionInfos() != null && snapshot.getConnectionInfos().length > 0) {
            out.println("<table cellpadding=\"2\" border=\"0\">");
            out.println("  <tbody>");
            out.print("<tr>");
            out.print("<td style=\"font-size: 90%\">#</td>");
            out.print("<td style=\"font-size: 90%\" align=\"center\">born</td>");
            out.print("<td style=\"font-size: 90%\" align=\"center\">last<br>start</td>");
            out.print("<td style=\"font-size: 90%\" align=\"center\">lap<br>(ms)</td>");
            out.print("<td style=\"font-size: 90%\" width=\"90%\">&nbsp;thread</td>");
            out.print("</tr>");
            ConnectionInfoIF[] connectionInfos = snapshot.getConnectionInfos();
            int i = 0;
            while (i < connectionInfos.length) {
                ConnectionInfoIF connectionInfo = connectionInfos[i];
                if (connectionInfo.getStatus() != 0) {
                    out.print("<tr>");
                    out.print("<td bgcolor=\"#");
                    if (connectionInfo.getStatus() == 2) {
                        out.print("ffcccc");
                    } else if (connectionInfo.getStatus() == 1) {
                        out.print("ccffcc");
                    } else if (connectionInfo.getStatus() == 3) {
                        out.print("ccccff");
                    }
                    out.print("\" style=\"");
                    if (drillDownConnectionId == connectionInfo.getId()) {
                        out.print("border: 1px solid black;");
                        out.print("\">");
                        out.print(connectionInfo.getId());
                    } else {
                        out.print("border: 1px solid transparent;");
                        out.print("\"><a href=\"");
                        out.print(link);
                        out.print("?");
                        out.print(ALIAS);
                        out.print("=");
                        out.print(alias);
                        out.print("&");
                        out.print(LEVEL);
                        out.print("=");
                        out.print(LEVEL_MORE);
                        out.print("&");
                        out.print(CONNECTION_ID);
                        out.print("=");
                        out.print(connectionInfo.getId());
                        out.print("\">");
                        out.print(connectionInfo.getId());
                        out.print("</a>");
                    }
                    out.print("</td>");
                    out.print("<td>&nbsp;");
                    out.print(TIME_FORMAT.format(connectionInfo.getBirthDate()));
                    out.print("</td>");
                    out.print("<td>&nbsp;");
                    out.print(connectionInfo.getTimeLastStartActive() > 0L ? TIME_FORMAT.format(new Date(connectionInfo.getTimeLastStartActive())) : "-");
                    out.print("</td>");
                    out.print("<td align=\"right\">");
                    if (connectionInfo.getTimeLastStopActive() > 0L) {
                        out.print((int)(connectionInfo.getTimeLastStopActive() - connectionInfo.getTimeLastStartActive()));
                    } else if (connectionInfo.getTimeLastStartActive() > 0L) {
                        out.print("<font color=\"red\">");
                        out.print((int)(snapshot.getSnapshotDate().getTime() - connectionInfo.getTimeLastStartActive()));
                        out.print("</font>");
                    } else {
                        out.print("&nbsp;");
                    }
                    out.print("&nbsp;&nbsp;</td>");
                    out.print("<td>&nbsp;");
                    out.print(connectionInfo.getRequester() != null ? connectionInfo.getRequester() : "-");
                    out.print("</td>");
                    out.println("</tr>");
                }
                ++i;
            }
            out.println("  </tbody>");
            out.println("</table>");
        } else {
            out.println("No connections yet");
        }
    }

    private void doDrillDownConnection(ServletOutputStream out, ConnectionInfoIF drillDownConnection, String link) throws IOException {
        out.print("<div style=\"font-size: 90%\">");
        out.print("proxy = ");
        out.print(drillDownConnection.getProxyHashcode());
        out.print("</div>");
        out.print("<div style=\"font-size: 90%\">");
        out.print("delegate = ");
        out.print(drillDownConnection.getDelegateHashcode());
        out.print("</div>");
        out.print("<div style=\"font-size: 90%\">");
        out.print("url = ");
        out.print(drillDownConnection.getDelegateUrl());
        out.print("</div>");
    }

    private void openHtml(ServletOutputStream out) throws IOException {
        out.println("<html><header><title>Proxool Admin</title></header><body BGCOLOR=\"#eeeeee\">");
    }

    private void closeHtml(ServletOutputStream out) throws IOException {
        out.println("</body></html>");
    }

    private void openTable(ServletOutputStream out) throws IOException {
        out.println("<table width=\"550\" cellpadding=\"2\" cellspacing=\"2\" border=\"0\" bgcolor=\"#EEEEEE\" style=\"border: 1px solid black\">");
        out.println("  <tbody>");
    }

    private void closeTable(ServletOutputStream out) throws IOException {
        out.println("  </tbody>");
        out.println("</table>");
        out.println("<br/>");
    }

    private void printDefinitionEntry(ServletOutputStream out, String name, String value) throws IOException {
        out.println("    <tr>");
        out.print("      <td width=\"200\" valign=\"top\" style=\"text-align: right; color: #333333;\">");
        out.print(name);
        out.println("</td>");
        if (value != null) {
            out.print("      <td style=\"background: white;\">");
            out.print(value);
        } else {
            out.print("      <td style=\"color: #666666;\">off");
        }
        out.print("</td>");
        out.println("    </tr>");
    }

    private void doList(ServletOutputStream out, String alias, String link, String level) throws IOException, ProxoolException {
        out.print("<b>Pools</b>");
        this.openTable(out);
        String[] aliases = ProxoolFacade.getAliases();
        int i = 0;
        while (i < aliases.length) {
            String a = aliases[i];
            String style = "";
            if (a.equals(alias)) {
                style = STYLE_DATA;
            }
            ConnectionPoolDefinitionIF cpd = ProxoolFacade.getConnectionPoolDefinition(a);
            out.println("    <tr style=\"" + style + "\">");
            out.print("      <td width=\"200\" style=\"text-align: right; color: #333333;\">");
            out.print(a.equals(alias) ? ">" : "&nbsp;");
            out.println("</td>");
            out.print("      <td><a href=\"" + link + "?" + ALIAS + "=" + a + "&" + LEVEL + "=" + level + "\">");
            out.print(a);
            out.println("</a> -> ");
            out.print(cpd.getUrl());
            out.println("</td>");
            out.println("    </tr>");
            ++i;
        }
        this.closeTable(out);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

