/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;

public class ClassReader {
    private final byte[] b;
    private int[] items;
    private String[] strings;
    private char[] buf;
    private int header;
    static final int NOARG_INSN = 0;
    static final int SBYTE_INSN = 1;
    static final int SHORT_INSN = 2;
    static final int VAR_INSN = 3;
    static final int IMPLVAR_INSN = 4;
    static final int TYPE_INSN = 5;
    static final int FIELDORMETH_INSN = 6;
    static final int ITFMETH_INSN = 7;
    static final int LABEL_INSN = 8;
    static final int LABELW_INSN = 9;
    static final int LDC_INSN = 10;
    static final int LDCW_INSN = 11;
    static final int IINC_INSN = 12;
    static final int TABL_INSN = 13;
    static final int LOOK_INSN = 14;
    static final int MANA_INSN = 15;
    static final int WIDE_INSN = 16;
    static byte[] TYPE;

    public ClassReader(byte[] byArray) {
        this.b = byArray;
        this.items = new int[this.readUnsignedShort(8)];
        this.strings = new String[this.items.length];
        int n = 0;
        int n2 = 10;
        int n3 = 1;
        while (n3 < this.items.length) {
            int n4;
            this.items[n3] = n2 + 1;
            byte by = byArray[n2];
            switch (by) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n4 = 5;
                    break;
                }
                case 5: 
                case 6: {
                    n4 = 9;
                    ++n3;
                    break;
                }
                case 1: {
                    n4 = 3 + this.readUnsignedShort(n2 + 1);
                    n = n4 > n ? n4 : n;
                    break;
                }
                default: {
                    n4 = 3;
                }
            }
            n2 += n4;
            ++n3;
        }
        this.buf = new char[n];
        this.header = n2;
    }

    public ClassReader(InputStream inputStream) throws IOException {
        this(ClassReader.readClass(inputStream));
    }

    public ClassReader(String string) throws IOException {
        this(ClassLoader.getSystemResourceAsStream(string.replace('.', '/') + ".class"));
    }

    private static byte[] readClass(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Class not found");
        }
        byte[] byArray = new byte[inputStream.available()];
        int n = 0;
        while (true) {
            byte[] byArray2;
            int n2;
            if ((n2 = inputStream.read(byArray, n, byArray.length - n)) == -1) {
                if (n < byArray.length) {
                    byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    byArray = byArray2;
                }
                return byArray;
            }
            if ((n += n2) != byArray.length) continue;
            byArray2 = new byte[byArray.length + 1000];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
    }

    public void accept(ClassVisitor classVisitor, boolean bl) {
        Object object;
        String string;
        String string2;
        int n;
        byte[] byArray = this.b;
        int n2 = this.header;
        int n3 = this.readUnsignedShort(n2);
        String string3 = this.readClass(n2 + 2);
        int n4 = this.items[this.readUnsignedShort(n2 + 4)];
        String string4 = n4 == 0 ? null : this.readUTF8(n4);
        String[] stringArray = new String[this.readUnsignedShort(n2 + 6)];
        String string5 = null;
        int n5 = 0;
        n2 += 8;
        int n6 = 0;
        while (n6 < stringArray.length) {
            stringArray[n6] = this.readClass(n2);
            n2 += 2;
            ++n6;
        }
        n4 = n2;
        n6 = this.readUnsignedShort(n4);
        n4 += 2;
        while (n6 > 0) {
            n = this.readUnsignedShort(n4 + 6);
            n4 += 8;
            while (n > 0) {
                n4 += 6 + this.readInt(n4 + 2);
                --n;
            }
            --n6;
        }
        n6 = this.readUnsignedShort(n4);
        n4 += 2;
        while (n6 > 0) {
            n = this.readUnsignedShort(n4 + 6);
            n4 += 8;
            while (n > 0) {
                n4 += 6 + this.readInt(n4 + 2);
                --n;
            }
            --n6;
        }
        n6 = this.readUnsignedShort(n4);
        n4 += 2;
        while (n6 > 0) {
            string2 = this.readUTF8(n4);
            if (string2.equals("SourceFile")) {
                string5 = this.readUTF8(n4 + 6);
            } else if (string2.equals("Deprecated")) {
                n3 |= 0x20000;
            } else if (string2.equals("InnerClasses")) {
                n5 = n4 + 6;
            }
            n4 += 6 + this.readInt(n4 + 2);
            --n6;
        }
        classVisitor.visit(n3, string3, string4, stringArray, string5);
        if (n5 != 0) {
            n6 = this.readUnsignedShort(n5);
            n5 += 2;
            while (n6 > 0) {
                classVisitor.visitInnerClass(this.readUnsignedShort(n5) == 0 ? null : this.readClass(n5), this.readUnsignedShort(n5 + 2) == 0 ? null : this.readClass(n5 + 2), this.readUnsignedShort(n5 + 4) == 0 ? null : this.readUTF8(n5 + 4), this.readUnsignedShort(n5 + 6));
                n5 += 8;
                --n6;
            }
        }
        n6 = this.readUnsignedShort(n2);
        n2 += 2;
        while (n6 > 0) {
            n3 = this.readUnsignedShort(n2);
            string2 = this.readUTF8(n2 + 2);
            string = this.readUTF8(n2 + 4);
            int n7 = 0;
            n = this.readUnsignedShort(n2 + 6);
            n2 += 8;
            while (n > 0) {
                object = this.readUTF8(n2);
                if (((String)object).equals("ConstantValue")) {
                    n7 = this.readUnsignedShort(n2 + 6);
                } else if (((String)object).equals("Synthetic")) {
                    n3 |= 0x10000;
                } else if (((String)object).equals("Deprecated")) {
                    n3 |= 0x20000;
                }
                n2 += 6 + this.readInt(n2 + 2);
                --n;
            }
            object = n7 == 0 ? null : this.readConst(n7);
            classVisitor.visitField(n3, string2, string, object);
            --n6;
        }
        n6 = this.readUnsignedShort(n2);
        n2 += 2;
        while (n6 > 0) {
            String[] stringArray2;
            n3 = this.readUnsignedShort(n2);
            string2 = this.readUTF8(n2 + 2);
            string = this.readUTF8(n2 + 4);
            n = this.readUnsignedShort(n2 + 6);
            n2 += 8;
            n4 = 0;
            n5 = 0;
            while (n > 0) {
                String string6 = this.readUTF8(n2);
                int n8 = this.readInt(n2 += 2);
                n2 += 4;
                if (string6.equals("Code")) {
                    n4 = n2;
                } else if (string6.equals("Exceptions")) {
                    n5 = n2;
                } else if (string6.equals("Synthetic")) {
                    n3 |= 0x10000;
                } else if (string6.equals("Deprecated")) {
                    n3 |= 0x20000;
                }
                n2 += n8;
                --n;
            }
            if (n5 == 0) {
                stringArray2 = null;
            } else {
                stringArray2 = new String[this.readUnsignedShort(n5)];
                n5 += 2;
                n = 0;
                while (n < stringArray2.length) {
                    stringArray2[n] = this.readClass(n5);
                    n5 += 2;
                    ++n;
                }
            }
            object = classVisitor.visitMethod(n3, string2, string, stringArray2);
            if (object != null && n4 != 0) {
                int n9;
                int n10;
                int n11 = this.readUnsignedShort(n4);
                int n12 = this.readUnsignedShort(n4 + 2);
                int n13 = this.readInt(n4 + 4);
                int n14 = n4 += 8;
                int n15 = n4 + n13;
                Label[] labelArray = new Label[n13 + 1];
                block40: while (n4 < n15) {
                    int n16 = byArray[n4] & 0xFF;
                    switch (TYPE[n16]) {
                        case 0: 
                        case 4: {
                            ++n4;
                            break;
                        }
                        case 8: {
                            n10 = n4 - n14 + this.readShort(n4 + 1);
                            if (labelArray[n10] == null) {
                                labelArray[n10] = new Label();
                            }
                            n4 += 3;
                            break;
                        }
                        case 9: {
                            n10 = n4 - n14 + this.readInt(n4 + 1);
                            if (labelArray[n10] == null) {
                                labelArray[n10] = new Label();
                            }
                            n4 += 5;
                            break;
                        }
                        case 16: {
                            n16 = byArray[n4 + 1] & 0xFF;
                            if (n16 == 132) {
                                n4 += 6;
                                break;
                            }
                            n4 += 4;
                            break;
                        }
                        case 13: {
                            n5 = n4 - n14;
                            n4 = n4 + 4 - (n5 & 3);
                            n10 = n5 + this.readInt(n4);
                            n4 += 4;
                            if (labelArray[n10] == null) {
                                labelArray[n10] = new Label();
                            }
                            n = this.readInt(n4);
                            n = this.readInt(n4 += 4) - n + 1;
                            n4 += 4;
                            while (n > 0) {
                                n10 = n5 + this.readInt(n4);
                                n4 += 4;
                                if (labelArray[n10] == null) {
                                    labelArray[n10] = new Label();
                                }
                                --n;
                            }
                            continue block40;
                        }
                        case 14: {
                            n5 = n4 - n14;
                            n4 = n4 + 4 - (n5 & 3);
                            n10 = n5 + this.readInt(n4);
                            n4 += 4;
                            if (labelArray[n10] == null) {
                                labelArray[n10] = new Label();
                            }
                            n = this.readInt(n4);
                            n4 += 4;
                            while (n > 0) {
                                n10 = n5 + this.readInt(n4 += 4);
                                n4 += 4;
                                if (labelArray[n10] == null) {
                                    labelArray[n10] = new Label();
                                }
                                --n;
                            }
                            continue block40;
                        }
                        case 1: 
                        case 3: 
                        case 10: {
                            n4 += 2;
                            break;
                        }
                        case 2: 
                        case 5: 
                        case 6: 
                        case 11: 
                        case 12: {
                            n4 += 3;
                            break;
                        }
                        case 7: {
                            n4 += 5;
                            break;
                        }
                        default: {
                            n4 += 4;
                        }
                    }
                }
                n = this.readUnsignedShort(n4);
                n4 += 2;
                while (n > 0) {
                    n10 = this.readUnsignedShort(n4);
                    if (labelArray[n10] == null) {
                        labelArray[n10] = new Label();
                    }
                    if (labelArray[n10 = this.readUnsignedShort(n4 + 2)] == null) {
                        labelArray[n10] = new Label();
                    }
                    if (labelArray[n10 = this.readUnsignedShort(n4 + 4)] == null) {
                        labelArray[n10] = new Label();
                    }
                    n4 += 8;
                    --n;
                }
                if (!bl) {
                    n = this.readUnsignedShort(n4);
                    n4 += 2;
                    while (n > 0) {
                        String string7 = this.readUTF8(n4);
                        if (string7.equals("LocalVariableTable")) {
                            n9 = this.readUnsignedShort(n4 + 6);
                            n5 = n4 + 8;
                            while (n9 > 0) {
                                n10 = this.readUnsignedShort(n5);
                                if (labelArray[n10] == null) {
                                    labelArray[n10] = new Label();
                                }
                                if (labelArray[n10 += this.readUnsignedShort(n5 + 2)] == null) {
                                    labelArray[n10] = new Label();
                                }
                                n5 += 10;
                                --n9;
                            }
                        } else if (string7.equals("LineNumberTable")) {
                            n9 = this.readUnsignedShort(n4 + 6);
                            n5 = n4 + 8;
                            while (n9 > 0) {
                                n10 = this.readUnsignedShort(n5);
                                if (labelArray[n10] == null) {
                                    labelArray[n10] = new Label();
                                }
                                n5 += 4;
                                --n9;
                            }
                        }
                        n4 += 6 + this.readInt(n4 + 2);
                        --n;
                    }
                }
                n4 = n14;
                while (n4 < n15) {
                    n5 = n4 - n14;
                    Label label = labelArray[n5];
                    if (label != null) {
                        object.visitLabel(label);
                    }
                    int n17 = byArray[n4] & 0xFF;
                    switch (TYPE[n17]) {
                        case 0: {
                            object.visitInsn(n17);
                            ++n4;
                            break;
                        }
                        case 4: {
                            if (n17 > 54) {
                                object.visitVarInsn(54 + ((n17 -= 59) >> 2), n17 & 3);
                            } else {
                                object.visitVarInsn(21 + ((n17 -= 26) >> 2), n17 & 3);
                            }
                            ++n4;
                            break;
                        }
                        case 8: {
                            object.visitJumpInsn(n17, labelArray[n5 + this.readShort(n4 + 1)]);
                            n4 += 3;
                            break;
                        }
                        case 9: {
                            object.visitJumpInsn(n17, labelArray[n5 + this.readInt(n4 + 1)]);
                            n4 += 5;
                            break;
                        }
                        case 16: {
                            n17 = byArray[n4 + 1] & 0xFF;
                            if (n17 == 132) {
                                object.visitIincInsn(this.readUnsignedShort(n4 + 2), this.readShort(n4 + 4));
                                n4 += 6;
                                break;
                            }
                            object.visitVarInsn(n17, this.readUnsignedShort(n4 + 2));
                            n4 += 4;
                            break;
                        }
                        case 13: {
                            n4 = n4 + 4 - (n5 & 3);
                            n10 = n5 + this.readInt(n4);
                            int n18 = this.readInt(n4 += 4);
                            int n19 = this.readInt(n4 += 4);
                            n4 += 4;
                            Label[] labelArray2 = new Label[n19 - n18 + 1];
                            n = 0;
                            while (n < labelArray2.length) {
                                labelArray2[n] = labelArray[n5 + this.readInt(n4)];
                                n4 += 4;
                                ++n;
                            }
                            object.visitTableSwitchInsn(n18, n19, labelArray[n10], labelArray2);
                            break;
                        }
                        case 14: {
                            n4 = n4 + 4 - (n5 & 3);
                            n10 = n5 + this.readInt(n4);
                            n = this.readInt(n4 += 4);
                            n4 += 4;
                            int[] nArray = new int[n];
                            Label[] labelArray3 = new Label[n];
                            n = 0;
                            while (n < nArray.length) {
                                nArray[n] = this.readInt(n4);
                                labelArray3[n] = labelArray[n5 + this.readInt(n4 += 4)];
                                n4 += 4;
                                ++n;
                            }
                            object.visitLookupSwitchInsn(labelArray[n10], nArray, labelArray3);
                            break;
                        }
                        case 3: {
                            object.visitVarInsn(n17, byArray[n4 + 1] & 0xFF);
                            n4 += 2;
                            break;
                        }
                        case 1: {
                            object.visitIntInsn(n17, byArray[n4 + 1]);
                            n4 += 2;
                            break;
                        }
                        case 2: {
                            object.visitIntInsn(n17, this.readShort(n4 + 1));
                            n4 += 3;
                            break;
                        }
                        case 10: {
                            object.visitLdcInsn(this.readConst(byArray[n4 + 1] & 0xFF));
                            n4 += 2;
                            break;
                        }
                        case 11: {
                            object.visitLdcInsn(this.readConst(this.readUnsignedShort(n4 + 1)));
                            n4 += 3;
                            break;
                        }
                        case 6: 
                        case 7: {
                            int n20 = this.items[this.readUnsignedShort(n4 + 1)];
                            String string8 = this.readClass(n20);
                            n20 = this.items[this.readUnsignedShort(n20 + 2)];
                            String string9 = this.readUTF8(n20);
                            String string10 = this.readUTF8(n20 + 2);
                            if (n17 < 182) {
                                object.visitFieldInsn(n17, string8, string9, string10);
                            } else {
                                object.visitMethodInsn(n17, string8, string9, string10);
                            }
                            if (n17 == 185) {
                                n4 += 5;
                                break;
                            }
                            n4 += 3;
                            break;
                        }
                        case 5: {
                            object.visitTypeInsn(n17, this.readClass(n4 + 1));
                            n4 += 3;
                            break;
                        }
                        case 12: {
                            object.visitIincInsn(byArray[n4 + 1] & 0xFF, byArray[n4 + 2]);
                            n4 += 3;
                            break;
                        }
                        default: {
                            object.visitMultiANewArrayInsn(this.readClass(n4 + 1), byArray[n4 + 3] & 0xFF);
                            n4 += 4;
                        }
                    }
                }
                Label label = labelArray[n15 - n14];
                if (label != null) {
                    object.visitLabel(label);
                }
                n = this.readUnsignedShort(n4);
                n4 += 2;
                while (n > 0) {
                    Label label2 = labelArray[this.readUnsignedShort(n4)];
                    Label label3 = labelArray[this.readUnsignedShort(n4 + 2)];
                    Label label4 = labelArray[this.readUnsignedShort(n4 + 4)];
                    int n21 = this.readUnsignedShort(n4 + 6);
                    if (n21 == 0) {
                        object.visitTryCatchBlock(label2, label3, label4, null);
                    } else {
                        object.visitTryCatchBlock(label2, label3, label4, this.readUTF8(this.items[n21]));
                    }
                    n4 += 8;
                    --n;
                }
                if (!bl) {
                    n = this.readUnsignedShort(n4);
                    n4 += 2;
                    while (n > 0) {
                        String string11 = this.readUTF8(n4);
                        if (string11.equals("LocalVariableTable")) {
                            n9 = this.readUnsignedShort(n4 + 6);
                            n5 = n4 + 8;
                            while (n9 > 0) {
                                n10 = this.readUnsignedShort(n5);
                                Label label5 = labelArray[n10];
                                Label label6 = labelArray[n10 += this.readUnsignedShort(n5 + 2)];
                                object.visitLocalVariable(this.readUTF8(n5 + 4), this.readUTF8(n5 + 6), label5, label6, this.readUnsignedShort(n5 + 8));
                                n5 += 10;
                                --n9;
                            }
                        } else if (string11.equals("LineNumberTable")) {
                            n9 = this.readUnsignedShort(n4 + 6);
                            n5 = n4 + 8;
                            while (n9 > 0) {
                                object.visitLineNumber(this.readUnsignedShort(n5 + 2), labelArray[this.readUnsignedShort(n5)]);
                                n5 += 4;
                                --n9;
                            }
                        }
                        n4 += 6 + this.readInt(n4 + 2);
                        --n;
                    }
                }
                object.visitMaxs(n11, n12);
            }
            --n6;
        }
        classVisitor.visitEnd();
    }

    private int readUnsignedShort(int n) {
        byte[] byArray = this.b;
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private short readShort(int n) {
        byte[] byArray = this.b;
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    private int readInt(int n) {
        byte[] byArray = this.b;
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private long readLong(int n) {
        long l = this.readInt(n);
        long l2 = (long)this.readInt(n + 4) & 0xFFFFFFFFL;
        return l << 32 | l2;
    }

    private String readUTF8(int n) {
        int n2 = this.readUnsignedShort(n);
        String string = this.strings[n2];
        if (string != null) {
            return string;
        }
        n = this.items[n2];
        int n3 = this.readUnsignedShort(n);
        int n4 = (n += 2) + n3;
        byte[] byArray = this.b;
        int n5 = 0;
        while (n < n4) {
            int n6 = byArray[n++] & 0xFF;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.buf[n5++] = (char)n6;
                    break;
                }
                case 12: 
                case 13: {
                    byte by = byArray[n++];
                    this.buf[n5++] = (char)((n6 & 0x1F) << 6 | by & 0x3F);
                    break;
                }
                default: {
                    byte by = byArray[n++];
                    byte by2 = byArray[n++];
                    this.buf[n5++] = (char)((n6 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                }
            }
        }
        this.strings[n2] = string = new String(this.buf, 0, n5);
        return string;
    }

    private String readClass(int n) {
        return this.readUTF8(this.items[this.readUnsignedShort(n)]);
    }

    private Object readConst(int n) {
        int n2 = this.items[n];
        switch (this.b[n2 - 1]) {
            case 3: {
                return new Integer(this.readInt(n2));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(n2)));
            }
            case 5: {
                return new Long(this.readLong(n2));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(n2)));
            }
        }
        return this.readUTF8(n2);
    }

    static {
        byte[] byArray = new byte[220];
        String string = "AAAAAAAAAAAAAAAABCKLLDDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAADDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAIIIIIIIIIIIIIIIIDNOAAAAAAGGGGGGGHAFBFAAFFAAQPIIJJIIIIIIIIIIIIIIIIII";
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(string.charAt(n) - 65);
            ++n;
        }
        TYPE = byArray;
    }
}

