/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.locking;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReadWriteLock {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$utils$locking$ReadWriteLock == null ? (class$org$apache$jcs$utils$locking$ReadWriteLock = ReadWriteLock.class$("org.apache.jcs.utils.locking.ReadWriteLock")) : class$org$apache$jcs$utils$locking$ReadWriteLock));
    private int waitingForReadLock = 0;
    private int outstandingReadLocks = 0;
    private Thread writeLockedThread;
    private int outstandingWriteLocks = 0;
    private ArrayList waitingForWriteLock = new ArrayList();
    static /* synthetic */ Class class$org$apache$jcs$utils$locking$ReadWriteLock;

    public synchronized void readLock() throws InterruptedException {
        ++this.waitingForReadLock;
        while (this.writeLockedThread != null) {
            log.debug((Object)"readLock wait");
            this.wait();
            log.debug((Object)"wake up from readLock wait");
        }
        log.debug((Object)"readLock acquired");
        --this.waitingForReadLock;
        ++this.outstandingReadLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLock() throws InterruptedException {
        Thread thisThread = Thread.currentThread();
        ReadWriteLock readWriteLock = this;
        synchronized (readWriteLock) {
            if (this.writeLockedThread == null && this.outstandingReadLocks == 0) {
                this.writeLockedThread = Thread.currentThread();
                ++this.outstandingWriteLocks;
                log.debug((Object)"writeLock acquired without waiting");
                return;
            }
            if (this.writeLockedThread == thisThread) {
                ++this.outstandingWriteLocks;
            }
            this.waitingForWriteLock.add(thisThread);
        }
        Thread thread = thisThread;
        synchronized (thread) {
            while (thisThread != this.writeLockedThread) {
                log.debug((Object)"writeLock wait");
                thisThread.wait(2000L);
                log.debug((Object)"wake up from writeLock wait");
            }
            log.debug((Object)"writeLock acquired");
        }
        ReadWriteLock readWriteLock2 = this;
        synchronized (readWriteLock2) {
            int i = this.waitingForWriteLock.indexOf(thisThread);
            this.waitingForWriteLock.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void done() {
        if (this.outstandingReadLocks > 0) {
            --this.outstandingReadLocks;
            if (this.outstandingReadLocks == 0 && this.waitingForWriteLock.size() > 0) {
                this.writeLockedThread = (Thread)this.waitingForWriteLock.get(0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("readLock released and before notifying a write lock waiting thread " + this.writeLockedThread));
                }
                Thread thread = this.writeLockedThread;
                synchronized (thread) {
                    this.writeLockedThread.notifyAll();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("readLock released and after  notifying a write lock waiting thread " + this.writeLockedThread));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"readLock released without fuss");
            }
            return;
        }
        if (Thread.currentThread() == this.writeLockedThread) {
            --this.outstandingWriteLocks;
            if (this.outstandingWriteLocks > 0) {
                log.debug((Object)"writeLock released for a nested writeLock request.");
                return;
            }
            if (this.outstandingReadLocks == 0 && this.waitingForWriteLock.size() > 0) {
                this.writeLockedThread = (Thread)this.waitingForWriteLock.get(0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("writeLock released and before notifying a write lock waiting thread " + this.writeLockedThread));
                }
                Thread thread = this.writeLockedThread;
                synchronized (thread) {
                    this.writeLockedThread.notifyAll();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("writeLock released and after notifying a write lock waiting thread " + this.writeLockedThread));
                }
            } else {
                this.writeLockedThread = null;
                if (this.waitingForReadLock > 0) {
                    log.debug((Object)"writeLock released, notified waiting readers");
                    this.notifyAll();
                } else {
                    log.debug((Object)"writeLock released, no readers waiting");
                }
            }
            return;
        }
        throw new IllegalStateException("Thread does not have lock");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

