/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import middlegen.Middlegen;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class PluginFinder {
    PluginFinder() {
    }

    public static void registerPlugins(Middlegen middlegen, String classpath) {
        Collection pluginFiles = PluginFinder.findPluginFiles(classpath);
        Iterator pluginFileIterator = pluginFiles.iterator();
        while (pluginFileIterator.hasNext()) {
            File file = (File)pluginFileIterator.next();
            try {
                InputStream deploymentDescriptor = null;
                if (file.isDirectory()) {
                    deploymentDescriptor = new FileInputStream(new File(file, "META-INF" + File.separator + "middlegen-plugin.xml"));
                } else {
                    JarFile jar = new JarFile(file);
                    JarEntry middlegenPluginXml = jar.getJarEntry("META-INF/middlegen-plugin.xml");
                    if (middlegenPluginXml != null) {
                        deploymentDescriptor = jar.getInputStream(middlegenPluginXml);
                    }
                }
                if (deploymentDescriptor == null) continue;
                PluginFinder.parse(deploymentDescriptor, middlegen);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error looking for plugins:" + e.getMessage());
            }
        }
    }

    private static void parse(InputStream deploymentDescriptor, Middlegen middlegen) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(deploymentDescriptor, (DefaultHandler)new Handler(middlegen));
            deploymentDescriptor.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Error reading META-INF/midldegen-plugin.xml" + Middlegen.BUGREPORT);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IllegalStateException("Error reading META-INF/midldegen-plugin.xml" + Middlegen.BUGREPORT);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IllegalStateException("Error reading META-INF/midldegen-plugin.xml" + Middlegen.BUGREPORT);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IllegalStateException("Error reading META-INF/midldegen-plugin.xml" + Middlegen.BUGREPORT);
        }
    }

    private static Collection findPluginFiles(String classpath) {
        if (classpath == null) {
            throw new IllegalStateException("classpath can't be null");
        }
        ArrayList<File> result = new ArrayList<File>();
        StringTokenizer pathTokenizer = new StringTokenizer(classpath, System.getProperty("path.separator"));
        while (pathTokenizer.hasMoreTokens()) {
            File file = new File(pathTokenizer.nextToken());
            if (file.isDirectory()) {
                if (!new File(file, "META-INF" + File.separator + "middlegen-plugin.xml").exists()) continue;
                result.add(file);
                continue;
            }
            if (!file.getName().endsWith(".jar")) continue;
            result.add(file);
        }
        return result;
    }

    private static class Handler
    extends DefaultHandler {
        private final Middlegen _middlegen;

        public Handler(Middlegen middlegen) {
            this._middlegen = middlegen;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
            if (qName.equals("plugin")) {
                String pluginClassName = attributes.getValue("class-name");
                if (pluginClassName == null) {
                    throw new IllegalStateException("Missing class-name attribute in middlegen-plugin.xml");
                }
                String pluginName = attributes.getValue("name");
                if (pluginName == null) {
                    throw new IllegalStateException("Missing name attribute in middlegen-plugin.xml");
                }
                try {
                    Class<?> pluginClass = Class.forName(pluginClassName);
                    this._middlegen.registerPlugin(pluginName, pluginClass);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Couldn't instantiate " + pluginClassName + ".");
                }
            }
        }
    }
}

