/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import middlegen.Plugin;
import middlegen.Prefs;

public abstract class PreferenceAware {
    private Plugin _plugin;
    private String _prefsPath;

    public void setPlugin(Plugin plugin) {
        this._plugin = plugin;
    }

    protected void setPrefsValue(String attributeName, String value) {
        try {
            Prefs.getInstance().set(this.prefsPath(), attributeName, value);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    protected Plugin getPlugin() {
        return this._plugin;
    }

    protected String getPrefsValue(String attributeName) {
        String value = null;
        try {
            value = Prefs.getInstance().get(this.prefsPath(), attributeName);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return value;
    }

    protected abstract String prefsPrefix();

    protected void init() {
        this._prefsPath = this.prefsPrefix();
    }

    protected final String prefsPath() {
        if (this._prefsPath == null) {
            throw new IllegalStateException("init hasn't been called yet!");
        }
        return this._prefsPath;
    }
}

