/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.text.MessageFormat;
import middlegen.Column;
import middlegen.ColumnMap;
import middlegen.Middlegen;
import middlegen.Plugin;
import middlegen.PreferenceAware;
import middlegen.Relation;
import middlegen.Table;
import middlegen.Util;
import middlegen.predicates.column.PrimaryKey;
import org.apache.log4j.Category;

public class RelationshipRole
extends PreferenceAware {
    private Relation _relation;
    private RelationshipRole _targetRole;
    private final Table _origin;
    private final Table _target;
    private boolean _isEnabled;
    private boolean _isTargetMany;
    private final String _suffix;
    private ColumnMap[] _columnMaps;
    private boolean _isFkPk;
    private String _namePattern;
    private static Category _log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.RelationshipRole");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public RelationshipRole(Table origin, Table target, ColumnMap[] columnMaps, Relation relation, String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("suffix can't be null!" + Middlegen.BUGREPORT);
        }
        if (relation == null) {
            throw new IllegalArgumentException("relation can't be null!" + Middlegen.BUGREPORT);
        }
        this._origin = origin;
        this._target = target;
        this._columnMaps = columnMaps;
        this._relation = relation;
        this._suffix = suffix;
        this._namePattern = this.getOrigin() == this.getTarget() ? (this.getRelation().getLeftRole() == null ? "{0}-1-has-{1}-2" + this._suffix : "{0}-2-has-{1}-1" + this._suffix) : "{0}-has-{1}" + this._suffix;
        this.init();
        if (relation.getJoinTable() == null) {
            if (columnMaps.length != 0) {
                int fkSidePkCount;
                int pkSidePkCount = this._origin.getColumns(PrimaryKey.getInstance()).size();
                if (pkSidePkCount != this._columnMaps.length) {
                    _log.warn((Object)("WARNING: The " + this._origin.getSqlName() + " table's primary key consists of " + pkSidePkCount + " columns, but one of the relationships uses " + this._columnMaps.length + " foreign keys. That is not a well-defined relationships, as all columns in a primary key " + "(and only primary key columns) should be referenced by a foreign key (all columns in the foreign key)."));
                }
                if ((fkSidePkCount = this._target.getColumns(PrimaryKey.getInstance()).size()) != this._columnMaps.length) {
                    this._isFkPk = false;
                } else {
                    this._isFkPk = true;
                    int i = 0;
                    while (i < this._columnMaps.length) {
                        Column fkColumn = this._target.getColumn(this._columnMaps[i].getForeignKey());
                        if (!fkColumn.isPk()) {
                            this._isFkPk = false;
                            break;
                        }
                        ++i;
                    }
                }
                String targetManyString = this.getPrefsValue("target-many");
                if (targetManyString != null) {
                    this.setTargetMany(Util.bool(targetManyString));
                } else {
                    this.setTargetMany(!this._isFkPk);
                }
            } else {
                this.setTargetMany(false);
            }
        } else {
            this.setTargetMany(true);
        }
        String enabledString = this.getPrefsValue("enabled");
        if (enabledString != null) {
            this.setEnabled(Util.bool(enabledString));
        } else {
            this.setEnabled(true);
        }
    }

    public void setEnabled(boolean flag) {
        this.setPrefsValue("enabled", Util.string(flag));
        this._isEnabled = flag;
    }

    public void setTargetMany(boolean flag) {
        this.setPrefsValue("target-many", Util.string(flag));
        this._isTargetMany = flag;
    }

    public boolean isFkPk() {
        return this._isFkPk;
    }

    public String getSuffix() {
        return this._suffix;
    }

    public String getName(Plugin plugin) {
        String originName = plugin.getRelationName(this._origin);
        String targetName = plugin.getRelationName(this._target);
        String name = MessageFormat.format(this._namePattern, originName, targetName);
        return name;
    }

    public String getName() {
        String name = MessageFormat.format(this._namePattern, this._origin.getSqlName(), this._target.getSqlName());
        return name;
    }

    public RelationshipRole getTargetRole() {
        return this._targetRole;
    }

    public boolean isEnabled() {
        return this._isEnabled && this.getRelation().isBothTablesGenerate();
    }

    public boolean isOriginMany() {
        return this.getTargetRole().isTargetMany();
    }

    public boolean isTargetMany() {
        return this._isTargetMany;
    }

    public boolean isOriginPrimaryKey() {
        return this.getColumnMaps().length != 0;
    }

    public boolean isTargetPrimaryKey() {
        return this.getTargetRole().getColumnMaps().length != 0;
    }

    public ColumnMap[] getColumnMaps() {
        return this._columnMaps;
    }

    public Table getOrigin(Plugin plugin) {
        return plugin.decorate(this.getOrigin());
    }

    public Table getTarget(Plugin plugin) {
        return plugin.decorate(this.getTarget());
    }

    public Relation getRelation() {
        return this._relation;
    }

    public Table getOrigin() {
        return this._origin;
    }

    public Table getTarget() {
        return this._target;
    }

    public boolean isMandatory() {
        if (this.isOriginPrimaryKey()) {
            return false;
        }
        ColumnMap[] columnMaps = this.getTargetRole().getColumnMaps();
        Table table = this.getTargetRole().getTarget();
        boolean result = false;
        int i = 0;
        while (i < columnMaps.length) {
            Column column = table.getColumn(columnMaps[i].getForeignKey());
            if (!column.isNullable()) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    protected String prefsPrefix() {
        return "relations/" + this.getRelation().getName() + "/" + this.getName();
    }

    void setTargetRole(RelationshipRole targetRole) {
        this._targetRole = targetRole;
    }
}

