/*
 * Decompiled with CFR 0.152.
 */
package middlegen;

import java.util.Collection;
import middlegen.Column;
import middlegen.ColumnDecorator;
import middlegen.DbTable;
import middlegen.PreferenceAware;
import middlegen.RelationshipRole;
import middlegen.Table;
import middlegen.TableElement;
import middlegen.predicates.column.Basic;
import middlegen.predicates.column.ForeignKey;
import middlegen.predicates.column.MandatoryBasic;
import middlegen.predicates.column.MandatoryNotKey;
import middlegen.predicates.column.NotKey;
import middlegen.predicates.column.PrimaryKey;
import middlegen.predicates.column.PrimaryNotForeignKey;
import middlegen.predicates.relation.Mandatory;
import middlegen.predicates.relation.TargetOne;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Category;

public class TableDecorator
extends PreferenceAware
implements Table {
    private final Table _subject;
    private Collection _columnDecorators;
    private Column _pkColumnDecorator;
    private boolean _isSimplePk;
    private boolean _isGenerate = true;
    private static Category _log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.TableDecorator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public TableDecorator(Table subject) {
        if (!(subject instanceof DbTable)) {
            StringBuffer stringBuffer = new StringBuffer("subject must be of class ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("middlegen.DbTable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new IllegalArgumentException(stringBuffer.append(clazz.getName()).append(". Was:").append(subject.getClass().getName()).toString());
        }
        this._subject = subject;
    }

    public void setGenerate(boolean flag) {
        this._isGenerate = flag;
    }

    public boolean isGenerate() {
        return this._isGenerate;
    }

    public String getSubDirPath() {
        return "";
    }

    public String getReplaceName() {
        return this.getSqlName();
    }

    public final String getSqlName() {
        return this._subject.getSqlName();
    }

    public final String getSqlName(boolean withSchemaPrefix) {
        return this._subject.getSqlName(withSchemaPrefix);
    }

    public String getSchemaPrefixedSqlName() {
        return this._subject.getSchemaPrefixedSqlName();
    }

    public TableElement getTableElement() {
        return this._subject.getTableElement();
    }

    public final String getSqlNameLowerCase() {
        return this.getSqlName().toLowerCase();
    }

    public Column getColumn(String sqlName) {
        return this.getPlugin().decorate(this._subject.getColumn(sqlName));
    }

    public final Collection getRelationshipRoles() {
        return this._subject.getRelationshipRoles();
    }

    public Collection getMandatoryRelationshipRoles() {
        return this.getRelationshipRoles(Mandatory.getInstance());
    }

    public Collection getOneRelationshipRoles() {
        return this.getRelationshipRoles(TargetOne.getInstance());
    }

    public final Collection getColumns() {
        return this._columnDecorators;
    }

    public final Collection getMandatoryColumns() {
        return this.getColumns(middlegen.predicates.column.Mandatory.getInstance());
    }

    public Collection getBasicColumns() {
        return this.getColumns(Basic.getInstance());
    }

    public Collection getPrimaryNotForeignKeyColumns() {
        return this.getColumns(PrimaryNotForeignKey.getInstance());
    }

    public Collection getForeignKeyColumns() {
        return this.getColumns(ForeignKey.getInstance());
    }

    public Collection getPrimaryKeyColumns() {
        return this.getColumns(PrimaryKey.getInstance());
    }

    public Collection getMandatoryBasicColumns() {
        return this.getColumns(MandatoryBasic.getInstance());
    }

    public Collection getMandatoryNotKeyColumns() {
        return this.getColumns(MandatoryNotKey.getInstance());
    }

    public Collection getNotKeyColumns() {
        return this.getColumns(NotKey.getInstance());
    }

    public final Column getPkColumn() {
        return this._pkColumnDecorator;
    }

    public boolean isSimplePk() {
        return this._isSimplePk;
    }

    public int getIndex(String columnSqlName) {
        return this._subject.getIndex(columnSqlName);
    }

    public Collection getColumns(Predicate predicate) {
        return CollectionUtils.select((Collection)this.getColumns(), (Predicate)predicate);
    }

    public Collection getRelationshipRoles(Predicate predicate) {
        return CollectionUtils.select((Collection)this.getRelationshipRoles(), (Predicate)predicate);
    }

    public final void addRelationshipRole(RelationshipRole relationshipRole) {
        this._subject.addRelationshipRole(relationshipRole);
    }

    protected final String prefsPrefix() {
        return String.valueOf(this.getPlugin().getName()) + "/tables/" + this.getSqlName();
    }

    protected void init() {
        super.init();
        this._isSimplePk = this.getPkColumn() != null;
    }

    void setColumnDecorators(Collection columnDecorators) {
        this._columnDecorators = columnDecorators;
    }

    void setPkColumnDecorator(ColumnDecorator pkColumnDecorator) {
        this._pkColumnDecorator = pkColumnDecorator;
    }
}

