/*
 * Decompiled with CFR 0.152.
 */
package middlegen.predicate.xml;

import java.util.Stack;
import middlegen.predicate.AttributedPredicate;
import middlegen.predicate.CompositePredicate;
import middlegen.predicate.PredicateException;
import middlegen.predicate.PredicateFactory;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Category;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class PredicateBuilder
extends DefaultHandler {
    private final Stack _stack = new Stack();
    private Predicate _predicate;
    private final PredicateFactory _predicateFactory;
    private static Category _log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("middlegen.predicate.xml.PredicateBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = Category.getInstance((String)clazz.getName());
    }

    public PredicateBuilder(PredicateFactory predicateFactory) {
        this._predicateFactory = predicateFactory;
    }

    public Predicate getPredicate() {
        return this._predicate;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        try {
            AttributedPredicate predicate = this._predicateFactory.createPredicate(qName);
            int i = 0;
            while (i < attributes.getLength()) {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                predicate.put(name, value);
                ++i;
            }
            if (!this._stack.isEmpty()) {
                Object parent = this._stack.peek();
                if (parent instanceof CompositePredicate) {
                    CompositePredicate compositePredicate = (CompositePredicate)parent;
                    compositePredicate.add(predicate);
                } else {
                    String msg = "Can't create a " + qName + " element here.";
                    _log.error((Object)msg);
                    throw new IllegalStateException(msg);
                }
            }
            this._stack.push(predicate);
        }
        catch (PredicateException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void endElement(String uri, String localName, String qName) {
        this._stack.pop();
    }
}

