/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.JCSCache;
import net.sf.hibernate.cache.NonstrictReadWriteCache;
import net.sf.hibernate.cache.ReadOnlyCache;
import net.sf.hibernate.cache.ReadWriteCache;
import net.sf.hibernate.cfg.Binder;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.cfg.Mappings;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.id.PersistentIdentifierGenerator;
import net.sf.hibernate.impl.SessionFactoryImpl;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.mapping.ForeignKey;
import net.sf.hibernate.mapping.Index;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.RootClass;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.tool.hbm2ddl.DatabaseMetadata;
import net.sf.hibernate.tool.hbm2ddl.TableMetadata;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.XMLHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.xml.sax.InputSource;

public class Configuration {
    private HashMap classes = new HashMap();
    private HashMap imports = new HashMap();
    private HashMap collections = new HashMap();
    private HashMap tables = new HashMap();
    private HashMap namedQueries = new HashMap();
    private ArrayList secondPasses = new ArrayList();
    private Interceptor interceptor = EMPTY_INTERCEPTOR;
    private Properties properties = Environment.getProperties();
    private static Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cfg$Configuration == null ? (class$net$sf$hibernate$cfg$Configuration = Configuration.class$("net.sf.hibernate.cfg.Configuration")) : class$net$sf$hibernate$cfg$Configuration));
    private Mapping mapping = new Mapping(){

        public Type getIdentifierType(Class persistentClass) throws MappingException {
            return ((PersistentClass)Configuration.this.classes.get(persistentClass)).getIdentifier().getType();
        }
    };
    private static final Interceptor EMPTY_INTERCEPTOR = new EmptyInterceptor();
    static /* synthetic */ Class class$net$sf$hibernate$cfg$Configuration;
    static /* synthetic */ Class class$net$sf$hibernate$cfg$Environment;

    protected void reset() {
        this.classes = new HashMap();
        this.collections = new HashMap();
        this.tables = new HashMap();
        this.namedQueries = new HashMap();
        this.secondPasses = new ArrayList();
        this.interceptor = EMPTY_INTERCEPTOR;
        this.properties = Environment.getProperties();
    }

    public Configuration() {
        this.reset();
    }

    public Iterator getClassMappings() {
        return this.classes.values().iterator();
    }

    public Iterator getCollectionMappings() {
        return this.collections.values().iterator();
    }

    private Iterator getTableMappings() {
        return this.tables.values().iterator();
    }

    public PersistentClass getClassMapping(Class persistentClass) {
        return (PersistentClass)this.classes.get(persistentClass);
    }

    public Collection getCollectionMapping(String role) {
        return (Collection)this.collections.get(role);
    }

    public Configuration addFile(String xmlFile) throws MappingException {
        log.info((Object)("Mapping file: " + xmlFile));
        try {
            this.add(XMLHelper.createSAXReader(xmlFile).read(new File(xmlFile)));
        }
        catch (Exception e) {
            log.error((Object)("Could not configure datastore from file: " + xmlFile), (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    public Configuration addFile(File xmlFile) throws MappingException {
        log.info((Object)("Mapping file: " + xmlFile.getPath()));
        try {
            this.addInputStream(new FileInputStream(xmlFile));
        }
        catch (Exception e) {
            log.error((Object)("Could not configure datastore from file: " + xmlFile.getPath()), (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    public Configuration addXML(String xml) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping XML:\n" + xml));
        }
        try {
            this.add(XMLHelper.createSAXReader("XML String").read((Reader)new StringReader(xml)));
        }
        catch (Exception e) {
            log.error((Object)"Could not configure datastore from XML", (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    public Configuration addURL(URL url) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping URL:\n" + url));
        }
        try {
            this.addInputStream(url.openStream());
        }
        catch (Exception e) {
            log.error((Object)"Could not configure datastore from URL", (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    public Configuration addDocument(org.w3c.dom.Document doc) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping XML:\n" + doc));
        }
        try {
            this.add(XMLHelper.createDOMReader().read(doc));
        }
        catch (Exception e) {
            log.error((Object)"Could not configure datastore from XML document", (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    protected void add(Document doc) throws Exception {
        try {
            Binder.bindRoot(doc, this.createMappings());
        }
        catch (MappingException me) {
            log.error((Object)"Could not compile the mapping document", (Throwable)((Object)me));
            throw me;
        }
    }

    public Mappings createMappings() {
        return new Mappings(this.classes, this.collections, this.tables, this.namedQueries, this.imports, this.secondPasses);
    }

    public Configuration addInputStream(InputStream xmlInputStream) throws MappingException {
        try {
            this.add(XMLHelper.createSAXReader("XML InputStream").read(new InputSource(xmlInputStream)));
            return this;
        }
        catch (MappingException me) {
            throw me;
        }
        catch (Exception e) {
            log.error((Object)"Could not configure datastore from input stream", (Throwable)e);
            throw new MappingException(e);
        }
    }

    public Configuration addResource(String path, ClassLoader classLoader) throws MappingException {
        log.info((Object)("Mapping resource: " + path));
        InputStream rsrc = classLoader.getResourceAsStream(path);
        if (rsrc == null) {
            throw new MappingException("Resource: " + path + " not found");
        }
        return this.addInputStream(rsrc);
    }

    public Configuration addClass(Class persistentClass) throws MappingException {
        String fileName = persistentClass.getName().replace('.', '/') + ".hbm.xml";
        log.info((Object)("Mapping resource: " + fileName));
        InputStream rsrc = persistentClass.getClassLoader().getResourceAsStream(fileName);
        if (rsrc == null) {
            throw new MappingException("Resource: " + fileName + " not found");
        }
        return this.addInputStream(rsrc);
    }

    public Configuration addJar(String resource) throws MappingException {
        JarFile jarFile;
        log.info((Object)("Searching for mapping documents in jar: " + resource));
        try {
            jarFile = new JarFile(Thread.currentThread().getContextClassLoader().getResource(resource).getFile());
        }
        catch (IOException ioe) {
            log.error((Object)"Could not configure datastore from jar", (Throwable)ioe);
            throw new MappingException(ioe);
        }
        if (jarFile == null) {
            throw new MappingException("Resource: " + resource + " not found");
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry z = enumeration.nextElement();
            if (!z.getName().endsWith(".hbm.xml")) continue;
            log.info((Object)("Found mapping documents in jar: " + z.getName()));
            try {
                this.addInputStream(jarFile.getInputStream(z));
            }
            catch (MappingException me) {
                throw me;
            }
            catch (Exception e) {
                log.error((Object)"Could not configure datastore from jar", (Throwable)e);
                throw new MappingException(e);
            }
        }
        return this;
    }

    private Iterator iterateGenerators(Dialect dialect) throws MappingException {
        HashMap<Object, IdentifierGenerator> generators = new HashMap<Object, IdentifierGenerator>();
        Iterator iter = this.classes.values().iterator();
        while (iter.hasNext()) {
            IdentifierGenerator ig = ((PersistentClass)iter.next()).getIdentifier().createIdentifierGenerator(dialect);
            if (!(ig instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        return generators.values().iterator();
    }

    public String[] generateDropSchemaScript(Dialect dialect) throws HibernateException {
        Table table;
        Iterator iter;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        if (dialect.dropConstraints()) {
            iter = this.getTableMappings();
            while (iter.hasNext()) {
                table = (Table)iter.next();
                Iterator subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    script.add(fk.sqlDropString(dialect));
                }
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            script.add(table.sqlDropString(dialect));
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            String dropString = ((PersistentIdentifierGenerator)iter.next()).sqlDropString(dialect);
            if (dropString == null) continue;
            script.add(dropString);
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateSchemaCreationScript(Dialect dialect) throws HibernateException {
        Table table;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        Iterator iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            script.add(table.sqlCreateString(dialect, this.mapping));
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            Iterator subIter;
            table = (Table)iter.next();
            if (dialect.hasAlterTable()) {
                subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    script.add(fk.sqlCreateString(dialect, this.mapping));
                }
            }
            subIter = table.getIndexIterator();
            while (subIter.hasNext()) {
                Index index = (Index)subIter.next();
                script.add(index.sqlCreateString(dialect, this.mapping));
            }
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            String[] lines = ((PersistentIdentifierGenerator)iter.next()).sqlCreateStrings(dialect);
            for (int i = 0; i < lines.length; ++i) {
                script.add(lines[i]);
            }
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateSchemaUpdateScript(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        TableMetadata tableInfo;
        Table table;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        Iterator iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            tableInfo = databaseMetadata.getTableMetadata(table.getName());
            if (tableInfo == null) {
                script.add(table.sqlCreateString(dialect, this.mapping));
                continue;
            }
            Iterator subiter = table.sqlAlterStrings(dialect, this.mapping, tableInfo);
            while (subiter.hasNext()) {
                script.add((String)subiter.next());
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            Iterator subIter;
            table = (Table)iter.next();
            tableInfo = databaseMetadata.getTableMetadata(table.getName());
            if (dialect.hasAlterTable()) {
                subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (tableInfo != null && tableInfo.getForeignKeyMetadata(fk.getName()) != null) continue;
                    script.add(fk.sqlCreateString(dialect, this.mapping));
                }
            }
            subIter = table.getIndexIterator();
            while (subIter.hasNext()) {
                Index index = (Index)subIter.next();
                if (tableInfo != null && tableInfo.getIndexMetadata(index.getName()) != null) continue;
                script.add(index.sqlCreateString(dialect, this.mapping));
            }
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            Object key = generator.generatorKey();
            if (databaseMetadata.isSequence(key) || databaseMetadata.isTable(key)) continue;
            String[] lines = generator.sqlCreateStrings(dialect);
            for (int i = 0; i < lines.length; ++i) {
                script.add(lines[i]);
            }
        }
        return ArrayHelper.toStringArray(script);
    }

    private void secondPassCompile() throws MappingException {
        log.info((Object)"processing one-to-many association mappings");
        Iterator iter = this.secondPasses.iterator();
        while (iter.hasNext()) {
            Binder.SecondPass sp = (Binder.SecondPass)iter.next();
            sp.doSecondPass(this.classes);
            iter.remove();
        }
        log.info((Object)"processing foreign key constraints");
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            Iterator subIter = table.getForeignKeyIterator();
            while (subIter.hasNext()) {
                PersistentClass referencedClass;
                ForeignKey fk = (ForeignKey)subIter.next();
                if (fk.getReferencedTable() != null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("resolving reference to class: " + fk.getReferencedClass().getName()));
                }
                if ((referencedClass = (PersistentClass)this.classes.get(fk.getReferencedClass())) == null) {
                    throw new MappingException("An association from the table " + fk.getTable().getName() + " refers to an unmapped class: " + fk.getReferencedClass().getName());
                }
                fk.setReferencedTable(referencedClass.getTable());
            }
        }
    }

    public Map getNamedQueries() {
        return this.namedQueries;
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        this.secondPassCompile();
        Environment.verifyProperties(this.properties);
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.properties);
        return new SessionFactoryImpl(this, copy, this.interceptor);
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Configuration setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Configuration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Configuration addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public Configuration setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
        return this;
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    private void addProperties(Element parent) {
        Iterator iter = parent.elementIterator("property");
        while (iter.hasNext()) {
            Element node = (Element)iter.next();
            String name = node.attributeValue("name");
            String value = node.getText();
            log.debug((Object)(name + "=" + value));
            this.properties.setProperty(name, value);
            if (name.startsWith("hibernate")) continue;
            this.properties.setProperty("hibernate." + name, value);
        }
        Environment.verifyProperties(this.properties);
    }

    protected InputStream getConfigurationInputStream(String resource) throws HibernateException {
        log.info((Object)("Configuration resource: " + resource));
        InputStream stream = (class$net$sf$hibernate$cfg$Environment == null ? (class$net$sf$hibernate$cfg$Environment = Configuration.class$("net.sf.hibernate.cfg.Environment")) : class$net$sf$hibernate$cfg$Environment).getResourceAsStream(resource);
        if (stream == null) {
            log.warn((Object)(resource + " not found"));
            throw new HibernateException(resource + " not found");
        }
        return stream;
    }

    public Configuration configure() throws HibernateException {
        this.configure("/hibernate.cfg.xml");
        return this;
    }

    public Configuration configure(String resource) throws HibernateException {
        InputStream stream = this.getConfigurationInputStream(resource);
        return this.configure(stream, resource);
    }

    public Configuration configure(URL url) throws HibernateException {
        try {
            return this.configure(url.openStream(), url.toString());
        }
        catch (IOException ioe) {
            throw new HibernateException("could not configure from URL: " + url, ioe);
        }
    }

    public Configuration configure(File configFile) throws HibernateException {
        try {
            return this.configure(new FileInputStream(configFile), configFile.toString());
        }
        catch (FileNotFoundException fnfe) {
            throw new HibernateException("could not find file: " + configFile, fnfe);
        }
    }

    protected Configuration configure(InputStream stream, String resourceName) throws HibernateException {
        Document doc;
        try {
            doc = XMLHelper.createSAXReader(resourceName).read(new InputSource(stream));
        }
        catch (Exception e) {
            log.error((Object)("problem parsing configuration" + resourceName), (Throwable)e);
            throw new HibernateException("problem parsing configuration" + resourceName, e);
        }
        return this.configure(doc);
    }

    public Configuration configure(org.w3c.dom.Document document) throws HibernateException {
        Document doc;
        try {
            doc = XMLHelper.createDOMReader().read(document);
        }
        catch (Exception e) {
            log.error((Object)"problem parsing document", (Throwable)e);
            throw new HibernateException("problem parsing document", e);
        }
        return this.configure(doc);
    }

    protected Configuration configure(Document doc) throws HibernateException {
        Element sfNode = doc.getRootElement().element("session-factory");
        String name = sfNode.attributeValue("name");
        if (name != null) {
            this.properties.setProperty("hibernate.session_factory_name", name);
        }
        this.addProperties(sfNode);
        Iterator elements = sfNode.elementIterator();
        while (elements.hasNext()) {
            Element mapElement = (Element)elements.next();
            String elemname = mapElement.getName();
            if ("mapping".equals(elemname)) {
                Attribute rsrc = mapElement.attribute("resource");
                Attribute file = mapElement.attribute("file");
                Attribute jar = mapElement.attribute("jar");
                if (rsrc != null) {
                    log.debug((Object)(name + "<-" + rsrc));
                    try {
                        this.addResource(rsrc.getValue(), Thread.currentThread().getContextClassLoader());
                    }
                    catch (MappingException me) {
                        this.addResource(rsrc.getValue(), (class$net$sf$hibernate$cfg$Environment == null ? Configuration.class$("net.sf.hibernate.cfg.Environment") : class$net$sf$hibernate$cfg$Environment).getClassLoader());
                    }
                    continue;
                }
                if (jar != null) {
                    log.debug((Object)(name + "<-" + jar));
                    this.addJar(jar.getValue());
                    continue;
                }
                if (file == null) {
                    throw new MappingException("<mapping> element in configuration specifies no attributes");
                }
                log.debug((Object)(name + "<-" + file));
                this.addFile(file.getValue());
                continue;
            }
            if ("jcs-class-cache".equals(elemname)) {
                RootClass pc;
                Class clazz;
                String className = mapElement.attributeValue("class");
                try {
                    clazz = ReflectHelper.classForName(className);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new MappingException("Could not find class: " + className, cnfe);
                }
                try {
                    pc = (RootClass)this.getClassMapping(clazz);
                }
                catch (ClassCastException cce) {
                    throw new MappingException("You may only specify a cache for root <class> mappings");
                }
                Attribute regionNode = mapElement.attribute("region");
                String region = className;
                if (regionNode != null) {
                    region = regionNode.getValue();
                }
                pc.setCache(Configuration.createJCSCache(mapElement.attributeValue("usage"), region, pc));
                continue;
            }
            if (!"jcs-collection-cache".equals(elemname)) continue;
            String role = mapElement.attributeValue("collection");
            Collection c = this.getCollectionMapping(role);
            Attribute regionNode = mapElement.attribute("region");
            String region = role;
            if (regionNode != null) {
                region = regionNode.getValue();
            }
            c.setCache(Configuration.createJCSCache(mapElement.attributeValue("usage"), region, c.getOwner()));
        }
        log.info((Object)("Configured SessionFactory: " + name));
        log.debug((Object)("properties: " + this.properties));
        return this;
    }

    static CacheConcurrencyStrategy createJCSCache(String usage, String name, PersistentClass owner) throws MappingException {
        JCSCache jcs;
        log.info((Object)("creating JCS cache region: " + name + ", usage: " + usage));
        try {
            jcs = new JCSCache();
        }
        catch (NoClassDefFoundError ncf) {
            log.warn((Object)"Could not instantiate cache - probably the JCS jar is missing", (Throwable)ncf);
            return null;
        }
        try {
            jcs.setRegion(name);
        }
        catch (CacheException ce) {
            throw new MappingException("Could not instantiate JCS", (Throwable)((Object)ce));
        }
        if (usage.equals("read-only")) {
            if (owner.isMutable()) {
                log.warn((Object)("read-only cache configured for mutable: " + name));
            }
            return new ReadOnlyCache(jcs);
        }
        if (usage.equals("read-write")) {
            return new ReadWriteCache(jcs);
        }
        if (usage.equals("nonstrict-read-write")) {
            return new NonstrictReadWriteCache(jcs);
        }
        throw new MappingException("jcs-cache usage attribute should be read-write or read-only");
    }

    public Map getImports() {
        return this.imports;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class EmptyInterceptor
    implements Interceptor,
    Serializable {
        EmptyInterceptor() {
        }

        public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        }

        public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
            return false;
        }

        public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            return false;
        }

        public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            return false;
        }

        public void onPostFlush(Object entity, Serializable id, Object[] currentState, String[] propertyNames, Type[] types) {
        }

        public void postFlush(Iterator entities) {
        }

        public void preFlush(Iterator entities) {
        }

        public Boolean isUnsaved(Object entity) {
            return null;
        }

        public Object instantiate(Class clazz, Serializable id) {
            return null;
        }

        public int[] findDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
            return null;
        }
    }
}

