/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.dialect.QueryFunctionStandard;
import net.sf.hibernate.dialect.TypeNames;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.hql.QueryFunctionInfo;
import net.sf.hibernate.sql.ANSICaseFragment;
import net.sf.hibernate.sql.ANSIJoinFragment;
import net.sf.hibernate.sql.CaseFragment;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Dialect {
    static final String DEFAULT_BATCH_SIZE = "15";
    static final String NO_BATCH = "0";
    private static final Map aggregateFunctions = new HashMap();
    private static final Log log;
    private final TypeNames typeNames = new TypeNames("$l");
    private final Properties properties = new Properties();
    public static final String QUOTE = "`\"[";
    public static final String CLOSED_QUOTE = "`\"]";
    static /* synthetic */ Class class$net$sf$hibernate$dialect$Dialect;

    protected Dialect() {
        log.info((Object)("Using dialect: " + this));
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getTypeName(int code) throws HibernateException {
        String result = this.typeNames.get(code);
        if (result == null) {
            throw new HibernateException("No default type mapping for (java.sql.Types) " + code);
        }
        return result;
    }

    public String getTypeName(int code, int length) throws HibernateException {
        String result = this.typeNames.get(code, length);
        if (result == null) {
            throw new HibernateException("No type mapping for (java.sql.Types) " + code + " of length " + length);
        }
        return result;
    }

    protected void register(int code, int capacity, String name) {
        this.typeNames.put(code, capacity, name);
    }

    protected void register(int code, String name) {
        this.typeNames.put(code, name);
    }

    public boolean hasAlterTable() {
        return true;
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public boolean supportsForUpdate() {
        return true;
    }

    public boolean supportsForUpdateOf() {
        return false;
    }

    public boolean supportsForUpdateNowait() {
        return false;
    }

    public boolean supportsUnique() {
        return true;
    }

    public String getAddColumnString() {
        throw new UnsupportedOperationException("No add column syntax supported by Dialect");
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey) {
        return new StringBuffer(30).append(" add constraint ").append(constraintName).append(" foreign key (").append(StringHelper.join(", ", foreignKey)).append(") references ").append(referencedTable).toString();
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint " + constraintName + " primary key ";
    }

    public String getNullColumnString() {
        return "";
    }

    public boolean supportsIdentityColumns() {
        return false;
    }

    public boolean supportsSequences() {
        return false;
    }

    public String getIdentitySelectString() throws MappingException {
        throw new MappingException("Dialect does not support native key generation");
    }

    public String getIdentityColumnString() throws MappingException {
        throw new MappingException("Dialect does not support native key generation");
    }

    public String getIdentityInsertString() {
        return null;
    }

    public String getNoColumnsInsertString() {
        return "values ( )";
    }

    public String getSequenceNextValString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String getCreateSequenceString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String getDropSequenceString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String getQuerySequencesString() {
        return null;
    }

    public static Dialect getDialect() throws HibernateException {
        String dialectName = Environment.getProperties().getProperty("hibernate.dialect");
        if (dialectName == null) {
            throw new HibernateException("The dialect was not set. Set the property hibernate.dialect.");
        }
        try {
            return (Dialect)ReflectHelper.classForName(dialectName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate dialect class", e);
        }
    }

    public static Dialect getDialect(Properties props) throws HibernateException {
        String dialectName = props.getProperty("hibernate.dialect");
        if (dialectName == null) {
            return Dialect.getDialect();
        }
        try {
            return (Dialect)ReflectHelper.classForName(dialectName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate dialect class", e);
        }
    }

    public final Properties getDefaultProperties() {
        return this.properties;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public JoinFragment createOuterJoinFragment() {
        return new ANSIJoinFragment();
    }

    public CaseFragment createCaseFragment() {
        return new ANSICaseFragment();
    }

    public String getLowercaseFunction() {
        return "lower";
    }

    public boolean supportsLimit() {
        return false;
    }

    public String getLimitString(String querySelect) {
        throw new UnsupportedOperationException("paged queries not supported");
    }

    public boolean bindLimitParametersInReverseOrder() {
        return false;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public boolean preferLimit() {
        return false;
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public Map getAggregateFunctions() {
        return aggregateFunctions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        aggregateFunctions.put("count", new QueryFunctionInfo(){

            public Type queryFunctionType(Type columnType, Mapping mapping) throws QueryException {
                return Hibernate.INTEGER;
            }

            public boolean isFunctionArgs() {
                return true;
            }

            public boolean isFunctionNoArgsUseParenthesis() {
                return true;
            }
        });
        aggregateFunctions.put("avg", new QueryFunctionInfo(){

            public Type queryFunctionType(Type columnType, Mapping mapping) throws QueryException {
                int[] sqlTypes;
                try {
                    sqlTypes = columnType.sqlTypes(mapping);
                }
                catch (MappingException me) {
                    throw new QueryException((Exception)((Object)me));
                }
                if (sqlTypes.length != 1) {
                    throw new QueryException("multi-column type in avg()");
                }
                int sqlType = sqlTypes[0];
                if (sqlType == 4 || sqlType == -5 || sqlType == -6) {
                    return Hibernate.FLOAT;
                }
                return columnType;
            }

            public boolean isFunctionArgs() {
                return true;
            }

            public boolean isFunctionNoArgsUseParenthesis() {
                return true;
            }
        });
        aggregateFunctions.put("max", new QueryFunctionStandard());
        aggregateFunctions.put("min", new QueryFunctionStandard());
        aggregateFunctions.put("sum", new QueryFunctionStandard());
        log = LogFactory.getLog((Class)(class$net$sf$hibernate$dialect$Dialect == null ? (class$net$sf$hibernate$dialect$Dialect = Dialect.class$("net.sf.hibernate.dialect.Dialect")) : class$net$sf$hibernate$dialect$Dialect));
    }
}

