/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.id;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.Configurable;
import net.sf.hibernate.id.IdentifierGenerationException;
import net.sf.hibernate.id.PersistentIdentifierGenerator;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.PropertiesHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableGenerator
implements PersistentIdentifierGenerator,
Configurable {
    public static final String COLUMN = "column";
    public static final String TABLE = "table";
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$id$TableGenerator == null ? (class$net$sf$hibernate$id$TableGenerator = TableGenerator.class$("net.sf.hibernate.id.TableGenerator")) : class$net$sf$hibernate$id$TableGenerator));
    private String tableName;
    private String columnName;
    private String query;
    private String update;
    static /* synthetic */ Class class$net$sf$hibernate$id$TableGenerator;

    public void configure(Type type, Properties params, Dialect dialect) {
        this.tableName = PropertiesHelper.getString(TABLE, params, "hibernate_unique_key");
        this.columnName = PropertiesHelper.getString(COLUMN, params, "next_hi");
        String schemaName = params.getProperty("schema");
        if (schemaName != null && this.tableName.indexOf(46) < 0) {
            this.tableName = schemaName + '.' + this.tableName;
        }
        this.query = "select " + this.columnName + " from " + this.tableName;
        if (dialect.supportsForUpdate()) {
            this.query = this.query + " for update";
        }
        this.update = "update " + this.tableName + " set " + this.columnName + " = ? where " + this.columnName + " = ?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Serializable generate(SessionImplementor session, Object object) throws SQLException, HibernateException {
        Connection conn = session.getFactory().openConnection();
        try {
            int result;
            int rows;
            do {
                PreparedStatement qps = conn.prepareStatement(this.query);
                try {
                    ResultSet rs = qps.executeQuery();
                    if (!rs.next()) {
                        String err = "could not read a hi value - you need to populate the table: " + this.tableName;
                        log.error((Object)err);
                        throw new IdentifierGenerationException(err);
                    }
                    result = rs.getInt(1);
                    rs.close();
                }
                catch (SQLException sqle) {
                    log.error((Object)"could not read a hi value", (Throwable)sqle);
                    throw sqle;
                }
                finally {
                    qps.close();
                }
                PreparedStatement ups = conn.prepareStatement(this.update);
                try {
                    ups.setInt(1, result + 1);
                    ups.setInt(2, result);
                    rows = ups.executeUpdate();
                }
                catch (SQLException sqle) {
                    log.error((Object)("could not update hi value in: " + this.tableName), (Throwable)sqle);
                    throw sqle;
                }
                finally {
                    ups.close();
                }
            } while (rows == 0);
            conn.commit();
            Integer n = new Integer(result);
            return n;
        }
        finally {
            session.getFactory().closeConnection(conn);
        }
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{"create table " + this.tableName + " ( " + this.columnName + " " + dialect.getTypeName(4) + " )", "insert into " + this.tableName + " values ( 0 )"};
    }

    public String sqlDropString(Dialect dialect) {
        return "drop table " + this.tableName + dialect.getCascadeConstraintsString();
    }

    public Object generatorKey() {
        return this.tableName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

