/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.ScheduledEntityAction;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.persister.ClassPersister;

final class ScheduledUpdate
extends ScheduledEntityAction
implements SessionImpl.Executable {
    private final Object[] fields;
    private final Object lastVersion;
    private final Object nextVersion;
    private final int[] dirtyFields;
    private final Object[] updatedState;

    public ScheduledUpdate(Serializable id, Object[] fields, int[] dirtyProperties, Object lastVersion, Object nextVersion, Object instance, Object[] updatedState, ClassPersister persister, SessionImplementor session) {
        super(session, id, instance, persister);
        this.fields = fields;
        this.lastVersion = lastVersion;
        this.nextVersion = nextVersion;
        this.dirtyFields = dirtyProperties;
        this.updatedState = updatedState;
    }

    public void execute() throws SQLException, HibernateException {
        if (this.getPersister().hasCache()) {
            this.getPersister().getCache().lock(this.getId());
        }
        this.getPersister().update(this.getId(), this.fields, this.dirtyFields, this.lastVersion, this.getInstance(), this.getSession());
        this.getSession().postUpdate(this.getInstance(), this.updatedState, this.nextVersion);
    }

    public void afterTransactionCompletion() throws CacheException {
        if (this.getPersister().hasCache()) {
            this.getPersister().getCache().release(this.getId());
        }
    }
}

