/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.sql;

import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.sql.Alias;
import net.sf.hibernate.sql.CaseFragment;
import org.apache.commons.collections.SequencedHashMap;

public class HSQLCaseFragment
extends CaseFragment {
    private String returnColumnName;
    private Map cases = new SequencedHashMap();

    public CaseFragment setReturnColumnName(String returnColumnName) {
        this.returnColumnName = returnColumnName;
        return this;
    }

    public CaseFragment setReturnColumnName(String returnColumnName, String suffix) {
        return this.setReturnColumnName(new Alias(suffix).toAliasString(returnColumnName));
    }

    public CaseFragment addWhenColumnNotNull(String alias, String columnName, String value) {
        this.cases.put(alias + '.' + columnName + " is not null", value);
        return this;
    }

    public String toFragmentString() {
        StringBuffer buf = new StringBuffer(this.cases.size() * 15 + 10);
        StringBuffer buf2 = new StringBuffer(this.cases.size());
        Iterator iter = this.cases.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            buf.append(" casewhen(").append(me.getKey()).append(", ").append(me.getValue()).append(", ");
            buf2.append(")");
        }
        buf.append("-1");
        buf.append(buf2);
        if (this.returnColumnName != null) {
            buf.append(" as ").append(this.returnColumnName);
        }
        return buf.toString();
    }
}

