/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2ddl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.tool.hbm2ddl.SchemaExport;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;

public class SchemaExportTask
extends MatchingTask {
    private List fileSets = new LinkedList();
    private File propertiesFile = null;
    private String configurationFile = null;
    private String outputFile = null;
    private boolean quiet = false;
    private boolean text = false;
    private boolean drop = false;
    private String delimiter = null;

    public void addFileset(FileSet set) {
        this.fileSets.add(set);
    }

    public void setProperties(File propertiesFile) {
        if (!propertiesFile.exists()) {
            throw new BuildException("Properties file: " + propertiesFile + " does not exist.");
        }
        this.log("Using properties file " + propertiesFile, 4);
        this.propertiesFile = propertiesFile;
    }

    public void setConfig(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setText(boolean text) {
        this.text = text;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setOutput(String outputFile) {
        this.outputFile = outputFile;
    }

    public void execute() throws BuildException {
        try {
            Configuration cfg = this.getConfiguration();
            SchemaExport schemaExport = this.getSchemaExport(cfg);
            if (this.drop) {
                schemaExport.drop(!this.quiet, !this.text);
            } else {
                schemaExport.create(!this.quiet, !this.text);
            }
        }
        catch (HibernateException e) {
            throw new BuildException("Schema text failed: " + e.getMessage(), (Throwable)((Object)e));
        }
        catch (FileNotFoundException e) {
            throw new BuildException("File not found: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("IOException : " + e.getMessage(), (Throwable)e);
        }
    }

    private String[] getFiles() {
        LinkedList<String> files = new LinkedList<String>();
        Iterator i = this.fileSets.iterator();
        while (i.hasNext()) {
            FileSet fs = (FileSet)i.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            String[] dsFiles = ds.getIncludedFiles();
            for (int j = 0; j < dsFiles.length; ++j) {
                File f = new File(dsFiles[j]);
                if (!f.isFile()) {
                    f = new File(ds.getBasedir(), dsFiles[j]);
                }
                files.add(f.getAbsolutePath());
            }
        }
        return files.toArray(new String[0]);
    }

    private Configuration getConfiguration() throws HibernateException {
        Configuration cfg = new Configuration();
        if (this.configurationFile != null) {
            cfg.configure(this.configurationFile);
        }
        String[] files = this.getFiles();
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i];
            if (filename.endsWith(".jar")) {
                cfg.addJar(filename);
                continue;
            }
            cfg.addFile(filename);
        }
        return cfg;
    }

    private SchemaExport getSchemaExport(Configuration cfg) throws HibernateException, IOException {
        SchemaExport schemaExport = null;
        if (this.propertiesFile == null) {
            schemaExport = new SchemaExport(cfg);
        } else {
            Properties properties = new Properties();
            properties.load(new FileInputStream(this.propertiesFile));
            schemaExport = new SchemaExport(cfg, properties);
        }
        schemaExport.setOutputFile(this.outputFile);
        schemaExport.setDelimiter(this.delimiter);
        return schemaExport;
    }
}

